/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.generator.html;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.rcp.collateral.generator.html.HtmlGeneratorActivator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class HtmlTemplateUtil {
    private static final String TEMPLATE_EXTENSION = ".html";

    public static String getTemplateContent(String templateName, String serverContentPath) {
        String templateContent = "";
        try {
            File bundleFile = HtmlGeneratorActivator.getBundleFolder();
            String templatePath = HtmlTemplateUtil.createTemplatePath(templateName, bundleFile, serverContentPath);
            IStatus status = HtmlTemplateUtil.validateTemplatePath(templatePath);
            if (status.isOK()) {
                templateContent = HtmlTemplateUtil.readTemplateFile(templatePath, StandardCharsets.UTF_8);
            } else {
                Log.log((IStatus)status);
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.generator", e.getMessage(), (Throwable)e);
            Log.log((IStatus)status);
        }
        return templateContent;
    }

    private static String createTemplatePath(String templateName, File bundleFile, String serverContentPath) {
        return String.valueOf(serverContentPath) + File.separator + templateName + TEMPLATE_EXTENSION;
    }

    private static IStatus validateTemplatePath(String templatePath) {
        File template = new File(templatePath);
        if (!template.exists()) {
            return new Status(4, "com.nxp.s32ds.rcp.collateral.generator", "File does not exist");
        }
        if (!template.isFile()) {
            return new Status(4, "com.nxp.s32ds.rcp.collateral.generator", "File id not file");
        }
        if (!template.canRead()) {
            return new Status(4, "com.nxp.s32ds.rcp.collateral.generator", "No read rights");
        }
        return Status.OK_STATUS;
    }

    static String readTemplateFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String removeUnusedAttributes(String templateContent) {
        return templateContent.replaceAll("%([^<]*)%", "");
    }
}

