/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.generator.html;

import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.generator.IContentGenerator;
import com.nxp.s32ds.rcp.collateral.generator.html.HtmlGeneratorActivator;
import com.nxp.s32ds.rcp.collateral.generator.html.HtmlTemplateUtil;
import com.nxp.s32ds.rcp.collateral.generator.html.HtmlUtil;
import com.nxp.s32ds.rcp.collateral.generator.html.Messages;
import com.nxp.s32ds.rcp.collateral.generator.html.NavigationLinkObject;
import com.nxp.s32ds.rcp.collateral.generator.html.UrlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Platform;

public class HtmlContentGenerator
implements IContentGenerator {
    private static final String MP4 = ".mp4";
    private static final String PDF_EXTENSION = ".pdf";
    private static final String ATTR_RES_FRAIM = "%iframe%";
    private static final String ATTR_RES_VIDEO = "%video%";
    private static final String APP_SELECTED = "app-selected";
    private static final String ATTR_RES_TREE = "%res-tree%";
    private static final String ATTR_RES_TREE_ITEM_BLOCK = "res-tree-item-block";
    private static final String ATTR_RES_ITEM_CLASS = "%res-item-class%";
    private static final String ATTR_RES_ITEM_PACKID = "%res-item-packid%";
    private static final String ATTR_NAMERES_ITEM_ID = "%res-item-id%";
    private static final String ATTR_RES_ITEM_NAME = "%res-item-name%";
    private static final String ATTR_IS_CHECKED_DEFAULT = "checked";
    private static final String ATTR_RES_CAT_ITEMS = "%res-cat-items%";
    private static final String ATTR_IS_CHECKED = "%is-checked%";
    private static final String ATTR_RES_CAT_ID = "%res-cat-id%";
    private static final String ATTR_RES_CAT_NAME = "%res-cat-name%";
    private static final String ATTR_RES_TREE_CAT_BLOCK = "res-tree-cat-block";
    private static final String RESOURCE_ID_DEFAULT = "com.nxp.s32ds.platform.ide.collateral.resources.resource.quickStart";
    private static final String COLLATERAL_TAG = "com.nxp.s32ds.platform.ide.collateral.tags.tag.";
    private static final String ATTR_SELECTED_IMAGE_DEFAULT = "/res/images/app-selector-gears.png";
    private static final String ATTR_SELECTED_NAME_DEFAULT = "Select Package/Application";
    private static final String ATTR_PACKAGE_ID = "%package-id%";
    private static final String ATTR_APP_SELECTED_CLASS = "%app-selected-class%";
    private static final String ATTR_RESOURCE_URL = "%resource-url%";
    private static final String ATTR_RESOURCE_LINK = "%resource-link%";
    private static final String ATTR_RESOURCE_DESCRIPTION = "%resource-description%";
    private static final String ATTR_RESOURCE_TITLE = "%resource-title%";
    private static final String ATTR_SELECTED_NAME = "%app-selected-name%";
    private static final String ATTR_SELECTED_IMAGE = "%app-selected-image%";
    private static final String HIDDEN_CAT_ID = "com.nxp.s32ds.platform.ide.collateral.resources.resourceType.dummyCat";
    private static final String TAG_PRODUCT_DOCUMENTS = "com.nxp.s32ds.platform.ide.collateral.tags.tag.productDocuments";
    private static final String TAG_SUPPORT = "com.nxp.s32ds.platform.ide.collateral.tags.tag.support";
    private static final String TAG_COMMUNITIES = "com.nxp.s32ds.platform.ide.collateral.tags.tag.communities";
    private static final String TAG_HARDWARE_MANUALS = "com.nxp.s32ds.platform.ide.collateral.tags.tag.hardwareManuals";
    private static final String TAG_SW_AND_TOOLS_GUIDES = "com.nxp.s32ds.platform.ide.collateral.tags.tag.SWandToolsGuides";
    private static final String TAG_TUTORIALS = "com.nxp.s32ds.platform.ide.collateral.tags.tag.tutorials";
    private static final String TAG_QUICK_START = "com.nxp.s32ds.platform.ide.collateral.tags.tag.quickStart";
    private static final String TAG_CREATE_NEW_PROJECT = "com.nxp.s32ds.platform.ide.collateral.tags.tag.createNewProject";
    private static final String PREFIX_S32DS = "S32DS";
    private static final String SHARP = "#";
    private CollateralRegistry collaterallModel;
    private String serverContentPath;

    @Override
    public void init(CollateralRegistry collaterallModel, String serverContentPath) {
        this.collaterallModel = collaterallModel;
        this.serverContentPath = serverContentPath;
    }

    private String setupTemplate(String template, String toReplace, NavigationLinkObject navlink) {
        String html = HtmlTemplateUtil.getTemplateContent("template", this.serverContentPath);
        html = this.getMenuActiveChange(html, toReplace);
        html = html.replace("%breadcrumbs%", this.generateBreadcrumbs(navlink));
        html = html.replace("%content%", HtmlTemplateUtil.getTemplateContent(template, this.serverContentPath));
        return html;
    }

    private String getMenuActiveChange(String template, String activeMenuItem) {
        template = template.replace("%getting-started%", activeMenuItem == "%getting-started%" ? "active" : "");
        template = template.replace("%packages%", activeMenuItem == "%packages%" ? "active" : "");
        template = template.replace("%collateral%", activeMenuItem == "%collateral%" ? "active" : "");
        template = template.replace("%support%", activeMenuItem == "%support%" ? "active" : "");
        template = template.replace("%resources%", activeMenuItem == "%resources%" ? "active" : "");
        return template;
    }

    private String generateBreadcrumbs(NavigationLinkObject navLink) {
        String html = "";
        NavigationLinkObject parentIter = navLink.getParent();
        while (parentIter != null) {
            html = String.valueOf(HtmlUtil.generateLink(parentIter.getLabel(), parentIter.getHref())) + html;
            parentIter = parentIter.getParent();
        }
        html = String.valueOf(html) + HtmlUtil.generateLink(navLink.getLabel(), SHARP, navLink.getLabel(), "breadcrumbs-active");
        return html;
    }

    private String generateLinksList(Collection<CollateralResource> crList) {
        String html = "";
        for (CollateralResource cr : crList) {
            html = String.valueOf(html) + HtmlUtil.wrapLiTag(HtmlUtil.generateLink(cr.getName(), cr.getUrlLink(), ""));
        }
        return html;
    }

    private String generatePackageCategoriesList(String packageId) {
        String catListHtml = "";
        for (CollateralResourceType cat : this.collaterallModel.getAllResourceTypes()) {
            if (!this.catHasPackageResources(cat.getId(), packageId) || this.categoryIsHidden(cat)) continue;
            catListHtml = String.valueOf(catListHtml) + HtmlUtil.wrapLiTag(HtmlUtil.generateLink(cat.getName(), UrlUtil.getPackCategoryOverviewUrl(packageId, cat.getId()), cat.getDescription()));
        }
        return catListHtml;
    }

    private String generateFeatureCategoriesList(String featureId) {
        String catListHtml = "";
        for (CollateralResourceType cat : this.collaterallModel.getAllResourceTypes()) {
            if (!this.catHasFeatureResources(cat.getId(), featureId) || this.categoryIsHidden(cat)) continue;
            catListHtml = String.valueOf(catListHtml) + HtmlUtil.wrapLiTag(HtmlUtil.generateLink(cat.getName(), UrlUtil.getFeatureCategoryOverviewUrl(featureId, cat.getId()), cat.getDescription()));
        }
        return catListHtml;
    }

    private boolean categoryIsHidden(CollateralResourceType category) {
        return category.getId().equals(HIDDEN_CAT_ID);
    }

    private boolean isResourceInPackage(CollateralResource resource, CollateralPack pack) {
        for (CollateralFeature cf : pack.getFeatures()) {
            for (CollateralResource cr : cf.getResources()) {
                if (!cr.equals(resource)) continue;
                return true;
            }
        }
        return false;
    }

    private CollateralResourceType getCategoryById(String categoryId) {
        for (CollateralResourceType crt : this.collaterallModel.getAllResourceTypes()) {
            if (!crt.getId().equals(categoryId)) continue;
            return crt;
        }
        return null;
    }

    private boolean catHasPackageResources(String catId, String packageId) {
        for (CollateralResource cr : this.collaterallModel.getAllResources()) {
            if (!cr.getResourceType().getId().equals(catId) || !this.isResourceInPackage(cr, this.collaterallModel.getPacksById(packageId))) continue;
            return true;
        }
        return false;
    }

    private boolean catHasFeatureResources(String catId, String featureId) {
        for (CollateralResource cr : this.collaterallModel.getAllResources()) {
            if (!cr.getResourceType().getId().equals(catId) || !cr.getFeature().getId().equals(featureId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String generateGettingStarted() {
        String html = this.setupTemplate("getting-started", "%getting-started%", new NavigationLinkObject(Messages.LabelGettingStarted, SHARP, null));
        html = html.replace("%createNew%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_CREATE_NEW_PROJECT)));
        html = html.replace("%quickStart%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_QUICK_START)));
        html = html.replace("%tutorials%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_TUTORIALS)));
        return html;
    }

    @Override
    public String generatePackages() {
        String html = this.setupTemplate("packages", "%packages%", new NavigationLinkObject(Messages.LabelPackages, SHARP, null));
        String packagesHtml = "";
        for (CollateralPack p : this.collaterallModel.getAllPacks()) {
            String pHtml = HtmlTemplateUtil.getTemplateContent("feature-block", this.serverContentPath);
            pHtml = pHtml.replace("%feature-class%", "");
            String imgPath = p.getImagePath() != null ? p.getImagePath() : p.getId();
            pHtml = pHtml.replace("%feature-image%", imgPath);
            pHtml = pHtml.replace("%feature-name%", p.getName());
            pHtml = pHtml.replace("%feature-description%", p.getDescription());
            pHtml = pHtml.replace("%feature-id%", p.getId());
            pHtml = pHtml.replace("%overview-link%", UrlUtil.getPackOverviewUrl(p.getId()));
            pHtml = pHtml.replace("%categories-list%", this.generatePackageCategoriesList(p.getId()));
            packagesHtml = String.valueOf(packagesHtml) + pHtml;
        }
        html = html.replace("%packages%", packagesHtml);
        return html;
    }

    @Override
    public String generatePackageOverview(String packageId) {
        String packageName = this.collaterallModel.getPacksById(packageId).getName();
        String packageLink = UrlUtil.getPackagesUrl();
        NavigationLinkObject parent = new NavigationLinkObject(Messages.LabelPackages, packageLink, null);
        NavigationLinkObject navLink = new NavigationLinkObject(packageName, SHARP, parent);
        String html = this.setupTemplate("package-overview", "%packages%", navLink);
        html = html.replace("%package%", packageName);
        String column1Html = "";
        String column2Html = "";
        int iteratorInt = 0;
        for (CollateralResourceType cat : this.collaterallModel.getAllResourceTypes()) {
            if (cat.getName().equals("Videos") || this.categoryIsHidden(cat)) continue;
            ArrayList<CollateralResource> clList = new ArrayList<CollateralResource>();
            for (CollateralFeature cf : this.collaterallModel.getPacksById(packageId).getFeatures()) {
                for (CollateralResource cl : cf.getResources()) {
                    if (!cl.getResourceType().equals(cat)) continue;
                    clList.add(cl);
                }
            }
            String catHtml = HtmlTemplateUtil.getTemplateContent("content-block", this.serverContentPath);
            catHtml = catHtml.replace("%title%", cat.getName());
            catHtml = catHtml.replace("%description%", cat.getDescription());
            catHtml = catHtml.replace("%links-list%", this.generateLinksList(clList));
            if (clList.size() <= 0) continue;
            if (iteratorInt % 2 == 0) {
                column1Html = String.valueOf(column1Html) + catHtml;
            } else {
                column2Html = String.valueOf(column2Html) + catHtml;
            }
            ++iteratorInt;
        }
        html = html.replace("%column1%", column1Html);
        html = html.replace("%column2%", column2Html);
        return html;
    }

    @Override
    public String generatePackageFeatures(String packageId) {
        String packageName = this.collaterallModel.getPacksById(packageId).getName();
        NavigationLinkObject navLink = new NavigationLinkObject(Messages.LabelFeatures, SHARP, new NavigationLinkObject(packageName, UrlUtil.getPackOverviewUrl(packageId), new NavigationLinkObject(Messages.LabelPackages, UrlUtil.getPackagesUrl(), null)));
        String html = this.setupTemplate("features", "%packages%", navLink);
        String featuresHtml = "";
        for (CollateralFeature f : this.collaterallModel.getPackFeatures(packageId)) {
            String pHtml = HtmlTemplateUtil.getTemplateContent("feature-block", this.serverContentPath);
            pHtml = pHtml.replace("%feature-class%", "the-feature");
            pHtml = pHtml.replace("%feature-image%", f.getId());
            pHtml = pHtml.replace("%feature-name%", f.getName());
            pHtml = pHtml.replace("%feature-id%", f.getId());
            pHtml = pHtml.replace("%overview-link%", UrlUtil.getPackFeatureOverviewUrl(f.getId()));
            pHtml = pHtml.replace("%categories-list%", this.generateFeatureCategoriesList(f.getId()));
            featuresHtml = String.valueOf(featuresHtml) + pHtml;
        }
        html = html.replace("%features%", featuresHtml);
        html = html.replace("%package-name%", packageName);
        return html;
    }

    @Override
    public String generatePackageFeatureOverview(String featureId) {
        CollateralFeature cf = this.collaterallModel.getFeatureById(featureId);
        NavigationLinkObject currPkgNL = new NavigationLinkObject(cf.getPack().getName(), UrlUtil.getPackFeaturesUrl(cf.getPack().getId()), new NavigationLinkObject(Messages.LabelPackages, UrlUtil.getPackagesUrl(), null));
        NavigationLinkObject navLink = new NavigationLinkObject(cf.getName(), SHARP, currPkgNL);
        String html = this.setupTemplate("package-overview", "%packages%", navLink);
        html = html.replace("%package%", cf.getName());
        String column1Html = "";
        String column2Html = "";
        int iteratorInt = 0;
        for (CollateralResourceType cat : this.collaterallModel.getAllResourceTypes()) {
            if (this.categoryIsHidden(cat)) continue;
            ArrayList<CollateralResource> clList = new ArrayList<CollateralResource>();
            for (CollateralResource cl : this.collaterallModel.getResourcesByResourcesTypeIdAndFeatureId(cat.getId(), featureId)) {
                clList.add(cl);
            }
            String catHtml = HtmlTemplateUtil.getTemplateContent("content-block", this.serverContentPath);
            catHtml = catHtml.replace("%title%", cat.getName());
            catHtml = catHtml.replace("%description%", cat.getDescription());
            catHtml = catHtml.replace("%links-list%", this.generateLinksList(clList));
            if (clList.size() <= 0) continue;
            if (iteratorInt % 2 == 0) {
                column1Html = String.valueOf(column1Html) + catHtml;
            } else {
                column2Html = String.valueOf(column2Html) + catHtml;
            }
            ++iteratorInt;
        }
        html = html.replace("%column1%", column1Html);
        html = html.replace("%column2%", column2Html);
        return html;
    }

    @Override
    public String generatePackageCategoryOverview(String packageId, String categoryId) {
        CollateralResourceType cat = this.getCategoryById(categoryId);
        CollateralPack cp = this.collaterallModel.getPacksById(packageId);
        NavigationLinkObject currPkgNL = new NavigationLinkObject(cp.getName(), UrlUtil.getPackFeaturesUrl(packageId), new NavigationLinkObject(Messages.LabelPackages, UrlUtil.getPackagesUrl(), null));
        String html = this.setupTemplate("category", "%packages%", new NavigationLinkObject(cat.getName(), SHARP, currPkgNL));
        ArrayList<CollateralResource> clList = new ArrayList<CollateralResource>();
        for (CollateralResource cr : this.collaterallModel.getResourcesByResourceType(categoryId)) {
            if (!this.isResourceInPackage(cr, cp)) continue;
            clList.add(cr);
        }
        html = html.replace("%category-content%", this.generateLinksList(clList));
        html = html.replace("%category-name%", cat.getName());
        html = html.replace("%category-description%", cat.getDescription());
        return html;
    }

    @Override
    public String generateFeatureCategoryOverview(String featureId, String categoryId) {
        CollateralResourceType cat = this.getCategoryById(categoryId);
        CollateralFeature cf = this.collaterallModel.getFeatureById(featureId);
        NavigationLinkObject currPkgNL = new NavigationLinkObject(cf.getPack().getName(), UrlUtil.getPackFeaturesUrl(cf.getPack().getId()), new NavigationLinkObject(Messages.LabelPackages, UrlUtil.getPackagesUrl(), null));
        NavigationLinkObject currFtrNL = new NavigationLinkObject(cf.getName(), UrlUtil.getPackFeatureOverviewUrl(featureId), currPkgNL);
        String html = this.setupTemplate("category", "%packages%", new NavigationLinkObject(cat.getName(), SHARP, currFtrNL));
        ArrayList<CollateralResource> clList = new ArrayList<CollateralResource>();
        for (CollateralResource cr : this.collaterallModel.getResourcesByResourcesTypeIdAndFeatureId(categoryId, featureId)) {
            clList.add(cr);
        }
        html = html.replace("%category-content%", this.generateLinksList(clList));
        html = html.replace("%category-name%", cat.getName());
        html = html.replace("%category-description%", cat.getDescription());
        return html;
    }

    @Override
    public String generateCollateral() {
        String html = this.setupTemplate("collateral", "%collateral%", new NavigationLinkObject(Messages.LabelCollateral, SHARP, null));
        html = html.replace("%tutorials%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_TUTORIALS)));
        html = html.replace("%tools%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_SW_AND_TOOLS_GUIDES)));
        html = html.replace("%hardware%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_HARDWARE_MANUALS)));
        return html;
    }

    @Override
    public String generateSupport() {
        String html = this.setupTemplate("support", "%support%", new NavigationLinkObject(Messages.LabelSupport, SHARP, null));
        html = html.replace("%communities%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_COMMUNITIES)));
        html = html.replace("%support%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_SUPPORT)));
        html = html.replace("%product-documents%", this.generateLinksList(this.collaterallModel.getResourcesByTag(TAG_PRODUCT_DOCUMENTS)));
        return html;
    }

    @Override
    public String generateResources(String resourceId, String packageId) {
        String html = this.setupTemplate("resources", "%resources%", new NavigationLinkObject(Messages.LabelResources, SHARP, null));
        CollateralResource collateralResource = null;
        if (resourceId != null) {
            for (CollateralResource resource : this.collaterallModel.getAllResources()) {
                if (!resource.getId().equals(resourceId)) continue;
                collateralResource = resource;
            }
        } else {
            resourceId = RESOURCE_ID_DEFAULT;
        }
        if (collateralResource != null) {
            NavigationLinkObject resNVL = new NavigationLinkObject(Messages.LabelResources, "/?page=resources", null);
            NavigationLinkObject catNVL = new NavigationLinkObject(collateralResource.getResourceType().getName(), SHARP, resNVL);
            NavigationLinkObject currNVL = new NavigationLinkObject(collateralResource.getName(), SHARP, catNVL);
            html = this.setupTemplate("resources", "%resources%", currNVL);
            html = this.isMP4(collateralResource) ? this.replaceToVidoeContent(html, collateralResource) : this.replaceToTextOrImageContent(html);
            if (this.isPDF(collateralResource)) {
                String currLink = "/" + collateralResource.getUrlLink().substring(collateralResource.getUrlLink().indexOf(PREFIX_S32DS));
                html = html.replace(ATTR_RESOURCE_URL, currLink);
            }
            html = html.replace(ATTR_RESOURCE_TITLE, collateralResource.getName());
            html = html.replace(ATTR_RESOURCE_DESCRIPTION, collateralResource.getDescription());
            html = html.replace(ATTR_RESOURCE_LINK, collateralResource.getUrlLink());
            collateralResource.getFeature().getPack().getId();
        } else {
            HtmlGeneratorActivator.log(Messages.CollateralResourceNotDefined_Error);
        }
        if (packageId != null && !packageId.isEmpty()) {
            CollateralPack currPack = this.collaterallModel.getPacksById(packageId);
            html = html.replace(ATTR_SELECTED_NAME, currPack.getName());
            html = html.replace(ATTR_SELECTED_IMAGE, currPack.getImagePath());
        } else {
            html = html.replace(ATTR_SELECTED_NAME, ATTR_SELECTED_NAME_DEFAULT);
            html = html.replace(ATTR_SELECTED_IMAGE, ATTR_SELECTED_IMAGE_DEFAULT);
        }
        html = html.replace(ATTR_APP_SELECTED_CLASS, packageId == null || packageId == "" ? APP_SELECTED : "");
        String packagesHtml = "";
        for (CollateralPack p : this.collaterallModel.getAllPacks()) {
            String pHtml = HtmlTemplateUtil.getTemplateContent("app-selector-block", this.serverContentPath);
            String imgPath = p.getImagePath() != null ? p.getImagePath() : p.getId();
            pHtml = pHtml.replace("%feature-image%", imgPath);
            pHtml = pHtml.replace("%feature-name%", p.getName());
            pHtml = pHtml.replace(ATTR_PACKAGE_ID, p.getId());
            pHtml = pHtml.replace(ATTR_APP_SELECTED_CLASS, p.getId().equals(packageId) ? APP_SELECTED : "");
            packagesHtml = String.valueOf(packagesHtml) + pHtml;
        }
        html = html.replace("%packages%", packagesHtml);
        String resTreeHtml = "";
        for (CollateralResourceType cat : this.collaterallModel.getAllResourceTypes()) {
            Set clList;
            if (this.categoryIsHidden(cat) || (clList = this.collaterallModel.getResourcesByResourceType(cat.getId())).isEmpty()) continue;
            String catItemsHtml = "";
            for (CollateralResource cl : clList) {
                if (!cl.getFeature().getPack().getId().equals(packageId) && packageId != null) continue;
                String catItemHtml = HtmlTemplateUtil.getTemplateContent(ATTR_RES_TREE_ITEM_BLOCK, this.serverContentPath);
                catItemHtml = catItemHtml.replace(ATTR_RES_ITEM_NAME, cl.getName());
                catItemHtml = catItemHtml.replace(ATTR_NAMERES_ITEM_ID, cl.getId());
                catItemHtml = packageId != null && packageId != "" ? catItemHtml.replace(ATTR_RES_ITEM_PACKID, "&package=" + packageId) : catItemHtml.replace(ATTR_RES_ITEM_PACKID, "");
                if (collateralResource != null && collateralResource.getId().equals(cl.getId())) {
                    catItemHtml = catItemHtml.replace(ATTR_RES_ITEM_CLASS, "current");
                }
                catItemsHtml = String.valueOf(catItemsHtml) + catItemHtml;
            }
            if (catItemsHtml.isEmpty()) continue;
            String catHtml = HtmlTemplateUtil.getTemplateContent(ATTR_RES_TREE_CAT_BLOCK, this.serverContentPath);
            catHtml = catHtml.replace(ATTR_RES_CAT_NAME, cat.getName());
            catHtml = catHtml.replace(ATTR_RES_CAT_ID, cat.getId());
            catHtml = collateralResource != null && collateralResource.getResourceType().equals(cat) ? catHtml.replace(ATTR_IS_CHECKED, ATTR_IS_CHECKED_DEFAULT) : catHtml.replace(ATTR_IS_CHECKED, "");
            catHtml = catHtml.replace(ATTR_RES_CAT_ITEMS, catItemsHtml);
            resTreeHtml = String.valueOf(resTreeHtml) + catHtml;
        }
        html = html.replace(ATTR_RES_TREE, resTreeHtml);
        return html;
    }

    private String replaceToTextOrImageContent(String html) {
        String catHtml = HtmlTemplateUtil.getTemplateContent("iframe", this.serverContentPath);
        html = html.replace(ATTR_RES_VIDEO, "");
        html = html.replace(ATTR_RES_FRAIM, catHtml);
        return html;
    }

    private String replaceToVidoeContent(String html, CollateralResource collateralResource) {
        String catHtml = HtmlTemplateUtil.getTemplateContent("video", this.serverContentPath);
        html = html.replace(ATTR_RES_FRAIM, "");
        html = html.replace(ATTR_RES_VIDEO, catHtml);
        html = html.replace(ATTR_RESOURCE_URL, collateralResource.getUrlLink());
        return html;
    }

    private boolean isPDF(CollateralResource collateralResource) {
        return collateralResource.getUrlLink().indexOf(PREFIX_S32DS) > 0 && collateralResource.getUrlLink().lastIndexOf(PDF_EXTENSION) > -1 && (Platform.getOS().equals("win32") || Platform.getOS().equals("macosx"));
    }

    private boolean isMP4(CollateralResource collateralResource) {
        return collateralResource.getUrlLink().indexOf(PREFIX_S32DS) > 0 && collateralResource.getUrlLink().lastIndexOf(MP4) > -1 && (Platform.getOS().equals("win32") || Platform.getOS().equals("macosx"));
    }
}

