/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.apex2.apugen.common;

import com.nxp.s32ds.ext.rcp.runtime.util.Strings;
import com.nxp.s32ds.gte.apuflow.ApuProducer;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortAttributesInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortElementsInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apuprogram.ApuImageInlet;
import com.nxp.s32ds.gte.apuprogram.ApuImageOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuNumberInlet;
import com.nxp.s32ds.gte.apuprogram.ApuPointerInlet;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcesses;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuPrograms;
import com.nxp.s32ds.mdt.vpt.apex2.core.vsdk.VsdkKernels;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class VisionAcceleo {
    private static final Pattern DATA_TYPE_PATTERN = Pattern.compile("^D(\\d\\d)(U|S)$");

    public static Set<ApuKernelInfo> getKernelInfos(Object o) {
        return VsdkKernels.getKernelInfos((Object)o);
    }

    public static Set<ApuGraph> getGraphs(Object o) {
        LinkedHashSet<ApuGraph> result = new LinkedHashSet<ApuGraph>();
        if (o instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)o;
            EList graphs = ApuProcesses.getGraphs((ApuProgram)program);
            result.addAll((Collection<ApuGraph>)graphs);
        }
        return result;
    }

    public static Set<ApuProcess> getProcesses(Object o) {
        LinkedHashSet<ApuProcess> result = new LinkedHashSet<ApuProcess>();
        if (o instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)o;
            EList processes = ApuPrograms.getProcesses((ApuProgram)program);
            result.addAll((Collection<ApuProcess>)processes);
        }
        return result;
    }

    public static String convertDataTypeToCvType(Object dataType) {
        String typeName = String.valueOf(dataType).toUpperCase();
        Matcher matcher = DATA_TYPE_PATTERN.matcher(typeName);
        if (!matcher.matches()) {
            return VisionAcceleo.getCvType(typeName);
        }
        int size = 0;
        try {
            size = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            return VisionAcceleo.getCvType(typeName);
        }
        String type = matcher.group(2);
        if (size == 32 && "U".equals(type)) {
            type = "S";
        }
        if (size == 64) {
            type = "F";
        }
        return VisionAcceleo.getCvType(String.valueOf(Integer.toString(size)) + type);
    }

    private static String getKernelMemoryPart(ApuKernelPortInfo kernelPortInfo) {
        if (kernelPortInfo == null) {
            return null;
        }
        ApuKernelPortAttributesInfo portAttrbutesInfo = kernelPortInfo.getPortAttrbutesInfo();
        if (portAttrbutesInfo == null) {
            return null;
        }
        ApuMemoryPart memoryPart = portAttrbutesInfo.getMemoryPart();
        if (memoryPart == null) {
            return null;
        }
        if (memoryPart.equals((Object)ApuMemoryPart.ATTR_CMEM)) {
            return "vec";
        }
        return "int";
    }

    private static String getKernelE0DataType(ApuKernelPortInfo kernelPortInfo) {
        if (kernelPortInfo == null) {
            return null;
        }
        ApuKernelPortElementsInfo portElementsInfo = kernelPortInfo.getPortElementsInfo();
        if (portElementsInfo == null) {
            return null;
        }
        ApuDataType e0DataType = portElementsInfo.getE0DataType();
        if (e0DataType == null) {
            return null;
        }
        return e0DataType.toString();
    }

    public static String convertKernelDataTypeToAbstractType(Object kernelPortInfo) {
        if (kernelPortInfo == null || !(kernelPortInfo instanceof ApuKernelPortInfo)) {
            return null;
        }
        ApuKernelPortInfo kpi = (ApuKernelPortInfo)kernelPortInfo;
        StringBuilder stringBuilder = new StringBuilder();
        String memPart = VisionAcceleo.getKernelMemoryPart(kpi);
        if (memPart != null) {
            stringBuilder.append(memPart);
        }
        String e0DataType = VisionAcceleo.getKernelE0DataType(kpi);
        stringBuilder.append(e0DataType.replace("d", ""));
        return stringBuilder.toString();
    }

    public static String convertApuDataTypeToPodType(Object dataType) {
        if (dataType == null || !(dataType instanceof ApuDataType)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String e0DataType = ((ApuDataType)dataType).toString();
        stringBuilder.append(e0DataType.replace("d", "int"));
        return stringBuilder.toString();
    }

    private static String getCvType(String string) {
        return "CV_" + string;
    }

    public static String convertApuDataTypeToInt(Object pixelType) {
        char secondDigit;
        String source = String.valueOf(pixelType);
        if (source.length() != 4) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        if (source.charAt(3) == 'u') {
            sb.append('u');
        }
        sb.append("int");
        char firstDigit = source.charAt(1);
        if (Character.isDigit(firstDigit) && firstDigit != '0') {
            sb.append(firstDigit);
        }
        if (Character.isDigit(secondDigit = source.charAt(2))) {
            sb.append(secondDigit);
        }
        sb.append("_t");
        return sb.toString();
    }

    public static Set<ApuProcess> getProcessTypes(Object o) {
        LinkedHashSet<ApuProcess> result = new LinkedHashSet<ApuProcess>();
        if (o instanceof ApuProgram) {
            ApuProgram program = (ApuProgram)o;
            List processes = ApuProcesses.getProcessTypes((ApuProgram)program);
            result.addAll(processes);
        }
        return result;
    }

    public static String getKernelMetaParams(ApuKernelInfo info) {
        String s = "";
        for (ApuKernelPortInfo port : info.getPortInfos()) {
            s = String.valueOf(s) + "kernel_io_desc " + port.getName() + ", ";
        }
        return s.length() > 0 ? s.substring(0, s.length() - 2) : s;
    }

    public static boolean isApuPointerInlet(Object o) {
        return o instanceof ApuPointerInlet;
    }

    public static boolean isApuNumberInlet(Object o) {
        return o instanceof ApuNumberInlet;
    }

    public static boolean isApuImageOutlet(Object o) {
        return o instanceof ApuImageOutlet;
    }

    public static String getDataValuePointerName(String process, String output) {
        return Strings.toCamelCaseMember((String)("dataValue_" + process + "_" + output + "_Ptr"));
    }

    public static String toValidIdentifier(String s) {
        return s.replaceAll("-", "_");
    }

    public static ApuImageInlet getImageInlet(Object o) {
        ApuProgram apuProgram = VisionAcceleo.extractProgram(o);
        if (apuProgram == null) {
            return null;
        }
        EList inlets = apuProgram.getInlets();
        for (ApuProducer apuProducer : inlets) {
            if (!(apuProducer instanceof ApuImageInlet)) continue;
            return (ApuImageInlet)apuProducer;
        }
        return null;
    }

    public static ApuProgram extractProgram(Object o) {
        if (o instanceof EObject) {
            EObject eObject = (EObject)o;
            while (eObject != null) {
                if (eObject instanceof ApuProgram) {
                    return (ApuProgram)eObject;
                }
                eObject = eObject.eContainer();
            }
        }
        return null;
    }

    public static Boolean hasROISeveralGraphProcesses(Object o) {
        if (!(o instanceof ApuProgram)) {
            return false;
        }
        ApuProgram program = (ApuProgram)o;
        Set graphsWithROI = program.getProcesses().stream().filter(process -> process.getProcessInputs().stream().filter(input -> input.getRoi() != null).collect(Collectors.toList()).size() > 0 || process.getProcessOutputs().stream().filter(output -> output.getRoi() != null).collect(Collectors.toList()).size() > 0).collect(Collectors.toList()).stream().map(process -> process.getGraph()).collect(Collectors.toSet());
        Set graphsWithoutROI = program.getProcesses().stream().filter(process -> process.getProcessInputs().stream().filter(input -> input.getRoi() != null).collect(Collectors.toList()).size() == 0 && process.getProcessOutputs().stream().filter(output -> output.getRoi() != null).collect(Collectors.toList()).size() == 0).collect(Collectors.toList()).stream().map(process -> process.getGraph()).collect(Collectors.toSet());
        if (graphsWithROI.isEmpty() || graphsWithoutROI.isEmpty()) {
            return false;
        }
        for (ApuGraph apuGraph : graphsWithoutROI) {
            if (!graphsWithROI.contains(apuGraph)) continue;
            return true;
        }
        return false;
    }

    public static Boolean hasROIOrIndirect(Object o) {
        if (!(o instanceof ApuProgram)) {
            return false;
        }
        ApuProgram program = (ApuProgram)o;
        EList processes = program.getProcesses();
        boolean hasROIOnInput = processes.stream().anyMatch(ps -> ps.getProcessInputs().stream().anyMatch(input -> input.getRoi() != null));
        if (hasROIOnInput) {
            return true;
        }
        boolean hasROIOnOutput = processes.stream().anyMatch(ps -> ps.getProcessOutputs().stream().anyMatch(output -> output.getRoi() != null));
        if (hasROIOnOutput) {
            return true;
        }
        boolean hasIndirect = processes.stream().anyMatch(ps -> ps.getProcessInputs().stream().anyMatch(input -> input.getIndirectInput() != null));
        if (hasIndirect) {
            return true;
        }
        return false;
    }

    public static Boolean hasConnectionsBetweenProcess(Object obj) {
        if (!(obj instanceof ApuProgram)) {
            return false;
        }
        ApuProgram program = (ApuProgram)obj;
        return program.getProcesses().stream().anyMatch(ps -> ps.getProcessOutputs().stream().anyMatch(o -> !o.getProcessInputs().isEmpty()));
    }

    public static Boolean isSeparatedControllersProcessing(Object obj) {
        if (!VisionAcceleo.hasROIOrIndirect(obj).booleanValue() && !VisionAcceleo.hasConnectionsBetweenProcess(obj).booleanValue()) {
            return false;
        }
        return true;
    }

    public static Set<String> getVsdkCategoriesSet(Object o) {
        return VsdkKernels.getVsdkCategoriesSet((Object)o);
    }

    public static Set<String> getUserCategoriesSet(Object o) {
        return VsdkKernels.getUserCategoriesSet((Object)o);
    }

    public static Set<ApuKernelInfo> collectKernelInfos(Set<ApuGraph> graphs) {
        return VsdkKernels.collectKernelInfos(graphs);
    }

    public static Set<String> getVsdkKernelCategories(Set<ApuKernelInfo> kernelInfos) {
        return VsdkKernels.getVsdkKernelCategories(kernelInfos);
    }

    public static Set<String> getUserKernelCategories(Set<ApuKernelInfo> kernelInfos) {
        return VsdkKernels.getUserKernelCategories(kernelInfos);
    }

    public static boolean isKernelInfoFromVsdk(ApuKernelInfo kernelInfo) {
        return VsdkKernels.isKernelInfoFromVsdk((ApuKernelInfo)kernelInfo);
    }

    public static boolean isUserDefinedKernelInfo(ApuKernelInfo kernelInfo) {
        return VsdkKernels.isUserDefinedKernelInfo((ApuKernelInfo)kernelInfo);
    }

    public static String convertSourceTypeToDestinationType(ApuKernelPortInfo source, ApuKernelPortInfo destination) {
        String destinationType;
        String sourceType = VisionAcceleo.convertKernelDataTypeToAbstractType(source);
        if (!sourceType.equalsIgnoreCase(destinationType = VisionAcceleo.convertKernelDataTypeToAbstractType(destination))) {
            return "(" + destinationType + ")";
        }
        return "";
    }
}

