/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface.internal;

import com.nxp.s32ds.ext.rcp.jface.internal.RcpJFaceActivator;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public final class NioDirectoryTreeContentProvider
implements ITreeContentProvider {
    private static final DirectoryStream.Filter<? super Path> DIRECTORY_FILTER = entry -> Files.isDirectory(entry, new LinkOption[0]);

    public Object[] getChildren(Object input) {
        return this.getElements(input);
    }

    public Object getParent(Object element) {
        if (element instanceof Path) {
            return ((Path)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Path && Files.isDirectory((Path)element, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getElements(Object input) {
        if (!(input instanceof Path)) return new Object[0];
        if (!Files.isDirectory((Path)input, new LinkOption[0])) {
            return new Object[0];
        }
        Path path = (Path)input;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                DirectoryStream<Path> ds = Files.newDirectoryStream(path, DIRECTORY_FILTER);
                try {
                    Object[] objectArray;
                    block17: {
                        Stream stream = StreamSupport.stream(ds.spliterator(), false);
                        try {
                            List<Path> collect = stream.collect(Collectors.toList());
                            objectArray = collect.toArray(new Path[collect.size()]);
                            return objectArray;
                        }
                        finally {
                            if (stream == null) break block17;
                            stream.close();
                        }
                    }
                    if (ds != null) {
                        ds.close();
                    }
                    return objectArray;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (ds == null) throw throwable;
                    ds.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            RcpJFaceActivator.getInstance().logError("Error during iteration by " + path.toString(), e);
            return new Object[0];
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

