/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.vlab.validation;

import com.nxp.s32ds.debug.ide.validation.CommonFieldValidator;
import com.nxp.s32ds.debug.ide.validation.ErrorMessages;
import com.nxp.s32ds.debug.ide.validation.NumberFieldValidator;
import com.nxp.s32ds.debug.ide.vlab.internal.validation.VLABSimulatorParametersNamesMessages;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorParams;
import com.nxp.s32ds.debug.ide.vlab.validation.VLABSimulatorStartupParams;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class VLABSimulatorAttributesValidator {
    private static final int MIN_RECOMMENDED_VLAB_DELAY = 15;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MIN_PORT_NUMBER = 0;

    private void processStatus(IStatus status, ArrayList<IStatus> errors) {
        if (!status.isOK()) {
            errors.add(status);
        }
    }

    public ArrayList<IStatus> validateDebuggerParameters(VLABSimulatorParams simulatorParams) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_core, false, false).validate((Object)simulatorParams.getCore()), errors);
        this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_client, true, true).validate((Object)simulatorParams.getClientExecutable()), errors);
        this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_simulator, true, true).validate((Object)simulatorParams.getSimulatorExecutable()), errors);
        this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_script, false, false).validate((Object)simulatorParams.getToolboxScriptName()), errors);
        this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_hostname_or_ip, false, false).validate((Object)simulatorParams.getHostNameOrIPAddress()), errors);
        this.processStatus(new NumberFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_gdb_server_port, 0, 65535).validate((Object)simulatorParams.getPortNumber()), errors);
        this.processStatus(new NumberFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_delay, 15, Integer.MAX_VALUE).validate((Object)simulatorParams.getDelay()), errors);
        errors.addAll(simulatorParams.getReadErrors());
        return errors;
    }

    public ArrayList<IStatus> validateStartupParameters(VLABSimulatorStartupParams startupParams) {
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (startupParams.isDoLoadImage() && !startupParams.isUseProjectBinaryForImage()) {
            this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_image_binary, true, false).validate((Object)startupParams.getImageFileName()), errors);
        }
        if (startupParams.isDoLoadSymbols() && !startupParams.isUseProjectBinaryForSymbols()) {
            this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_symbols_binary, true, false).validate((Object)startupParams.getSymbolsFileName()), errors);
        }
        if (startupParams.isDoSetPcRegister()) {
            this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_pc_register_value, false, false).validate((Object)startupParams.getPcRegisterValue()), errors);
        }
        if (startupParams.isDoSetStopAt()) {
            this.processStatus(new CommonFieldValidator(VLABSimulatorParametersNamesMessages.CommonFieldValidator_breakpoint_address, false, false).validate((Object)startupParams.getStopAt()), errors);
        }
        errors.addAll(startupParams.getReadErrors());
        return errors;
    }

    public IStatus validateParameters(VLABSimulatorParams debuggerParams, VLABSimulatorStartupParams startupParams) {
        ArrayList debuggerErrors = this.validateDebuggerParameters(debuggerParams);
        ArrayList<IStatus> startupErrors = this.validateStartupParameters(startupParams);
        ArrayList errors = debuggerErrors;
        errors.addAll(startupErrors);
        errors = (ArrayList)errors.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            return new MultiStatus("com.nxp.s32ds.debug.ide.vlab.validation", 4, errors.toArray(new IStatus[0]), ErrorMessages.LaunchSequence_wrong_attributes, null);
        }
        return Status.OK_STATUS;
    }
}

