/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.ui.viewers;

import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.core.ProjectContextHelper;
import com.nxp.s32ds.cle.uct.internal.core.SDKProjectHandler;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.ui.viewers.ComponentsDialog;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class ManageComponentsHandler
extends AbstractHandler {
    private static final Logger LOGGER = LogManager.getLogger(ManageComponentsHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null) {
            ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (currentSelection instanceof IStructuredSelection) {
                this.manageComponents(window, currentSelection);
            } else {
                currentSelection = this.getEditorLinkedSelection(HandlerUtil.getActiveEditorInput((ExecutionEvent)event));
                this.manageComponents(window, currentSelection);
            }
        }
        return null;
    }

    protected ISelection getEditorLinkedSelection(IEditorInput activeEditorInput) {
        if (activeEditorInput instanceof FileEditorInput) {
            IProject project = ((FileEditorInput)activeEditorInput).getFile().getProject();
            return new StructuredSelection((Object)project);
        }
        return null;
    }

    private void manageComponents(IWorkbenchWindow window, ISelection currentSelection) {
        IResource resource;
        Object obj = ((IStructuredSelection)currentSelection).getFirstElement();
        if (obj != null && (resource = (IResource)Adapters.adapt((Object)obj, IResource.class)) != null) {
            Shell parentShell = window != null ? window.getShell() : Display.getDefault().getActiveShell();
            IProject project = resource.getProject();
            if (parentShell != null && project != null) {
                if (ManageComponentsHandler.isConfigurationLoaded(project)) {
                    ComponentsDialog dialog = new ComponentsDialog(parentShell, project);
                    if (dialog.open() == 0) {
                        this.handleResult(project, dialog);
                    }
                } else {
                    MessageDialog.openWarning((Shell)parentShell, (String)NLS.bind((String)Messages.ComponentsDialog_ManageSDKComp, (Object)project.getName()), (String)Messages.ComponentsDialog_OpenConfig);
                }
            }
        }
    }

    private void handleResult(IProject project, ComponentsDialog dialog) {
        List<ComponentType> components = dialog.getResult();
        List<ComponentType> projectComponents = dialog.getProjectComponents();
        List<ComponentTypeEnum> availableTypes = dialog.getAVAILABLE_TYPES();
        if (projectComponents != null) {
            try {
                SDKProjectHandler handler = new SDKProjectHandler(project);
                ArrayList<String> addIds = new ArrayList<String>();
                List<String> remIds = new ArrayList<String>();
                ArrayList<ComponentType> addComponents = new ArrayList<ComponentType>();
                for (ComponentType c : components) {
                    if (projectComponents.contains(c)) continue;
                    addIds.add(c.getId());
                    addComponents.add(c);
                }
                for (ComponentType c : projectComponents) {
                    if (!c.isUserVisible() || components.contains(c) || !availableTypes.contains(c.getType())) continue;
                    remIds.add(c.getId());
                }
                remIds = this.scanDependencies(remIds, addComponents, projectComponents, dialog.getManifest());
                handler.remComponent(remIds, false);
                handler.addComponent(addIds, dialog.isStandalone(), dialog.isOtherFiles(), true, false);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private boolean isCMSIS(ComponentType component) {
        return component.getType().equals((Object)ComponentTypeEnum.CMSIS) && component.getId().equals("CMSIS_Include") || component.getType().equals((Object)ComponentTypeEnum.CMSIS_INCLUDE) || component.getId().equals("platform.Include_common");
    }

    private List<String> scanDependencies(List<String> remIds, List<ComponentType> addComponents, List<ComponentType> projectComponents, ISDKManifest manifest) {
        ArrayList<String> ids = new ArrayList<String>();
        HashMap<ComponentType, Integer> counts = new HashMap<ComponentType, Integer>();
        for (ComponentType component : projectComponents) {
            if (remIds.contains(component.getId()) || !component.isUserVisible() || this.isCMSIS(component)) continue;
            this.addDependencies(remIds, manifest, counts, component, 1);
        }
        for (ComponentType component : addComponents) {
            if (remIds.contains(component.getId()) || this.isCMSIS(component)) continue;
            this.addDependencies(remIds, manifest, counts, component, 1);
        }
        for (String id : remIds) {
            ids.add(id);
            List components = manifest.getComponentsById(id, true);
            ArrayList dependencies = new ArrayList();
            for (ComponentType component : components) {
                try {
                    manifest.getDependencies(component, dependencies);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            for (ComponentType component : dependencies) {
                if (this.isCMSIS(component)) continue;
                if (!counts.containsKey(component)) {
                    ids.add(component.getId());
                    continue;
                }
                if ((Integer)counts.get(component) > 1) continue;
                ids.add(component.getId());
            }
        }
        return ids;
    }

    private void addDependencies(List<String> remIds, ISDKManifest manifest, Map<ComponentType, Integer> counts, ComponentType component, int initCount) {
        if (!remIds.contains(component.getId())) {
            Integer value = initCount;
            if (counts.containsKey(component)) {
                value = counts.get(component);
                value = value + 1;
            }
            if (component.isUserVisible()) {
                value = value + 1;
            }
            counts.put(component, value);
        }
        ArrayList dependencies = new ArrayList();
        try {
            manifest.getDependencies(component, dependencies);
        }
        catch (Exception exception) {}
        for (ComponentType dep : dependencies) {
            if (remIds.contains(dep.getId())) continue;
            Integer value = 0;
            if (counts.containsKey(dep)) {
                value = counts.get(dep);
                value = value + 1;
            }
            counts.put(dep, value);
        }
    }

    private static boolean isConfigurationLoaded(IProject project) {
        if (project != null) {
            ISharedConfiguration cfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
            String processor = cfg.getCommonConfig().getMcuIdentification().getMcu();
            ProjectContextHelper helper = new ProjectContextHelper(project);
            if (processor != null) {
                return processor.equals(helper.getProcessor());
            }
        }
        return false;
    }
}

