/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.ui.viewers;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.internal.core.S32DSProjectAdapter;
import com.nxp.s32ds.cle.uct.internal.core.SDKProjectHandler;
import com.nxp.s32ds.cle.uct.manifest.xml.BoardType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.ui.types.WrapperType;
import com.nxp.s32ds.cle.uct.ui.viewers.ISDKPropertiesPage;
import com.nxp.s32ds.cle.uct.ui.viewers.IdentifiableViewer;
import com.nxp.s32ds.cle.uct.ui.viewers.UpdateEvent;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.EclipseProjectAdapterParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.osgi.framework.Version;

public class ComponentsDialog
extends TitleAreaDialog
implements ISDKPropertiesPage {
    private ScrolledForm form;
    private IProject project;
    private final List<ComponentTypeEnum> AVAILABLE_TYPES = new ArrayList<ComponentTypeEnum>();
    private Composite projectContentContainer;
    private Map<String, Object> props = new HashMap<String, Object>();
    protected DeviceType device;
    protected ISDKManifest manifest;
    private List<ComponentType> projectComponents;
    protected List<IdentifiableViewer> viewers = new ArrayList<IdentifiableViewer>();
    private CoreType core;
    private BoardType board;
    private List<ComponentType> dependencies = new ArrayList<ComponentType>();
    private String exampleId;
    protected static final Logger LOGGER = LogManager.getLogger(ComponentsDialog.class);
    private int countEvents = 0;
    protected boolean standalone = true;
    protected boolean otherFiles = true;

    public ComponentsDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        this.project = project;
        this.AVAILABLE_TYPES.add(ComponentTypeEnum.OS);
        this.AVAILABLE_TYPES.add(ComponentTypeEnum.DRIVER);
        this.AVAILABLE_TYPES.add(ComponentTypeEnum.PAL);
        this.AVAILABLE_TYPES.add(ComponentTypeEnum.UTILITIES);
        this.AVAILABLE_TYPES.add(ComponentTypeEnum.MIDDLEWARE);
        IToolchainProjectWithSdk toolchainPrj = (IToolchainProjectWithSdk)Adapters.adapt((Object)new EclipseProjectAdapterParams(null, project), IToolchainProjectWithSdk.class, (boolean)true);
        if (toolchainPrj instanceof S32DSProjectAdapter) {
            S32DSProjectAdapter prjHandler = (S32DSProjectAdapter)toolchainPrj;
            this.manifest = prjHandler.getLoadedManifest();
        }
        if (this.manifest != null) {
            this.device = SDKProjectHandler.getDevice((ISDKManifest)this.manifest, (String)toolchainPrj.getProcessor());
            this.projectComponents = this.getComponents();
            if (this.board != null && (this.exampleId == null || this.exampleId.isEmpty())) {
                this.projectComponents.add(this.manifest.getBoardComponent(this.board.getId(), this.device));
            }
        }
        this.getProps().put("manifest", this.manifest);
        this.getProps().put("device.core", this.core);
    }

    public List<ComponentType> getProjectComponents() {
        return this.projectComponents;
    }

    public BoardType getBoard() {
        return this.board;
    }

    public DeviceType getChip() {
        return this.device;
    }

    public List<ComponentTypeEnum> getAVAILABLE_TYPES() {
        return this.AVAILABLE_TYPES;
    }

    public ISDKManifest getManifest() {
        return this.manifest;
    }

    private List<ComponentType> getComponents() {
        ArrayList<ComponentType> components = new ArrayList<ComponentType>();
        String idStr = null;
        String entry = ProjectPropertiesManager.getEntry((IProject)this.project, (String)"sdkComponents");
        if (entry != null) {
            idStr = entry;
        }
        if (idStr != null) {
            String[] ids;
            String[] stringArray = ids = idStr.split(";");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                List result = this.manifest.getComponentsById(id, true);
                for (ComponentType component : result) {
                    if (component == null || component.getType().equals((Object)ComponentTypeEnum.CMSIS_INCLUDE) || component.getType().equals((Object)ComponentTypeEnum.CMSIS) || component.getType().equals((Object)ComponentTypeEnum.STARTUP) || component.getType().equals((Object)ComponentTypeEnum.PROJECT_TEMPLATE)) continue;
                    try {
                        this.manifest.getDependencies(component, this.dependencies);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    if (component == null) continue;
                    components.add(component);
                }
                ++n2;
            }
        }
        return components;
    }

    public List<ComponentType> getResult() {
        ArrayList<ComponentType> result = new ArrayList<ComponentType>();
        for (IdentifiableViewer viewer : this.viewers) {
            List<? extends IdentifiableType> viewerResult = viewer.getContent();
            result.addAll(viewerResult);
        }
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.ComponentsDialog_ManageSDKComp, (Object)this.project.getName()));
        this.setTitleImage(Activator.getDefault().getImage("img.sdk.manage.components"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createScrolledForm(main);
        toolkit.decorateFormHeading(this.form.getForm());
        this.form.setLayout((Layout)new GridLayout());
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.form.setText(Messages.ComponentsDialog_AvailSDKComp);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        Button btn = toolkit.createButton(body, Messages.ComponentsDialog_CopySources, 32);
        btn.setToolTipText(Messages.ComponentsDialog_CopySourcesInWorkspace);
        btn.setSelection(this.standalone);
        if (this.manifest != null) {
            btn.setEnabled(!this.manifest.isZip());
        }
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsDialog.this.standalone = ((Button)e.widget).getSelection();
            }
        });
        btn = toolkit.createButton(body, Messages.ComponentsDialog_ImportOtherFiles, 32);
        btn.setToolTipText(Messages.ComponentsDialog_OtherFilesWillBeImported);
        btn.setSelection(this.otherFiles);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsDialog.this.otherFiles = ((Button)e.widget).getSelection();
            }
        });
        this.projectContentContainer = toolkit.createComposite(body);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.viewers.clear();
        GridLayout layout = new GridLayout();
        layout.numColumns = this.isMiddlewareHidden(store) ? this.AVAILABLE_TYPES.size() - 1 : this.AVAILABLE_TYPES.size();
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.makeColumnsEqualWidth = true;
        this.projectContentContainer.setLayout((Layout)layout);
        this.projectContentContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        for (ComponentTypeEnum type : this.AVAILABLE_TYPES) {
            boolean mutualExclusive = false;
            if (type.equals((Object)ComponentTypeEnum.MIDDLEWARE) && this.isMiddlewareHidden(store) || type.equals((Object)ComponentTypeEnum.MIDDLEWARE) && this.isMiddlewareHidden(store)) continue;
            if (type.equals((Object)ComponentTypeEnum.OS)) {
                mutualExclusive = true;
            }
            final IdentifiableViewer componentViewer = new IdentifiableViewer(this.projectContentContainer, ComponentType.class, type.value(), toolkit, mutualExclusive, this, new int[]{60, 40});
            componentViewer.setComponentType(type);
            componentViewer.addSelectionListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider() instanceof IdentifiableViewer) {
                        List<? extends IdentifiableType> content = componentViewer.getContent();
                        ComponentsDialog.this.setContent();
                        ComponentsDialog.this.notifyListeners(content, (Widget)componentViewer);
                    }
                }
            });
            componentViewer.getViewer().addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean checked = event.getChecked();
                    if (!checked) {
                        List<? extends IdentifiableType> content = componentViewer.getContent();
                        ComponentsDialog.this.setContent();
                        ComponentsDialog.this.notifyListeners(content, (Widget)componentViewer);
                    }
                }
            });
            componentViewer.addListener(25, new Listener(){

                public void handleEvent(Event event) {
                    ISDKManifest manifest;
                    if (event instanceof UpdateEvent && (manifest = (ISDKManifest)ComponentsDialog.this.getProps().get("manifest")) != null) {
                        UpdateEvent updateEvent = (UpdateEvent)event;
                        ComponentsDialog.this.handleDependencies(updateEvent, event.widget, manifest.getComponents(componentViewer.getComponentType(), ComponentsDialog.this.device));
                        if (ComponentsDialog.this.countEvents == ComponentsDialog.this.AVAILABLE_TYPES.size() - 1) {
                            ComponentsDialog.this.countEvents = 0;
                            ComponentsDialog.this.setPageComplete(ComponentsDialog.this.checkDialog());
                        } else {
                            ComponentsDialog componentsDialog = ComponentsDialog.this;
                            componentsDialog.countEvents = componentsDialog.countEvents + 1;
                        }
                    }
                }
            });
            GridLayout layoutContainer = new GridLayout();
            layoutContainer.marginBottom = 0;
            layoutContainer.marginHeight = 0;
            layoutContainer.marginLeft = 0;
            layoutContainer.marginRight = 0;
            layoutContainer.marginTop = 0;
            layoutContainer.marginWidth = 0;
            componentViewer.setLayout((Layout)layoutContainer);
            componentViewer.setLayoutData(new GridData(4, 4, true, true));
            componentViewer.setEnabled(true);
            this.viewers.add(componentViewer);
        }
        if (this.manifest != null) {
            this.refresh();
        }
        return main;
    }

    private boolean isMiddlewareHidden(IPreferenceStore store) {
        Version version;
        if (this.manifest != null && !this.manifest.getSchemaVersion().isEmpty() && (version = new Version(this.manifest.getSchemaVersion())).compareTo(ISDKManifest.MANIFEST_LEGACY_VERSION) > 0) {
            return false;
        }
        return store.getBoolean("sdk.middleware");
    }

    private void refresh() {
        for (IdentifiableViewer viewer : this.viewers) {
            HashMap<Boolean, List<WrapperType>> map = new HashMap<Boolean, List<WrapperType>>();
            List components = this.manifest.getComponents(viewer.getComponentType(), this.device);
            ArrayList<WrapperType> list = new ArrayList<WrapperType>();
            for (ComponentType component : components) {
                list.add(new WrapperType((IdentifiableType)component, null));
            }
            map.put(Boolean.FALSE, list);
            viewer.setInput(this.manifest, map, this.device, null);
            this.setContent();
            viewer.initialize(this.projectComponents, this.dependencies);
        }
        this.setMessage("Adding/removing components could potentially break your project. Please use this feature carefully.", 2);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public boolean isOtherFiles() {
        return this.otherFiles;
    }

    public boolean checkDialog() {
        if (this.checkDependencies()) {
            this.setMessage(null);
            this.setPageComplete(true);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getProps() {
        return this.props;
    }

    protected void setContent() {
        if (!this.viewers.isEmpty()) {
            ArrayList<? extends IdentifiableType> result = new ArrayList<IdentifiableType>();
            for (IdentifiableViewer viewer : this.viewers) {
                result.addAll(viewer.getContent());
            }
            this.getProps().put("project.content", result);
        }
    }

    protected void notifyListeners(Object item, Widget source) {
        ArrayList<ComponentType> dependencies = new ArrayList<ComponentType>();
        ArrayList<IdentifiableViewer> widgets = new ArrayList<IdentifiableViewer>();
        List<ComponentType> components = new ArrayList();
        widgets.addAll(this.viewers);
        if (item instanceof ComponentTypeEnum) {
            components = this.manifest.getComponents((ComponentTypeEnum)item, this.device);
        } else if (item instanceof Object[]) {
            Object[] objectArray = (Object[])item;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ComponentType) {
                    components.add((ComponentType)object);
                }
                ++n2;
            }
        } else if (item instanceof List) {
            for (Object e : (List)item) {
                if (!(e instanceof ComponentType)) continue;
                components.add((ComponentType)e);
            }
        } else {
            return;
        }
        try {
            for (Widget widget : widgets) {
                dependencies.clear();
                for (ComponentType component : components) {
                    this.manifest.getDependencies(component, dependencies);
                }
                UpdateEvent event = new UpdateEvent(source, dependencies);
                widget.notifyListeners(25, (Event)event);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            this.setPageComplete(false);
        }
    }

    protected synchronized void handleDependencies(UpdateEvent updateEvent, Widget target, List<ComponentType> components) {
        List<ComponentType> dependencies = updateEvent.getDependencies();
        for (ComponentType dep : dependencies) {
            if (!components.contains(dep) || !(updateEvent.getSource() instanceof IdentifiableViewer) || !(target instanceof IdentifiableViewer)) continue;
            IdentifiableViewer targetViewer = (IdentifiableViewer)target;
            targetViewer.setChecked(new WrapperType((IdentifiableType)dep, null), true, true);
        }
        if (target instanceof IdentifiableViewer) {
            IdentifiableViewer targetViewer = (IdentifiableViewer)target;
            targetViewer.refresh();
        }
    }

    private boolean checkDependencies() {
        ArrayList<ComponentType> components = new ArrayList<ComponentType>();
        components.addAll(this.getResult());
        if (this.board != null && (this.exampleId == null || this.exampleId.isEmpty())) {
            components.add(this.manifest.getBoardComponent(this.board.getId(), this.device));
        }
        ArrayList dependencies = new ArrayList();
        LinkedHashSet satisfied = new LinkedHashSet();
        for (IdentifiableViewer viewer : this.viewers) {
            Object[] checked;
            Object[] objectArray = checked = viewer.getViewer().getCheckedElements();
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof WrapperType) {
                    ComponentType component = (ComponentType)((WrapperType)element).getElement();
                    components.add(component);
                    if (component.getType().equals((Object)ComponentTypeEnum.OS)) {
                        components.addAll(component.getDependency());
                    }
                }
                ++n2;
            }
        }
        try {
            for (ComponentType component : components) {
                this.manifest.getDependencies(component, dependencies);
            }
            satisfied.addAll(dependencies);
            for (ComponentType dep : dependencies) {
                if (components.contains(dep) || !dep.isUserVisible()) {
                    satisfied.remove(dep);
                }
                if (dep.getType().equals((Object)ComponentTypeEnum.CMSIS) || dep.getType().equals((Object)ComponentTypeEnum.CMSIS_INCLUDE)) {
                    satisfied.remove(dep);
                }
                if (dep.getType().equals((Object)ComponentTypeEnum.STARTUP)) {
                    satisfied.remove(dep);
                }
                boolean match = false;
                for (ComponentTypeEnum type : this.AVAILABLE_TYPES) {
                    if (!type.equals((Object)dep.getType()) && !dep.getType().equals((Object)ComponentTypeEnum.CMSIS) && !dep.getType().equals((Object)ComponentTypeEnum.CMSIS_INCLUDE)) continue;
                    match = true;
                }
                if (match) continue;
                satisfied.remove(dep);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.valueOf(Messages.ComponentsDialog_SDKCompManag) + e.getMessage(), e);
            this.setPageComplete(false);
            return false;
        }
        if (!satisfied.isEmpty()) {
            ArrayList<String> strings = new ArrayList<String>();
            for (ComponentType item : satisfied) {
                strings.add(String.valueOf(item.getName()) + "(" + item.getType() + ")");
            }
            this.setMessage(String.valueOf(Messages.ComponentsDialog_UnsatisfiedDep) + strings, 3);
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    private void setPageComplete(boolean complete) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(complete);
        }
    }
}

