/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.internal.symbol.sdk;

import com.nxp.s32ds.cle.runtime.symbol.sdk.SymbolSdkDescriptor;
import com.nxp.s32ds.cle.runtime.symbol.sdk.SymbolSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class SymbolSdkRegistryImplementation
extends BaseRegistry
implements SymbolSdkRegistry {
    private final Map<String, Collection<SymbolSdkDescriptor>> symbol2symbolSdkDescriptors = new HashMap<String, Collection<SymbolSdkDescriptor>>();
    private final Map<String, Collection<SymbolSdkDescriptor>> sdk2symbolSdkDescriptors = new HashMap<String, Collection<SymbolSdkDescriptor>>();

    @Override
    public List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySymbolId(String symbolId) {
        return this.getReferenceDescriptorsBySourceId(symbolId, this.symbol2symbolSdkDescriptors, SymbolSdkDescriptor.class);
    }

    @Override
    public List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2symbolSdkDescriptors, SymbolSdkDescriptor.class);
    }

    @Override
    public void addSymbolSdkDescriptor(SymbolSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.symbol2symbolSdkDescriptors, this.sdk2symbolSdkDescriptors, SymbolSdkDescriptor.class);
    }

    @Override
    public void removeSymbolSdkDescriptor(SymbolSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.symbol2symbolSdkDescriptors, this.sdk2symbolSdkDescriptors, SymbolSdkDescriptor.class);
    }

    @Override
    public void removeSymbolSdkDescriptorsBySdkId(String sdkId) {
        Collection<SymbolSdkDescriptor> collection = this.sdk2symbolSdkDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<SymbolSdkDescriptor> descriptors = new ArrayList<SymbolSdkDescriptor>(collection);
            descriptors.forEach(this::removeSymbolSdkDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<SymbolSdkDescriptor> getSymbolSdkDescriptors() {
        ArrayList<SymbolSdkDescriptor> result = new ArrayList<SymbolSdkDescriptor>();
        this.symbol2symbolSdkDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }
}

