/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.registry;

import com.nxp.s32ds.ext.rcp.internal.registry.RegistryMessages;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ReferenceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.log.LogService;

public class BaseRegistry {
    private LogService logService;

    public void bindLogService(LogService logService) {
        this.logService = logService;
    }

    public void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }

    protected void logError(String message, Throwable throwable) {
        if (this.logService == null) {
            return;
        }
        this.logService.log(1, message, throwable);
    }

    protected void logIllegalState(String message) {
        if (this.logService == null) {
            return;
        }
        this.logService.log(1, message, (Throwable)new IllegalStateException(message));
    }

    protected void log(int level, String message) {
        if (this.logService == null) {
            return;
        }
        this.logService.log(level, message);
    }

    protected void log(int level, String message, Throwable throwable) {
        if (this.logService == null) {
            return;
        }
        this.logService.log(level, message, throwable);
    }

    protected <D extends EntityDescriptor> void addEntityDescriptor(D descriptor, Map<String, D> map, Class<D> clazz) {
        if (descriptor == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null;
            String message = NLS.bind((String)pattern, clazz);
            this.logIllegalState(message);
            return;
        }
        String id = descriptor.getId();
        if (id == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null_id;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (map == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null_map;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (map.containsKey(id)) {
            String pattern = RegistryMessages.BaseRegistry_e_add_duplicated_id;
            String message = NLS.bind((String)pattern, (Object)id, clazz);
            this.logIllegalState(message);
            return;
        }
        map.put(id, descriptor);
    }

    protected <D extends EntityDescriptor> void removeEntityDescriptor(D descriptor, Map<String, D> map, Class<D> clazz) {
        if (descriptor == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null;
            String message = NLS.bind((String)pattern, clazz);
            this.logIllegalState(message);
            return;
        }
        String id = descriptor.getId();
        if (id == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null_id;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (map == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null_map;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        map.remove(id);
    }

    protected <D extends ReferenceDescriptor> void addReferenceDescriptor(D descriptor, Map<String, Collection<D>> source, Map<String, Collection<D>> target, Class<D> clazz) {
        if (descriptor == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null;
            String message = NLS.bind((String)pattern, clazz);
            this.logIllegalState(message);
            return;
        }
        String sourceId = descriptor.getSourceId();
        if (sourceId == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null_source_id;
            String message = String.format(pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        String targetId = descriptor.getTargetId();
        if (targetId == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null_target_id;
            String message = String.format(pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (source == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null_source_map;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (target == null) {
            String pattern = RegistryMessages.BaseRegistry_e_add_null_target_map;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        Collection<D> fromSource = source.get(sourceId);
        if (fromSource == null) {
            fromSource = new LinkedHashSet<D>();
            source.put(sourceId, fromSource);
        }
        fromSource.add(descriptor);
        Collection<D> fromTarget = target.get(targetId);
        if (fromTarget == null) {
            fromTarget = new LinkedHashSet<D>();
            target.put(targetId, fromTarget);
        }
        fromTarget.add(descriptor);
    }

    protected <D extends ReferenceDescriptor> void removeReferenceDescriptor(D descriptor, Map<String, Collection<D>> source, Map<String, Collection<D>> target, Class<D> clazz) {
        Collection<D> fromTarget;
        if (descriptor == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null;
            String message = String.format(pattern, clazz);
            this.logIllegalState(message);
            return;
        }
        String sourceId = descriptor.getSourceId();
        if (sourceId == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null_source_id;
            String message = String.format(pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        String targetId = descriptor.getTargetId();
        if (targetId == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null_target_id;
            String message = String.format(pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (source == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null_source_map;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        if (target == null) {
            String pattern = RegistryMessages.BaseRegistry_e_remove_null_target_map;
            String message = NLS.bind((String)pattern, clazz, descriptor);
            this.logIllegalState(message);
            return;
        }
        Collection<D> fromSource = source.get(sourceId);
        if (fromSource != null) {
            fromSource.remove(descriptor);
        }
        if ((fromTarget = target.get(targetId)) != null) {
            fromTarget.remove(descriptor);
        }
    }

    protected <D extends ReferenceDescriptor> List<D> getReferenceDescriptorsBySourceId(String sourceId, Map<String, Collection<D>> source, Class<D> clazz) {
        if (sourceId == null) {
            String pattern = RegistryMessages.BaseRegistry_e_get_null_source_id;
            String message = String.format(pattern, clazz);
            this.logIllegalState(message);
            return Collections.emptyList();
        }
        if (source == null) {
            String pattern = RegistryMessages.BaseRegistry_e_get_null_source_map;
            String message = NLS.bind((String)pattern, clazz, (Object)sourceId);
            this.logIllegalState(message);
            return Collections.emptyList();
        }
        Collection<D> targets = source.get(sourceId);
        if (targets == null) {
            return Collections.emptyList();
        }
        return new ArrayList<D>(targets);
    }

    protected <D extends ReferenceDescriptor> List<D> getReferenceDescriptorsByTargetId(String targetId, Map<String, Collection<D>> target, Class<D> clazz) {
        if (targetId == null) {
            String pattern = RegistryMessages.BaseRegistry_e_get_null_target_id;
            String message = String.format(pattern, clazz);
            this.logIllegalState(message);
            return Collections.emptyList();
        }
        if (target == null) {
            String pattern = RegistryMessages.BaseRegistry_e_get_null_target_map;
            String message = NLS.bind((String)pattern, clazz, (Object)targetId);
            this.logIllegalState(message);
            return Collections.emptyList();
        }
        Collection<D> sources = target.get(targetId);
        if (sources == null) {
            return Collections.emptyList();
        }
        return new ArrayList<D>(sources);
    }
}

