/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.registry.core;

import com.nxp.s32ds.cle.ide.debugger.internal.registry.core.Messages;
import com.nxp.s32ds.cle.ide.debugger.registry.DebuggerLaunchConfigurationRegistry;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.debugger.registry.core.ArchetypeDebuggerConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.ArchetypeDebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.runtime.component.debugger.ArchetypeDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.component.debugger.ArchetypeDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.component.debugger.core.ArchetypeDebuggerDescriptors;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupportConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

public class ArchetypeLaunchConfigurationSupport {
    public static final String IPU_ENGINES = "com.nxp.s32ds.cle.ide.debugger.registry.core.ipu.engines";
    public static final String GRAPH_NAMES = "com.nxp.s32ds.cle.ide.debugger.registry.core.changed.graphs";

    public static MultiStatus createSupportedLaunchConfigurations(IProject hostProject, String archetypeId, Map<String, Set<String>> params) {
        Set<String> changedGraphNames = params.get(GRAPH_NAMES);
        Set<String> enginesList = params.get(IPU_ENGINES);
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.ide.debugger.registry.core", 0, "", null);
        ArchetypeDebuggerRegistry archDebugRegistry = ArchetypeDebuggerDescriptors.getArchetypeDebuggerRegistry();
        DebuggerLaunchConfigurationRegistry debugLaunchConfigRegistry = DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry();
        List archDebugDescriptors = archDebugRegistry.getArchetypeDebuggerDescriptorsByArchetypeId(archetypeId);
        if (archDebugDescriptors.isEmpty()) {
            result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.debugger.registry.core", NLS.bind((String)Messages.LaunchConfig_ArchetypeDebuggerDescriptorsNotFoundError, (Object)archetypeId)));
            return result;
        }
        for (ArchetypeDebuggerDescriptor descriptor : archDebugDescriptors) {
            List debugLaunchConfigDescriptors = debugLaunchConfigRegistry.getDebuggerLaunchConfigurationDescriptorsByDebuggerId(descriptor.getDebuggerId());
            if (debugLaunchConfigDescriptors.isEmpty()) {
                result.add((IStatus)new Status(2, "com.nxp.s32ds.cle.ide.debugger.registry.core", NLS.bind((String)Messages.LaunchConfig_DebuggerLaunchConfigDescriptorNotFoundError, (Object)descriptor.getDebuggerId())));
                continue;
            }
            for (DebuggerLaunchConfigurationDescriptor debugLCDescr : debugLaunchConfigDescriptors) {
                ArchetypeDebuggerLaunchConfigurationDescriptor archetypeDescriptorLaunchConfiguration = ArchetypeDebuggerConfigurationDescriptors.getArchetypeDebugerConfigurationDescriptor(descriptor.getArchetypeId(), debugLCDescr.getLaunchConfigurationTypeIdentifier());
                if (archetypeDescriptorLaunchConfiguration == null || archetypeDescriptorLaunchConfiguration.getLaunchConfigurationCreator() == null) {
                    result.add((IStatus)new Status(2, "com.nxp.s32ds.cle.ide.debugger.registry.core", NLS.bind((String)Messages.LaunchConfig_LaunchConfigSupportNotFound, (Object)debugLCDescr.getLaunchConfigurationTypeIdentifier())));
                    continue;
                }
                LaunchConfigurationCreator launchConfigurationCreator = archetypeDescriptorLaunchConfiguration.getLaunchConfigurationCreator();
                if (changedGraphNames == null) {
                    return result;
                }
                for (String name : changedGraphNames) {
                    List<Map<String, Object>> configurations = ArchetypeLaunchConfigurationSupport.createConfigurationObjects(hostProject, descriptor, name, enginesList);
                    for (Map<String, Object> cfg : configurations) {
                        try {
                            ILaunchConfigurationWorkingCopy lc = launchConfigurationCreator.createLaunchConfigurationWorkingCopy(cfg);
                            lc.doSave();
                        }
                        catch (CoreException e) {
                            result.add(e.getStatus());
                        }
                    }
                }
            }
        }
        return result;
    }

    private static List<Map<String, Object>> createConfigurationObjects(IProject hostProject, ArchetypeDebuggerDescriptor descriptor, String componentName, Set<String> engines) {
        ArrayList<Map<String, Object>> configurations = new ArrayList<Map<String, Object>>();
        if (engines != null) {
            for (String engine : engines) {
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("com.nxp.s32ds.cle.runtime.component.registry.component.id", componentName);
                config.put(LaunchConfigurationSupportConstants.PROJECT_KEY, (String)hostProject);
                config.put("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", descriptor.getArchetypeId());
                config.put(IPU_ENGINES, engine);
                configurations.add(config);
            }
        } else {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("com.nxp.s32ds.cle.runtime.component.registry.component.id", componentName);
            config.put(LaunchConfigurationSupportConstants.PROJECT_KEY, (String)hostProject);
            config.put("com.nxp.s32ds.cle.runtime.component.registry.archetype.id", descriptor.getArchetypeId());
            configurations.add(config);
        }
        return configurations;
    }
}

