/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.resources;

import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;

public class DataDirectory {
    private static final String COMMON = "$COMMON";
    private static final String DEFAULT_COMPONENTS_DIRECTORY = "components";
    private static final String DEFAULT_RESOURCE_TABLES_DIRECTORY = "resource_tables";

    public static String getPeripheralsComponentsDir(IMcuIdentification mcu) {
        return DataDirectory.getPeripheralsDir(mcu, "cfg_components", DEFAULT_COMPONENTS_DIRECTORY);
    }

    public static String getPeripheralsResourceTablesDir(IMcuIdentification mcu) {
        return DataDirectory.getPeripheralsDir(mcu, DEFAULT_RESOURCE_TABLES_DIRECTORY, DEFAULT_RESOURCE_TABLES_DIRECTORY);
    }

    protected static String getPeripheralsDir(IMcuIdentification mcu, String dbType, String folder) {
        String rtDir = "";
        String dbLink = DataDirectoryUtils.getDbLink((IMcuIdentification)mcu, (String)dbType);
        Path path = Paths.get(dbLink, new String[0]);
        rtDir = path.startsWith(COMMON) ? String.valueOf(dbLink.replaceFirst(Matcher.quoteReplacement(COMMON), folder)) + File.separator + mcu.getSdkVersion() : DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)dbType);
        return String.valueOf(DataDirectory.getDataDir()) + File.separator + rtDir;
    }

    public static boolean isPeripheralsComponentsDirDefined(IMcuIdentification mcu) {
        return !UtilsText.isEmpty((String)DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"cfg_components"));
    }

    public static boolean isPeripheralsResourceTablesDirDefined(IMcuIdentification mcu) {
        return !UtilsText.isEmpty((String)DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)DEFAULT_RESOURCE_TABLES_DIRECTORY));
    }

    public static String getDataDir() {
        return DataDirectoryUtils.getDataDir();
    }
}

