/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.IActiveContextRefResolver;
import com.nxp.swtools.periphs.model.data.IQuickSelectionGroup;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSelectionsGroup;
import com.nxp.swtools.periphs.model.data.setting.ACollectionSetting;
import com.nxp.swtools.periphs.model.data.setting.IUIName;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="struct", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "from", "from_source"})
public class StructSetting
extends ACollectionSetting
implements IQuickSelectionGroup {
    @Attribute(name="from", required=false)
    private String cStructure = "";
    @Attribute(name="from_source", required=false)
    @Nullable
    private String source = "";
    @Element(name="quick_selections", required=false)
    @Nullable
    private QuickSelectionsGroup qsGroup;

    public StructSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String fromStructure, @Nullable String fromSource, @Nullable String condition, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression) {
        super(id, uiName, uiNameExpr, description, condition, enableCond, publicCond, options, optionsExpression);
        this.source = UtilsText.isEmpty((String)fromSource) ? null : fromSource;
        this.cStructure = fromStructure;
    }

    @Deprecated
    protected StructSetting() {
        this("", null, null, null, "", null, null, null, null, null, null);
    }

    public String getCStructure() {
        return this.cStructure;
    }

    public @Nullable String getSource() {
        return this.source;
    }

    @Override
    public boolean hasQuickSelections() {
        return this.qsGroup != null;
    }

    @Override
    public List<QuickSelection> getQuickSelections() {
        return this.qsGroup != null ? this.qsGroup.getQuickSelections() : CollectionsUtils.emptyList();
    }

    public @Nullable QuickSelection getQuickSelection(String qsId) {
        if (this.qsGroup != null) {
            return (QuickSelection)CollectionsUtils.nullableOptionalGet(this.qsGroup.getQuickSelections().stream().filter(x -> x.getId().equals(qsId)).findFirst());
        }
        return null;
    }

    @Override
    public @Nullable QuickSelection getDefaultQS() {
        return this.qsGroup != null ? this.qsGroup.getDefaultQS() : null;
    }

    public void setDefaultQS(QuickSelection qs) {
        if (this.qsGroup != null) {
            this.qsGroup.setDefaultQS(qs);
        }
    }

    public boolean addQuickSelection(QuickSelection quickSelection) {
        QuickSelectionsGroup qsGroupLoc = this.qsGroup;
        if (qsGroupLoc == null) {
            qsGroupLoc = new QuickSelectionsGroup();
        }
        this.qsGroup = qsGroupLoc;
        return qsGroupLoc.addQuickSelection(quickSelection);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", " + "from" + "=" + this.getCStructure() + ", " + "from_source" + "=" + UtilsText.safeString((String)this.getSource()) + ", " + "quick_selections" + "=" + (this.qsGroup != null ? this.qsGroup : "") + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.cStructure.hashCode();
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.qsGroup);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        StructSetting other = (StructSetting)obj;
        if (!this.cStructure.equals(other.cStructure)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.qsGroup, other.qsGroup);
    }

    @Override
    public StructSetting fromReference(ReferenceSetting ref) {
        StructSetting s = new StructSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.cStructure, this.source, StructSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), StructSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), ref.getPublicCondition(), this.mergeOptions(ref.getOptions(), this.getOptions()), this.mergeOptionExpr(ref.getOptionsExpression(), this.getOptionsExpression()));
        s.setSettings(this.settings);
        s.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        s.qsGroup = this.qsGroup;
        s.verify();
        return s;
    }

    @Override
    public void resolve(IActiveContextRefResolver sdkRefResolver, ConfigurationComponent comp, String setID) {
        sdkRefResolver.resolve(this, this.settings, comp, setID);
    }

    @Override
    @Commit
    public void commit() {
        super.commit();
    }
}

