/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.setting.ABaseModel;
import com.nxp.swtools.periphs.model.data.setting.ASetting;
import com.nxp.swtools.periphs.model.data.setting.IUIName;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="set", strict=false)
public class SetSetting
extends ASetting {
    @ElementList(inline=true)
    protected List<Item> items = new ArrayList<Item>();

    public SetSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpression);
    }

    @Deprecated
    protected SetSetting() {
        this("", null, null, null, null, null, null, null, null);
    }

    public boolean addItem(Item item) {
        return this.items.add(item);
    }

    public List<Item> getItems() {
        return CollectionsUtils.unmodifiableList(this.items);
    }

    public @Nullable Item getItem(String itemId) {
        for (Item item : this.items) {
            if (!itemId.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", items(fst " + 3 + ")=" + CollectionsUtils.firstN(this.items, (int)3) + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.items.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        SetSetting other = (SetSetting)obj;
        return this.items.equals(other.items);
    }

    @Override
    public SetSetting fromReference(ReferenceSetting ref) {
        SetSetting s = new SetSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), SetSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), SetSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), ref.getPublicCondition(), this.mergeOptions(ref.getOptions(), this.getOptions()), this.mergeOptionExpr(ref.getOptionsExpression(), this.getOptionsExpression()));
        s.items = this.items;
        s.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        s.verify();
        return s;
    }

    @Override
    @Commit
    public void commit() {
        super.commit();
    }

    public static class CustomItem
    extends Item {
        public static final String CUSTOM_ID = "custom";
        public static final String CUSTOM_LABEL = "Custom...";
        public static final String CUSTOM_DESCRIPTION = "Custom value";
        public static final String PREFIX = "custom:";

        public CustomItem(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable String value, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond) {
            super(id, uiName, uiNameExpr, value, description, availableCond, enableCond);
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
            this.setUINameString(value);
        }

        @Override
        public @Nullable String getUINameString() {
            return UtilsText.safeString((String)super.getUINameString());
        }

        public String getStorableFormat() {
            return CustomItem.getStorableFormat(this.getValue());
        }

        public static String getStorableFormat(String value) {
            return PREFIX + value;
        }

        public static String parseValueFromStorableString(String storableString) {
            if (storableString.startsWith(PREFIX)) {
                return UtilsText.safeString((String)storableString.substring(PREFIX.length()));
            }
            return "";
        }
    }

    @Root(name="item", strict=false)
    @Order(attributes={"id", "value", "label", "label_expr", "available", "enable"})
    public static class Item
    extends ABaseModel {
        @Attribute(name="value", required=false)
        @Nullable
        protected String value;

        public Item(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable String value, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond) {
            super(id, uiName, uiNameExpr, description, availableCond, enableCond, null, null);
            this.value = UtilsText.isEmpty((String)value) ? null : value;
        }

        @Deprecated
        protected Item() {
            this("", null, null, null, null, null, null);
        }

        public String getValue() {
            return this.value != null ? this.value : this.getId();
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", " + "value" + "=" + (this.value == null ? "" : this.value) + "]";
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.value);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            assert (obj != null);
            Item other = (Item)obj;
            return Objects.equals(this.value, other.value);
        }
    }
}

