/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.setting.ASetting;
import com.nxp.swtools.periphs.model.data.setting.IUIName;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="reference", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "config_set_id", "component_id"})
public final class ReferenceSetting
extends ASetting {
    @Attribute(name="type")
    private String referenceTypeID;
    @Attribute(name="config_set_id", required=false)
    @Nullable
    private String configSetRefID;
    @Attribute(name="component_id", required=false)
    @Nullable
    private String componentRefID;

    public ReferenceSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String refTypeID, @Nullable String confSetID, @Nullable String compID, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpr) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpr);
        this.referenceTypeID = refTypeID;
        this.configSetRefID = confSetID;
        this.componentRefID = compID;
    }

    @Deprecated
    protected ReferenceSetting() {
        this("", null, null, null, "", null, null, null, null, null, null, null);
    }

    public @Nullable String getConfigSetRefID() {
        return this.configSetRefID;
    }

    public @Nullable String getComponentRefID() {
        return this.componentRefID;
    }

    public String getReferenceID() {
        return this.referenceTypeID;
    }

    public boolean isRelative() {
        return UtilsText.isEmpty((String)this.componentRefID) && UtilsText.isEmpty((String)this.configSetRefID);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", " + "type" + "=" + this.getReferenceID() + ", " + "component_id" + "=" + UtilsText.safeString((String)this.getComponentRefID()) + ", " + "config_set_id" + "=" + UtilsText.safeString((String)this.getConfigSetRefID()) + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.componentRefID);
        result = 31 * result + Objects.hashCode(this.configSetRefID);
        result = 31 * result + this.referenceTypeID.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ReferenceSetting other = (ReferenceSetting)obj;
        if (!Objects.equals(this.componentRefID, other.componentRefID)) {
            return false;
        }
        if (!Objects.equals(this.configSetRefID, other.configSetRefID)) {
            return false;
        }
        return this.referenceTypeID.equals(other.referenceTypeID);
    }

    @Override
    public ReferenceSetting fromReference(ReferenceSetting ref) {
        ReferenceSetting referenceSetting = new ReferenceSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.referenceTypeID, this.configSetRefID, this.componentRefID, ReferenceSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), ReferenceSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), ref.getPublicCondition(), this.mergeOptions(ref.getOptions(), this.getOptions()), this.mergeOptionExpr(ref.getOptionsExpression(), this.getOptionsExpression()));
        referenceSetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        referenceSetting.verify();
        return referenceSetting;
    }
}

