/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.setting.IID;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="item_defaults", strict=false)
public class ItemDefaults {
    private HashMap<String, SetDefault> setDefaults = new HashMap();

    @ElementList(type=SetDefault.class, required=false, inline=true)
    private List<SetDefault> getDefaultsList() {
        return CollectionsUtils.listFromMapValues(this.setDefaults);
    }

    @ElementList(type=SetDefault.class, required=false, inline=true)
    private void setDefaultsList(List<SetDefault> newDefaults) {
        this.setDefaults.clear();
        newDefaults.stream().forEachOrdered(item -> {
            SetDefault setDefault = this.setDefaults.put(item.getId(), (SetDefault)item);
        });
    }

    public HashMap<String, SetDefault> getDefaults() {
        return this.setDefaults;
    }

    public void addDefault(SetDefault setDefault) {
        this.setDefaults.put(setDefault.getId(), setDefault);
    }

    public void setDefaults(HashMap<String, SetDefault> setDefaults) {
        this.setDefaults = setDefaults;
    }

    public @Nullable SetDefault getDefault(String setDefaultId) {
        return this.setDefaults.get(setDefaultId);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [setDefaults=" + this.setDefaults + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.setDefaults.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemDefaults other = (ItemDefaults)obj;
        return this.setDefaults.equals(other.setDefaults);
    }

    @Root(name="set_default", strict=false)
    public static class SetDefault
    implements IID {
        @Attribute(name="id", required=false)
        @Nullable
        private String id;
        @Nullable
        private Expression valueExpr;

        @Attribute(name="value_expr", required=true)
        public @Nullable String getValue() {
            return this.valueExpr != null ? this.valueExpr.formatOutput(FormatOptions.DEFAULT) : null;
        }

        public @Nullable Expression getValueExpr() {
            return this.valueExpr;
        }

        @Attribute(name="value_expr", required=true)
        private void setValue(String newValue) {
            if (!newValue.isEmpty()) {
                this.valueExpr = Expression.tryCreate((String)newValue);
            }
        }

        public SetDefault(@Nullable String id, String value) {
            this.id = id;
            if (!value.isEmpty()) {
                this.valueExpr = Expression.tryCreate((String)value);
            }
        }

        @Deprecated
        protected SetDefault() {
            this(null, "");
        }

        @Override
        public String getId() {
            return UtilsText.safeString((String)this.id);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "id" + "=" + this.getId() + ", " + "value_expr" + "=" + UtilsText.safeString((String)this.getValue());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.id);
            result = 31 * result + Objects.hashCode(this.valueExpr);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetDefault other = (SetDefault)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            return Objects.equals(this.valueExpr, other.valueExpr);
        }
    }
}

