/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.setting.ASetting;
import com.nxp.swtools.periphs.model.data.setting.IUIName;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="dynamic_enum", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "enable", "options", "public", "items"})
public class DynamicEnumSetting
extends ASetting {
    @Nullable
    private Expression itemsExpr;
    @Element(name="custom_value_support", required=false)
    @Nullable
    private CustomValueSupport customValueSupport;

    @Attribute(required=true, name="items")
    public @Nullable String getItemsExprString() {
        return this.itemsExpr != null ? this.itemsExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(required=true, name="items")
    public void setItemsExprString(String newExpr) {
        if (!newExpr.isEmpty()) {
            this.itemsExpr = Expression.tryCreate((String)newExpr);
        }
    }

    public @Nullable CustomValueSupport getCustomValueSupport() {
        return this.customValueSupport;
    }

    @Deprecated
    protected DynamicEnumSetting() {
        this("", null, null, null, "", null, null, null, null, null, null);
    }

    public DynamicEnumSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String itemsExpression, @Nullable CustomValueSupport customValueSupport, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpr) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpr);
        if (!itemsExpression.isEmpty()) {
            this.itemsExpr = Expression.tryCreate((String)itemsExpression);
        }
        this.customValueSupport = customValueSupport;
    }

    @Override
    public DynamicEnumSetting fromReference(ReferenceSetting ref) {
        String items = this.itemsExpr != null ? this.itemsExpr.formatOutput(FormatOptions.DEFAULT) : "";
        DynamicEnumSetting dynamicEnumSetting = new DynamicEnumSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), items, null, DynamicEnumSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), DynamicEnumSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), ref.getPublicCondition(), this.mergeOptions(ref.getOptions(), this.getOptions()), this.mergeOptionExpr(ref.getOptionsExpression(), this.getOptionsExpression()));
        dynamicEnumSetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        dynamicEnumSetting.verify();
        return dynamicEnumSetting;
    }

    public List<SetSetting.Item> createItems(IContext context) {
        ArrayList<SetSetting.Item> resultItems = new ArrayList<SetSetting.Item>();
        if (this.itemsExpr != null) {
            IValue resolvedValue = this.itemsExpr.resolve(context);
            Object data = resolvedValue.getValue();
            List inputItems = CollectionsUtils.emptyList();
            if (data instanceof IChildProvidable) {
                inputItems = ((IChildProvidable)data).getChildren();
            } else if (data instanceof List) {
                inputItems = (List)data;
            }
            inputItems.forEach(item -> {
                if (item instanceof SetSetting.Item) {
                    resultItems.add((SetSetting.Item)item);
                } else if (item instanceof IChild) {
                    IChild child = (IChild)item;
                    String descriptionString = child.getDescription();
                    Description itemDescription = descriptionString == null ? null : new Description(descriptionString, null);
                    resultItems.add(new SetSetting.Item(child.getId(), child.getName(), null, child.getId(), itemDescription, null, null));
                } else {
                    String stringItem = UtilsText.safeString((String)(item == null ? null : item.toString()));
                    resultItems.add(new SetSetting.Item(stringItem, stringItem, null, stringItem, new Description(stringItem, null), null, null));
                }
            });
        }
        return resultItems;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        DynamicEnumSetting other = (DynamicEnumSetting)obj;
        if (!Objects.equals(this.itemsExpr, other.itemsExpr)) {
            return false;
        }
        return Objects.equals(this.customValueSupport, other.customValueSupport);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.itemsExpr);
        result = 31 * result + Objects.hashCode(this.customValueSupport);
        return result;
    }

    @Root(name="custom_value_support", strict=false)
    @Order(attributes={"default", "validation_expr"})
    public static class CustomValueSupport {
        private String defaultValue = "";
        @Nullable
        private Expression validationExpr;

        @Attribute(name="validation_expr", required=true)
        public void setValidationExprString(String validationExprString) {
            this.validationExpr = Expression.tryCreate((String)validationExprString);
        }

        @Attribute(name="default", required=true)
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public @Nullable Expression getValidationExpression() {
            return this.validationExpr;
        }

        @Attribute(name="validation_expr")
        public String getValidationExprString() {
            if (this.validationExpr != null) {
                return this.validationExpr.formatOutput(FormatOptions.DEFAULT);
            }
            return "";
        }

        @Attribute(name="default")
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Deprecated
        public CustomValueSupport() {
        }

        public CustomValueSupport(String defaultValue, String validationExpr) {
            this.defaultValue = defaultValue;
            this.setValidationExprString(validationExpr);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.defaultValue.hashCode();
            result = 31 * result + Objects.hashCode(this.validationExpr);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomValueSupport other = (CustomValueSupport)obj;
            if (!this.defaultValue.equals(other.defaultValue)) {
                return false;
            }
            return Objects.equals(this.validationExpr, other.validationExpr);
        }
    }
}

