/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.IActiveContextRefResolver;
import com.nxp.swtools.periphs.model.data.IReferenceSettingResolver;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.setting.AMinMaxSetting;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.IUIName;
import com.nxp.swtools.periphs.model.data.setting.ItemDefaults;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="array", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "type", "size", "key_selector_expr"})
public class ArraySetting
extends AMinMaxSetting
implements IReferenceSettingResolver {
    private static final Logger LOGGER = LogManager.getLogger(ArraySetting.class);
    @Attribute(name="type")
    private String referenceTypeID;
    @Element(name="item_defaults", required=false)
    @Nullable
    private ItemDefaults itemDefaults;
    @Nullable
    private Expression sizeExpression;
    private ISetting referenceType;
    @Nullable
    private Expression keySelector;

    @Attribute(name="key_selector_expr", required=false)
    private @Nullable String getKeySelectorString() {
        return this.keySelector != null ? this.keySelector.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="key_selector_expr", required=false)
    private void setKeySelectorString(@Nullable String newExpr) {
        this.keySelector = newExpr != null && !newExpr.isEmpty() ? Expression.tryCreate((String)newExpr) : null;
    }

    @Attribute(name="size", required=false)
    public void setSizeExpressionString(@Nullable String exprString) {
        if (exprString != null) {
            this.sizeExpression = Expression.tryCreate((String)exprString);
        }
    }

    @Attribute(name="size", required=false)
    public @Nullable String getSizeExpressionString() {
        return this.sizeExpression != null ? this.sizeExpression.formatOutput(FormatOptions.DEFAULT) : null;
    }

    public @Nullable Expression getSizeExpr() {
        return this.sizeExpression;
    }

    public ArraySetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String refTypeID, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression, @Nullable ItemDefaults itemDefaults, @Nullable Expression keySelector, @Nullable String minValue, @Nullable String maxValue, @Nullable String sizeExpression) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpression, minValue, maxValue);
        this.referenceTypeID = refTypeID;
        this.referenceType = new ReferenceSetting(id, null, null, null, refTypeID, null, null, null, null, null, null, null);
        this.itemDefaults = itemDefaults;
        this.keySelector = keySelector;
        this.setSizeExpressionString(sizeExpression);
    }

    @Deprecated
    protected ArraySetting() {
        this("", null, null, null, "", null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    @Commit
    public void commit() {
        this.referenceType = new ReferenceSetting(this.getId(), null, null, null, this.referenceTypeID, null, null, null, null, null, null, null);
        super.commit();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.referenceTypeID.hashCode();
        result = 31 * result + Objects.hashCode(this.itemDefaults);
        result = 31 * result + Objects.hashCode(this.keySelector);
        result = 31 * result + Objects.hashCode(this.sizeExpression);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ArraySetting other = (ArraySetting)obj;
        if (!this.referenceTypeID.equals(other.referenceTypeID)) {
            return false;
        }
        if (!Objects.equals(this.itemDefaults, other.itemDefaults)) {
            return false;
        }
        if (!Objects.equals(this.keySelector, other.keySelector)) {
            return false;
        }
        return Objects.equals(this.sizeExpression, other.sizeExpression);
    }

    public String getReferenceID() {
        return this.referenceTypeID;
    }

    public ISetting getReferenceType() {
        return this.referenceType;
    }

    public @Nullable ItemDefaults getItemDefaults() {
        return this.itemDefaults;
    }

    public @Nullable Expression getKeySelector() {
        return this.keySelector;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + ", " + "type" + "=" + this.getReferenceID() + ", " + "item_defaults" + "=" + Objects.toString(this.itemDefaults) + ", " + "key_selector_expr" + "=" + Objects.toString(this.keySelector) + "]";
    }

    @Override
    public ArraySetting fromReference(ReferenceSetting ref) {
        ArraySetting arraySetting = new ArraySetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.referenceTypeID, ArraySetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), ArraySetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), ref.getPublicCondition(), this.mergeOptions(ref.getOptions(), this.getOptions()), this.mergeOptionExpr(ref.getOptionsExpression(), this.getOptionsExpression()), this.getItemDefaults(), this.getKeySelector(), this.getMinValueString(), this.getMaxValueString(), this.getSizeExpressionString());
        arraySetting.referenceType = this.referenceType;
        arraySetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        arraySetting.verify();
        return arraySetting;
    }

    @Override
    public void resolve(IActiveContextRefResolver sdkRefResolver, @Nullable ConfigurationComponent comp, String setID) {
        LinkedHashMap<String, ISetting> settings = new LinkedHashMap<String, ISetting>();
        settings.put(this.referenceType.getId(), this.referenceType);
        sdkRefResolver.resolve(this, settings, comp, setID);
        ISetting iSetting = (ISetting)settings.get(this.referenceType.getId());
        if (iSetting != null) {
            this.referenceType = iSetting;
        } else {
            LOGGER.severe(MessageFormat.format("An array setting with ID {0} contains an unresolvable reference with ID {1} to a setting in component with ID {2} and config-set with ID {3}", this.getId(), this.referenceType.getId(), comp != null ? comp.getId() : null, setID));
        }
    }
}

