/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.Constraint;
import com.nxp.swtools.periphs.model.data.Dependency;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.IQuickSelectionGroup;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.Validation;
import com.nxp.swtools.periphs.model.data.setting.ABaseModel;
import com.nxp.swtools.periphs.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Commit;

public abstract class ASetting
extends ABaseModel
implements ISetting {
    private static final Logger LOGGER = LogManager.getLogger(ASetting.class);
    @Nullable
    private Expression publicCond;
    @Element(type=Validation.class, name="validation", required=false)
    @Nullable
    private Validation validation;

    @Override
    @Attribute(name="public", required=false)
    public @Nullable String getPublicCondition() {
        return this.publicCond != null ? this.publicCond.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="public", required=false)
    private void setPublicCondition(String newCond) {
        if (!newCond.isEmpty()) {
            this.publicCond = Expression.tryCreate((String)newCond);
        }
    }

    protected ASetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, options, optionsExpression);
        if (publicCond != null) {
            this.setPublicCondition(publicCond);
        }
        this.validation = null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.publicCond);
        result = 31 * result + Objects.hashCode(this.validation);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ASetting other = (ASetting)obj;
        if (!Objects.equals(this.publicCond, other.publicCond)) {
            return false;
        }
        return Objects.equals(this.validation, other.validation);
    }

    @Deprecated
    protected ASetting() {
        this("", null, null, null, null, null, null, null, null);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", " + "validation" + "=" + (this.validation != null ? this.validation : "") + ", " + "public" + "=" + UtilsText.safeString((String)this.getPublicCondition());
    }

    protected @Nullable Validation mergeValidations(@Nullable Validation v1, @Nullable Validation v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        Validation mergedValidation = new Validation();
        mergedValidation.getConstraints().addAll(v1.getConstraints());
        mergedValidation.getConstraints().addAll(v2.getConstraints());
        mergedValidation.getDependencies().addAll(v1.getDependencies());
        mergedValidation.getDependencies().addAll(v2.getDependencies());
        return mergedValidation;
    }

    @Override
    public boolean isPublic(IContext context) {
        return this.publicCond != null ? this.publicCond.resolve(context).getBoolean() : false;
    }

    @Override
    public @Nullable Validation getValidation() {
        return this.validation;
    }

    public void setValidation(@Nullable Validation validation) {
        this.validation = validation;
    }

    @Override
    @Commit
    public void commit() {
        super.commit();
        this.verify();
    }

    public void verify() {
        if (SWToolsProperties.isVerificationOn()) {
            Validation validationLoc;
            if (this.isOptionSet("UI_BORDER_HIDDEN") && this instanceof IQuickSelectionGroup && !((IQuickSelectionGroup)((Object)this)).getQuickSelections().isEmpty()) {
                LOGGER.warning("Setting with id: " + this.getId() + " contains quick selection and the option: " + "UI_BORDER_HIDDEN");
            }
            if (this.isOptionSet("UI_BORDER_HIDDEN") && this.isOptionSet("UI_LABEL_HIDDEN") && this.getValidation() != null) {
                LOGGER.severe("Setting with id: " + this.getId() + " has defined options: " + "UI_BORDER_HIDDEN" + " and " + "UI_LABEL_HIDDEN" + " and cannot contain any validations");
            }
            if (this.isOptionSet("FEATURE_COMPONENT_ADD") && !this.getClass().equals(DynamicEnumSetting.class)) {
                LOGGER.warning("Setting with id \"" + this.getId() + "\" does not support option \"" + "FEATURE_COMPONENT_ADD" + "\"");
            }
            if ((validationLoc = this.validation) != null) {
                for (Constraint constraint : validationLoc.getConstraints()) {
                    if (!constraint.isDescriptionEmpty()) continue;
                    LOGGER.warning("Constraint in setting with id: " + this.getId() + " has no description");
                }
                for (Dependency dependency : validationLoc.getDependencies()) {
                    if (!dependency.isDescriptionEmpty()) continue;
                    LOGGER.warning("Dependency in setting with id: " + this.getId() + " has no description");
                }
            }
            if (this.isOptionSet("FEATURE_PERIPHERAL_SELECT") && !this.getClass().equals(DynamicEnumSetting.class)) {
                LOGGER.warning("Setting with id \"" + this.getId() + "\" does not support option \"" + "FEATURE_PERIPHERAL_SELECT" + "\"");
            }
        }
    }
}

