/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.setting.IBaseModel;
import com.nxp.swtools.periphs.model.data.setting.UiName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.core.Commit;

@Order(elements={"options_expr", "description"}, attributes={"id", "label", "label_expr", "available", "enable", "options"})
public abstract class ABaseModel
extends UiName
implements IBaseModel {
    @Attribute(name="id")
    private String id;
    @Element(name="description", required=false)
    @Nullable
    private Description description;
    @Nullable
    private Expression availableCond;
    @Nullable
    private Expression enableCond;
    private HashMap<String, @Nullable Expression> optionsMap;
    @Attribute(name="options", required=false)
    @Nullable
    private String options;
    @Element(type=OptionsExpr.class, name="options_expr", required=false)
    @Nullable
    private OptionsExpr optionsExpr;

    public ABaseModel(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond, @Nullable String options, @Nullable OptionsExpr optionsExpr) {
        super(uiName, uiNameExpr);
        this.id = id;
        this.options = UtilsText.isEmpty((String)options) ? null : options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap(options, optionsExpr, this);
        this.description = description;
        if (availableCond != null) {
            this.setAvailableExprString(availableCond);
        }
        if (enableCond != null) {
            this.setEnableExprString(enableCond);
        }
    }

    protected static @Nullable String andConditions(@Nullable String c1, @Nullable String c2) {
        if (c1 == null && c2 == null) {
            return null;
        }
        if (c1 != null && c2 == null) {
            return c1;
        }
        if (c1 == null && c2 != null) {
            return c2;
        }
        return String.format("(%s) && (%s)", c1, c2);
    }

    protected @Nullable OptionsExpr mergeOptionExpr(@Nullable OptionsExpr o1, @Nullable OptionsExpr o2) {
        if (o1 == null && o2 == null) {
            return null;
        }
        OptionsExpr curOptionsExpr = new OptionsExpr();
        if (o1 != null) {
            curOptionsExpr.addAllOptions(o1.getOptions());
        }
        if (o2 != null) {
            curOptionsExpr.addAllOptions(o2.getOptions());
        }
        return curOptionsExpr;
    }

    protected @Nullable String mergeOptions(@Nullable String o1, @Nullable String o2) {
        if (o1 == null && o2 == null) {
            return null;
        }
        if (o1 != null && o2 == null) {
            return o1;
        }
        if (o1 == null && o2 != null) {
            return o2;
        }
        return String.valueOf(o1) + ";" + o2;
    }

    @Attribute(name="available", required=false)
    public @Nullable String getAvailableExprString() {
        return Expression.formatOutput((Expression)this.availableCond, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="available", required=false)
    private void setAvailableExprString(String newCond) {
        if (!newCond.isEmpty()) {
            this.availableCond = Expression.tryCreate((String)newCond);
        }
    }

    @Override
    @Attribute(name="enable", required=false)
    public @Nullable String getEnableExprString() {
        return Expression.formatOutput((Expression)this.enableCond, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="enable", required=false)
    private void setEnableExprString(String newCond) {
        if (!newCond.isEmpty()) {
            this.enableCond = Expression.tryCreate((String)newCond);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public @Nullable Expression getCondition() {
        return this.availableCond;
    }

    @Override
    public String getUIName(IContext context) {
        String result = super.getUIName(context);
        if (result.isEmpty()) {
            return this.id;
        }
        return result;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return this.availableCond != null ? this.availableCond.resolve(context).getBoolean() : true;
    }

    @Override
    public boolean isEnabled(IContext context) {
        return this.enableCond != null ? this.enableCond.resolve(context).getBoolean() : true;
    }

    protected @Nullable Description getDescription(@Nullable Description newDescription) {
        if (newDescription != null) {
            return newDescription;
        }
        return this.description;
    }

    @Override
    public @Nullable Description getDescription() {
        return this.description;
    }

    @Override
    public @Nullable String getResolvedDescription(IContext context) {
        if (this.description != null) {
            return this.description.getDescription(context);
        }
        return null;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public Collection<String> getPresentOptions() {
        return CollectionsUtils.unmodifiableCollection((Collection)CollectionsUtils.safeKeySet(this.optionsMap));
    }

    @Override
    public @Nullable Object getOptionValue(String key, IContext context) {
        Expression expression = this.optionsMap.get(key);
        if (expression == null) {
            return null;
        }
        Object resolvedObject = expression.resolve(context).getValue();
        return resolvedObject;
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.optionsMap.containsKey(option);
    }

    @Commit
    public void commit() {
        if (this.options != null || this.optionsExpr != null) {
            this.optionsMap = SettingUtils.createOptionsMap(this.options, this.optionsExpr, this);
        }
    }

    public @Nullable String getOptions() {
        return this.options;
    }

    public @Nullable OptionsExpr getOptionsExpression() {
        return this.optionsExpr;
    }

    public void setOptions(@Nullable String options, @Nullable OptionsExpr optionsExpr) {
        this.options = options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap(this.options, this.optionsExpr, this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.enableCond);
        result = 31 * result + Objects.hashCode(this.availableCond);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Objects.hashCode(this.optionsExpr);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ABaseModel other = (ABaseModel)obj;
        if (!Objects.equals(this.availableCond, other.availableCond)) {
            return false;
        }
        if (!Objects.equals(this.enableCond, other.enableCond)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.options, other.options)) {
            return false;
        }
        return Objects.equals(this.optionsExpr, other.optionsExpr);
    }

    @Override
    public String toString() {
        return "id=" + this.getId() + ", " + super.toString() + ", " + "available" + "=" + UtilsText.safeString((String)this.getAvailableExprString()) + ", " + "enable" + "=" + UtilsText.safeString((String)this.getEnableExprString()) + ", " + "options" + "=" + UtilsText.safeString((String)this.getOptions()) + ", " + "options_expr" + "=" + (this.optionsExpr != null ? this.optionsExpr : "") + ", " + "description" + "=" + (this.description != null ? this.description : "");
    }
}

