/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.ClockConsumers;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.registers.RegistersFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableResourceTables;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.mcu.Mcu;
import com.nxp.swtools.periphs.model.resources.DataDirectory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.features.EmptySdkFeatures;
import com.nxp.swtools.provider.features.SdkFeatures;
import com.nxp.swtools.provider.features.SdkFeaturesProvider;
import com.nxp.swtools.utils.registers.EmptyRegistersDB;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.script.CompiledScript;

public class McuFactory {
    private static final String CODEGENERATOR_JS_FILENAME = "codegenerator.js";
    private static final Logger LOGGER = LogManager.getLogger(McuFactory.class);

    public static @Nullable IMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig) {
        return McuFactory.create(supportedDerivatives, commonConfig, true);
    }

    public static @Nullable IMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig, boolean needsConsistentResources) {
        String sdkVersion;
        IMcuIdentification mcuSelection = commonConfig.getMcuIdentification();
        IRegistersDatabaseAPI registers = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        if (registers == null) {
            return null;
        }
        SdkFeatures sdkFeatures = McuFactory.getSdkFeatures(supportedDerivatives, mcuSelection);
        if (sdkFeatures == null) {
            return null;
        }
        String mcuName = mcuSelection.getMcu();
        SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcuName, (String)(sdkVersion = mcuSelection.getSdkVersion()), (ISupportedDerivativesForSwTools)supportedDerivatives);
        ArrayList<ProcessorCore> cores = coresInfo == null ? new ArrayList<ProcessorCore>() : coresInfo.cores;
        AvailableComponents availableComponents = new AvailableComponents(mcuSelection, registers);
        AvailableResourceTables availableResourceTables = new AvailableResourceTables(mcuSelection, availableComponents);
        if (availableComponents.getConfigCompTypeIds().isEmpty() || availableResourceTables.getResourceTables().isEmpty()) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot load configuration components and/or resource tables for: " + mcuSelection);
            } else {
                return null;
            }
        }
        IProcessorMasterToolInfo masterToolInfo = supportedDerivatives.getProcessorMasterToolInfo(mcuName, sdkVersion);
        assert (masterToolInfo != null);
        PeripheralComponentFile clockConsumers = null;
        clockConsumers = ClockConsumers.getInstance().getPeripheralComponentFile(masterToolInfo, mcuSelection.getPackage());
        if (clockConsumers.isLegacy()) {
            LOGGER.warning("Legacy clock consumers format");
        } else if (clockConsumers.getPeriphComponents().isEmpty() && clockConsumers.getSignalInstances().isEmpty()) {
            LOGGER.severe("Cannot load clock consumers: there are no components in clock consumers");
        }
        ConfigurationComponentTypeId systemComponent = McuFactory.getSystemComponent(availableComponents, mcuSelection);
        String[] scriptFileFolders = systemComponent != null ? McuFactory.getScriptFileFolders(systemComponent, (IMcuIdentification)commonConfig) : new String[]{};
        CompiledScript compileCodeGenerator = systemComponent != null ? McuFactory.compileCodeGenerator(systemComponent, (IMcuIdentification)commonConfig) : null;
        Categories loadCategories = systemComponent != null ? McuFactory.getCategories(systemComponent) : null;
        Mcu mcu = new Mcu(availableComponents, availableResourceTables, sdkFeatures, registers, mcuSelection, masterToolInfo, cores, clockConsumers, systemComponent, scriptFileFolders, compileCodeGenerator, loadCategories);
        availableResourceTables.associateResources(mcu);
        return mcu;
    }

    private static String[] getScriptFileFolders(ConfigurationComponentTypeId systemComponent, IMcuIdentification mcuIdentification) {
        String componentsDir = DataDirectory.getPeripheralsComponentsDir(mcuIdentification);
        String systemCompDir = String.valueOf(componentsDir) + File.separator + systemComponent.getTypeId();
        String[] folders = new String[]{systemCompDir};
        return folders;
    }

    private static @Nullable Categories getCategories(ConfigurationComponentTypeId systemComponent) {
        Path categoriesDir = systemComponent.getFileLocation();
        File categoriesFile = categoriesDir.resolve("categories.xml").toFile();
        Categories categories = categoriesFile.exists() ? Categories.loadCategoriesFromFile(categoriesFile) : null;
        return categories;
    }

    private static @Nullable ConfigurationComponentTypeId getSystemComponent(AvailableComponents availableComponents, IMcuIdentification mcuIdentification) {
        List<ConfigurationComponentTypeId> confCompTypeIds = availableComponents.getComponentTypeIdsByType("system");
        if (confCompTypeIds == null) {
            LOGGER.severe(String.format("Peripherals configuration component \"%1s\" either does not exist or its version is not supported by the %2s MCU", "system", mcuIdentification.getPackage()));
            return null;
        }
        assert (!confCompTypeIds.isEmpty());
        if (confCompTypeIds.size() > 1) {
            LOGGER.severe(String.format("Peripherals configuration component \"%1s\" exists in %2s versions for the %3s MCU", "system", String.valueOf(confCompTypeIds.size()), mcuIdentification.getPackage()));
        }
        return confCompTypeIds.get(0);
    }

    private static @Nullable CompiledScript compileCodeGenerator(ConfigurationComponentTypeId systemComponent, IMcuIdentification mcuIdentification) {
        CompiledScript compiledScript = null;
        Object[] scriptFileFolders = McuFactory.getScriptFileFolders(systemComponent, mcuIdentification);
        ScriptFileProvider scriptFileProvider = new ScriptFileProvider((String[])scriptFileFolders);
        File file = scriptFileProvider.findScriptFile(CODEGENERATOR_JS_FILENAME);
        if (file != null) {
            compiledScript = JavaScriptHelper.compile((File)file);
            if (compiledScript == null) {
                LOGGER.warning("Compilation of code generator failed!");
            }
        } else {
            LOGGER.severe(MessageFormat.format("Code generator script {0} not found at these paths: {1}", CODEGENERATOR_JS_FILENAME, Arrays.toString(scriptFileFolders)));
        }
        return compiledScript;
    }

    protected static @Nullable IRegistersDatabaseAPI getRegisters(ISupportedDerivativesForSwTools supportedDerivatives, IMcuIdentification mcuSelection) {
        IRegistersDatabaseAPI registers = RegistersFactory.loadRegistersDB((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        if (registers == null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe("Cannot load registers for: " + mcuSelection);
            registers = EmptyRegistersDB.INSTANCE;
        }
        return registers;
    }

    protected static @Nullable SdkFeatures getSdkFeatures(ISupportedDerivativesForSwTools supportedDerivatives, IMcuIdentification mcuSelection) {
        SdkFeatures sdkFeatures = SdkFeaturesProvider.getSdkFeatures((ISupportedDerivativesForSwTools)supportedDerivatives, (IMcuIdentification)mcuSelection);
        if (sdkFeatures == null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe("Cannot load SDK features for: " + mcuSelection);
            sdkFeatures = EmptySdkFeatures.INSTANCE;
        }
        return sdkFeatures;
    }
}

