/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableResourceTables;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.SdkFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.script.CompiledScript;
import org.json.JSONException;
import org.json.JSONObject;

public class Mcu
implements IMcu {
    private static final Logger LOGGER = LogManager.getLogger(Mcu.class);
    public static final String ALIAS_ID_PERIPHERAL_TYPE = "type";
    public static final String ALIAS_ID_SDK_BASE_POINTER = "sdk_base_pointer";
    private final AvailableComponents availableComponents;
    private final AvailableResourceTables availableResourceTables;
    private final SdkFeatures sdkFeatures;
    private final IRegistersDatabaseAPI registersDb;
    private final IMcuIdentification mcuIdentification;
    private final String partNumber;
    private final Collection<ProcessorCore> cores;
    private final IProcessorMasterToolInfo masterToolInfo;
    private final PeripheralComponentFile clockConsumers;
    @Nullable
    private ConfigurationComponentTypeId systemComponent;
    private String[] scriptFilesFolder = new String[0];
    @Nullable
    private CompiledScript compiledScript;
    @Nullable
    private Categories categories;

    public Mcu(AvailableComponents availableComponents, AvailableResourceTables availableResourceTables, SdkFeatures sdkFeatures, IRegistersDatabaseAPI registersDb, IMcuIdentification mcuIdentification, IProcessorMasterToolInfo masterToolInfo, Collection<ProcessorCore> cores, PeripheralComponentFile clockConsumers, @Nullable ConfigurationComponentTypeId systemComponent, String[] scriptFileFolder, @Nullable CompiledScript compiledScript, @Nullable Categories categories) {
        this.availableComponents = availableComponents;
        this.availableResourceTables = availableResourceTables;
        this.sdkFeatures = sdkFeatures;
        this.registersDb = registersDb;
        this.cores = cores;
        this.mcuIdentification = mcuIdentification;
        this.partNumber = mcuIdentification.getPackage();
        this.masterToolInfo = masterToolInfo;
        this.clockConsumers = clockConsumers;
        this.systemComponent = systemComponent;
        this.scriptFilesFolder = scriptFileFolder;
        this.compiledScript = compiledScript;
        this.categories = categories;
    }

    @Override
    public boolean hasFeature(String feature, @Nullable String core, @Nullable String peripheral) {
        return this.sdkFeatures.hasFeature(this.sdkFeatures.removePrefix(feature), this.partNumber, core, peripheral);
    }

    @Override
    public AvailableComponents getAvailableComponents() {
        return this.availableComponents;
    }

    @Override
    public AvailableResourceTables getAvailableResourceTables() {
        return this.availableResourceTables;
    }

    @Override
    public List<String> getPeripherals() {
        return (List)Arrays.asList(this.registersDb.getPeripherals()).stream().map(x -> x.getName()).collect(CollectorsUtils.toList());
    }

    @Override
    public List<String> getPeripherals(String peripheral) {
        IRegParentPeripheralAPI[] apis;
        ArrayList<String> periphInstances = new ArrayList<String>();
        IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = apis = this.registersDb.getPeripherals();
        int n = apis.length;
        int n2 = 0;
        while (n2 < n) {
            IRegParentPeripheralAPI peripheralApi = iRegParentPeripheralAPIArray[n2];
            if (Objects.equals(peripheralApi.getAlias(ALIAS_ID_PERIPHERAL_TYPE), peripheral)) {
                periphInstances.add(peripheralApi.getName());
            }
            ++n2;
        }
        return periphInstances;
    }

    @Override
    public IRegistersDatabaseAPI getRegistersDb() {
        return this.registersDb;
    }

    @Override
    public @Nullable String getPeripheralType(String peripheralInstance) {
        IRegParentPeripheralAPI api = this.registersDb.getPeripheral(peripheralInstance);
        if (api == null) {
            return null;
        }
        return api.getAlias(ALIAS_ID_PERIPHERAL_TYPE);
    }

    @Override
    public @Nullable String getFeature(String feature, @Nullable String core, @Nullable String peripheral) {
        Feature featureFound = this.sdkFeatures.getFeatureByName(this.sdkFeatures.removePrefix(feature), this.partNumber, core, peripheral);
        return featureFound == null ? null : featureFound.getValue();
    }

    @Override
    public SdkFeatures getSdkFeatures() {
        return this.sdkFeatures;
    }

    @Override
    public String getPartNumber() {
        return this.mcuIdentification.getMcu();
    }

    public @Nullable String getBoard() {
        return this.mcuIdentification.getBoard();
    }

    public @Nullable String getKit() {
        return this.mcuIdentification.getKit();
    }

    public String getPackage() {
        return this.mcuIdentification.getPackage();
    }

    public String getSdkVersion() {
        return this.mcuIdentification.getSdkVersion();
    }

    public String getSeries() {
        return this.masterToolInfo.getSeries();
    }

    public String getFamily() {
        return this.masterToolInfo.getFamily();
    }

    public String getDataVersion() {
        return this.masterToolInfo.getVersion();
    }

    public JSONObject getCoresList() {
        JSONObject res = new JSONObject();
        for (ProcessorCore onecore : this.cores) {
            JSONObject core = new JSONObject();
            try {
                core.put(ProcessorCore.KWD_NAME, (Object)onecore.getName());
                core.put(ProcessorCore.KWD_ID, (Object)onecore.getID());
                core.put(ProcessorCore.KWD_DESCRIPTION, (Object)onecore.getDescription());
                core.put(ProcessorCore.KWD_ENABLED, true);
                res.put(onecore.getID(), (Object)core);
            }
            catch (JSONException e) {
                assert (false) : e.getMessage();
            }
        }
        return res;
    }

    @Override
    public Collection<ProcessorCore> getCores() {
        return this.cores;
    }

    @Override
    public @Nullable String getCoreUiName(String coreId) {
        ProcessorCore core = this.getCore(coreId);
        if (core != null) {
            return core.getName();
        }
        return null;
    }

    @Override
    public @Nullable ProcessorCore getCore(String coreId) {
        for (ProcessorCore core : this.cores) {
            if (!core.getID().equals(coreId)) continue;
            return core;
        }
        return null;
    }

    @Override
    public IMcuIdentification getMcuIdentification() {
        return this.mcuIdentification;
    }

    @Override
    public String getMasterCore() {
        Collection<ProcessorCore> theCores = this.getCores();
        ProcessorCore masterByDefaultOptional = (ProcessorCore)CollectionsUtils.findFirst(theCores, x -> x.isMaster_default());
        if (masterByDefaultOptional != null) {
            return masterByDefaultOptional.getID();
        }
        ProcessorCore masterOptional = (ProcessorCore)CollectionsUtils.findFirst(theCores, x -> x.isMaster());
        if (masterOptional != null) {
            return masterOptional.getID();
        }
        if (theCores.isEmpty()) {
            LOGGER.severe("No core could be found on this MCU (" + this.getPackage() + ")");
            return "";
        }
        return ((ProcessorCore)CollectionsUtils.first(theCores)).getID();
    }

    @Override
    public PeripheralComponentFile getClockConsumers() {
        return this.clockConsumers;
    }

    @Override
    public boolean isMulticore() {
        return this.getCores().size() > 1;
    }

    @Override
    public @Nullable CompiledScript getCodeGeneratorScript() {
        return this.compiledScript;
    }

    @Override
    public String[] getScriptFileFolders() {
        return this.scriptFilesFolder;
    }

    @Override
    public @Nullable Categories getCategories() {
        return this.categories;
    }

    @Override
    public @Nullable ConfigurationComponentTypeId getSystemComponent() {
        return this.systemComponent;
    }
}

