/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableResourceTables;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.features.SdkFeatures;
import com.nxp.swtools.utils.scripting.api.IMcuInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.script.CompiledScript;

public interface IMcu
extends IMcuInfo {
    public boolean hasFeature(String var1, @Nullable String var2, @Nullable String var3);

    public @Nullable String getFeature(String var1, @Nullable String var2, @Nullable String var3);

    public AvailableComponents getAvailableComponents();

    public AvailableResourceTables getAvailableResourceTables();

    public List<String> getPeripherals();

    public List<String> getPeripherals(String var1);

    public IRegistersDatabaseAPI getRegistersDb();

    public SdkFeatures getSdkFeatures();

    public String getPartNumber();

    public @Nullable String getPeripheralType(String var1);

    public Collection<ProcessorCore> getCores();

    public @Nullable String getCoreUiName(String var1);

    public @Nullable ProcessorCore getCore(String var1);

    public IMcuIdentification getMcuIdentification();

    public String getMasterCore();

    public PeripheralComponentFile getClockConsumers();

    default public boolean isPeripheralAvailableForCore(String core, String peripheral) {
        IRegParentPeripheralAPI api = this.getRegistersDb().getPeripheral(peripheral);
        if (api == null) {
            return false;
        }
        String[] cores = api.getCores();
        if (Objects.isNull(cores)) {
            return true;
        }
        return Arrays.asList(cores).contains(core);
    }

    public boolean isMulticore();

    public @Nullable CompiledScript getCodeGeneratorScript();

    public @Nullable ConfigurationComponentTypeId getSystemComponent();

    public String[] getScriptFileFolders();

    public @Nullable Categories getCategories();
}

