/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.periphs.model.data.Constraint;
import com.nxp.swtools.periphs.model.data.Dependency;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="validation", strict=false)
public class Validation {
    @ElementList(type=Constraint.class, required=false, inline=true)
    private List<Constraint> constraints = new ArrayList<Constraint>();
    @ElementList(type=Dependency.class, required=false, inline=true)
    private List<Dependency> dependencies = new ArrayList<Dependency>();

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public void setDepenencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean addConstraint(Constraint constraint) {
        return this.constraints.add(constraint);
    }

    public boolean addDependency(Dependency dependency) {
        return this.dependencies.add(dependency);
    }

    public List<Constraint> collectViolatedConstraints(IContext expressionContext, @Nullable String level) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.constraints) {
            if (level != null && !level.equalsIgnoreCase(constraint.getLevel()) || !constraint.isViolated(expressionContext)) continue;
            result.add(constraint);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [constraints=" + this.constraints + ", dependencies=" + this.dependencies + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.constraints.hashCode();
        result = 31 * result + this.dependencies.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Validation other = (Validation)obj;
        if (!this.constraints.equals(other.constraints)) {
            return false;
        }
        return this.dependencies.equals(other.dependencies);
    }
}

