/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.Option;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.SettingOptions;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class SettingUtils {
    private static final Logger LOGGER = LogManager.getLogger(SettingUtils.class);
    private static final Version HIGHEST_SCHEMA_VERSION = new Version("5.0");
    public static final String SEPARATOR = ".";
    public static final String SEPARATOR_REGEX = "\\.";
    public static final String DUPLICATE_ID_ENTRY_S2 = "Duplicate element ID {0} detected inside {1} - only last element is used.";

    public static @Nullable ISetting resolve(@Nullable ISetting setting, Collection<ConfigurationComponent> context) {
        ISetting tmp = setting;
        ISetting prev = null;
        while (tmp != null && tmp instanceof ReferenceSetting && prev != tmp) {
            ReferenceSetting r = (ReferenceSetting)tmp;
            prev = tmp;
            tmp = (ISetting)CollectionsUtils.nullableOptionalGet(SettingUtils.findSetting(r.getReferenceID(), context));
        }
        return tmp;
    }

    private static Optional<@Nullable ISetting> findSetting(String id, Collection<ConfigurationComponent> context) {
        return context.stream().flatMap(x -> x.getConfigSets().stream()).map(x -> x.find(id.split(SEPARATOR_REGEX))).filter(Objects::nonNull).findFirst();
    }

    public static @Nullable ISetting resolve(String id, Collection<ConfigurationComponent> context) {
        return SettingUtils.resolve((ISetting)CollectionsUtils.nullableOptionalGet(SettingUtils.findSetting(id, context)), context);
    }

    public static final String buildId(String ... parts) {
        return String.join((CharSequence)SEPARATOR, parts);
    }

    public static final String buildId(Iterable<? extends CharSequence> parts) {
        return String.join((CharSequence)SEPARATOR, parts);
    }

    public static HashMap<String, @Nullable Expression> createOptionsMap(@Nullable String optionsString, IID iid) {
        Expression value = null;
        HashMap<String, @Nullable Expression> newMap = new HashMap<String, Expression>();
        if (optionsString != null) {
            String[] optionsArray;
            String[] stringArray = optionsArray = optionsString.split(";");
            int n = optionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                value = null;
                String[] optionParts = string.split("=");
                if (optionParts.length > 2) {
                    LOGGER.severe(MessageFormat.format("Setting with ID {0} contains {1} assignments ({2}) to option with ID {3}", iid.getId(), optionParts.length - 1, "=", optionParts[0]));
                }
                if (optionParts.length == 2) {
                    String valueString = optionParts[1].trim();
                    String normalizedValue = SettingOptions.normalize(valueString);
                    value = Expression.constant((Object)normalizedValue);
                }
                String key = optionParts[0].trim();
                String normalizedKey = SettingOptions.normalize(key);
                newMap.put(normalizedKey, value);
                ++n2;
            }
        }
        return newMap;
    }

    public static HashMap<String, @Nullable Expression> createOptionsMap(@Nullable String optionsString, @Nullable OptionsExpr initOptionsExpr, IID iid) {
        HashMap<String, @Nullable Expression> newMap = SettingUtils.createOptionsMap(optionsString, iid);
        if (initOptionsExpr != null) {
            for (Option option : initOptionsExpr.getOptions()) {
                String optionId = SettingOptions.normalize(option.getId());
                if (newMap.containsKey(optionId) && SWToolsProperties.isVerificationOn()) {
                    LOGGER.warning("Option " + optionId + " in setting with id: " + iid.getId() + " already exists and it will be overwritten by option specified in <" + "options_expr" + ">");
                }
                newMap.put(option.getId(), option.getExpr());
            }
        }
        return newMap;
    }

    public static void verifySchemaVersion(URL schema, File source) {
        Version schemaVersion;
        String fileName = schema.getFile();
        Matcher pattern = Pattern.compile(".*-(.*).xsd").matcher(fileName);
        if (!pattern.matches()) {
            return;
        }
        String version = pattern.group(1);
        try {
            schemaVersion = Version.valueOf((String)version);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.severe(String.format("XML file %1s references an improperly formatted schema version %2s", source.getAbsolutePath(), version));
            return;
        }
        int result = schemaVersion.compareTo(HIGHEST_SCHEMA_VERSION);
        if (result > 0) {
            LOGGER.severe(String.format("XML file %1s references schema version %2s, which is higher than the supported %3s", source.getAbsolutePath(), schemaVersion, HIGHEST_SCHEMA_VERSION));
        } else if (result < 0) {
            LOGGER.info(String.format("XML file %1s references schema version %2s, which is lower than the supported %3s", source.getAbsolutePath(), schemaVersion, HIGHEST_SCHEMA_VERSION));
        }
    }
}

