/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Objects;
import org.osgi.framework.Version;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="sw_comp_ref", strict=false)
public class SWComponent {
    @Attribute(name="name")
    private String name;
    @Nullable
    private Version version;

    @Attribute(name="version", required=false)
    private @Nullable String getVersionString() {
        return this.version != null ? this.version.toString() : null;
    }

    @Attribute(name="version", required=false)
    private void setVersionString(@Nullable String newVer) {
        this.version = !UtilsText.safeString((String)newVer).isEmpty() ? new Version(newVer) : null;
    }

    public SWComponent(String name, String versionStr) {
        this.name = name;
        this.version = new Version(versionStr);
    }

    public SWComponent(String name, Version version) {
        this.name = name;
        this.version = version;
    }

    public SWComponent(String name) {
        this.name = name;
        this.version = null;
    }

    @Deprecated
    protected SWComponent() {
        this("");
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Version getVersion() {
        return this.version;
    }

    public String getVersionStr() {
        return this.version != null ? UtilsText.safeString((String)this.version.toString()) : "";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "name" + "=" + this.name + ", " + "version" + "=" + this.getVersionStr() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SWComponent other = (SWComponent)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }
}

