/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.setting.IID;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="set", strict=false)
@Order(attributes={"id"})
public class QuickSetting
implements IID {
    @Attribute(name="id")
    private String id;
    @Nullable
    private Expression resourceExpr;
    @Text(required=false)
    @Nullable
    private String value;

    @Attribute(name="from_resource", required=false)
    private @Nullable String getResourceString() {
        return this.resourceExpr != null ? this.resourceExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="from_resource", required=false)
    private void setResourceString(@Nullable String newResource) {
        this.resourceExpr = newResource != null && !newResource.isEmpty() ? Expression.tryCreate((String)newResource) : null;
    }

    public QuickSetting(String id, @Nullable String resourceString, @Nullable String value) {
        this.id = id;
        this.setResourceString(resourceString);
        this.value = UtilsText.isEmpty((String)value) ? null : value;
    }

    @Deprecated
    protected QuickSetting() {
        this("", null, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public @Nullable Expression getResourceExpr() {
        return this.resourceExpr;
    }

    public void setResourceExpr(Expression newResourceExpr) {
        this.resourceExpr = newResourceExpr;
    }

    public @Nullable String getValue() {
        return this.value;
    }

    public String toString() {
        String tmp = String.valueOf(this.getClass().getSimpleName()) + " [id=" + this.id;
        tmp = this.resourceExpr == null ? tmp : String.valueOf(tmp) + ", resource=" + this.getResourceString();
        tmp = this.value == null ? tmp : String.valueOf(tmp) + ", value=" + this.value;
        tmp = String.valueOf(tmp) + "]";
        return tmp;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.resourceExpr);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickSetting other = (QuickSetting)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.resourceExpr, other.resourceExpr)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

