/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Validate;

@Root(name="quick_selections", strict=false)
public class QuickSelectionsGroup {
    private static final Logger LOGGER = LogManager.getLogger(QuickSelectionsGroup.class);
    @ElementList(inline=true, required=false)
    private ArrayList<QuickSelection> qSelections = new ArrayList();
    @Element(name="default", required=false)
    @Nullable
    private String defaultQSRef;
    @Nullable
    private QuickSelection defaultQS;

    @Validate
    private void validate() {
        if (!UtilsText.isEmpty((String)this.defaultQSRef)) {
            Optional<QuickSelection> def = this.qSelections.stream().filter(x -> x.getId().equals(this.defaultQSRef)).findFirst();
            if (def.isPresent()) {
                this.defaultQS = def.get();
            } else if (SWToolsProperties.isVerificationOn()) {
                LOGGER.warning(String.format("Cannot find %s with id '%s' (which should be used as default)", QuickSelection.class.getSimpleName(), this.defaultQSRef));
            }
        }
    }

    public List<QuickSelection> getQuickSelections() {
        return CollectionsUtils.unmodifiableList(this.qSelections);
    }

    public boolean addQuickSelection(QuickSelection quickSelection) {
        return this.qSelections.add(quickSelection);
    }

    public void setDefaultQS(QuickSelection qs) {
        if (this.qSelections.contains(qs)) {
            this.defaultQS = qs;
            this.defaultQSRef = qs.getId();
            return;
        }
        throw new IllegalArgumentException(qs + " cannot be set as default, as it is not listed in " + this.qSelections);
    }

    public @Nullable QuickSelection getDefaultQS() {
        return this.defaultQS;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.defaultQS);
        result = 31 * result + Objects.hashCode(this.defaultQSRef);
        result = 31 * result + this.qSelections.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickSelectionsGroup other = (QuickSelectionsGroup)obj;
        if (!Objects.equals(this.defaultQSRef, other.defaultQSRef)) {
            return false;
        }
        if (!Objects.equals(this.defaultQS, other.defaultQS)) {
            return false;
        }
        return this.qSelections.equals(other.qSelections);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + (UtilsText.isEmpty((String)this.defaultQSRef) ? "" : "default=" + this.defaultQSRef + ", ") + "quickSelections(fst " + 3 + ")=" + CollectionsUtils.firstN(this.qSelections, (int)3) + "]";
    }
}

