/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import com.nxp.swtools.periphs.model.data.setting.IAvailable;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.UiName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="quick_selection", strict=false)
@Order(attributes={"id"})
public class QuickSelection
extends UiName
implements IID,
IAvailable {
    @Attribute(name="id")
    private String id;
    @Element(name="description", required=false)
    @Nullable
    private String description;
    @ElementList(inline=true)
    private List<QuickSetting> settings = new ArrayList<QuickSetting>();
    @Nullable
    private Expression availableCond;

    @Attribute(name="available", required=false)
    public @Nullable String getConditionString() {
        return this.availableCond != null ? this.availableCond.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="available", required=false)
    private void setConditionString(String newCond) {
        if (!newCond.isEmpty()) {
            this.availableCond = Expression.tryCreate((String)newCond);
        }
    }

    public QuickSelection(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable String description, @Nullable String availableCond) {
        super(uiName, uiNameExpr);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.id = id;
        String string = this.description = UtilsText.isEmpty((String)description) ? null : description;
        if (availableCond != null && !availableCond.isEmpty()) {
            this.availableCond = Expression.tryCreate((String)availableCond);
        }
    }

    @Deprecated
    protected QuickSelection() {
        this("", null, null, null, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public @Nullable QuickSetting getSetting(String sId) {
        for (QuickSetting sett : this.settings) {
            if (!sId.equals(sett.getId())) continue;
            return sett;
        }
        return null;
    }

    public List<QuickSetting> getSettings() {
        return CollectionsUtils.unmodifiableList(this.settings);
    }

    public boolean addSetting(QuickSetting setting) {
        return this.settings.add(setting);
    }

    @Override
    public @Nullable Expression getCondition() {
        return this.availableCond;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return this.availableCond != null ? this.availableCond.resolve(context).getBoolean() : true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "id" + "=" + this.getId() + ", " + super.toString() + ", " + "description" + "=" + this.getDescription() + ", " + "available" + "=" + UtilsText.safeString((String)this.getConditionString()) + ", content(fst " + 3 + ")=" + CollectionsUtils.firstN(this.settings, (int)3) + "]";
    }

    public String getDescription() {
        return UtilsText.safeString((String)this.description);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.availableCond);
        result = 31 * result + this.settings.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        QuickSelection other = (QuickSelection)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!this.settings.equals(other.settings)) {
            return false;
        }
        return Objects.equals(this.availableCond, other.availableCond);
    }
}

