/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.setting.IID;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="option", strict=false)
public class Option
implements IID {
    private static final Logger LOGGER = LogManager.getLogger(Option.class);
    @Attribute(name="id", required=true)
    private String id;
    @Nullable
    private Expression expr;

    public Option(String id, @Nullable String expr) {
        this.id = id;
        this.setExprString(expr);
    }

    @Deprecated
    public Option() {
        this.id = "";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Attribute(name="expr", required=false)
    public @Nullable String getExprString() {
        return this.expr != null ? this.expr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="expr", required=false)
    public void setExprString(@Nullable String expressionString) {
        if (expressionString != null) {
            if (!expressionString.isEmpty()) {
                this.expr = Expression.tryCreate((String)expressionString);
            } else {
                LOGGER.warning("Expression for option is empty!");
            }
        }
    }

    public @Nullable Expression getExpr() {
        return this.expr;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.expr);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        if (!other.id.equals(this.id)) {
            return false;
        }
        return Objects.equals(other.expr, this.expr);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.id);
        result.append("=");
        result.append(this.expr);
        result.append("]");
        return result.toString();
    }
}

