/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.periphs.model.data.MasterPeripheral;
import com.nxp.swtools.periphs.model.data.setting.IAvailable;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.UiName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="mode", strict=false)
@Order(attributes={"id"}, elements={"description", "config_set_refs", "master_peripheral"})
public class Mode
extends UiName
implements IAvailable,
IID {
    @Attribute(name="id")
    private String id;
    @Element(name="description")
    private String description;
    @Nullable
    private Expression condition;
    @ElementList(entry="config_set_ref", name="config_set_refs")
    private ArrayList<String> configSetRefs;
    @Element(name="master_peripheral", required=false)
    @Nullable
    private MasterPeripheral masterPeripheral;

    @Attribute(name="available", required=false)
    public @Nullable String getConditionString() {
        return this.condition != null ? this.condition.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="available", required=false)
    private void setConditionString(String newCondition) {
        if (!newCondition.isEmpty()) {
            this.condition = Expression.tryCreate((String)newCondition);
        }
    }

    public Mode(String id, @Nullable String uiName, @Nullable String uiNameExpr, String description, @Nullable String condition, @Nullable MasterPeripheral masterPeripheral) {
        super(uiName, uiNameExpr);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.id = id;
        this.description = description;
        if (condition != null && !condition.isEmpty()) {
            this.condition = Expression.tryCreate((String)condition);
        }
        this.configSetRefs = new ArrayList();
        this.masterPeripheral = masterPeripheral;
    }

    public Mode(String id, @Nullable String uiName, @Nullable String uiNameExpr, String description, @Nullable String condition) {
        this(id, uiName, uiNameExpr, description, condition, null);
    }

    @Deprecated
    protected Mode() {
        this("", null, null, "", "");
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getConfigSetRefs() {
        return CollectionsUtils.unmodifiableList(this.configSetRefs);
    }

    public @Nullable MasterPeripheral getMasterPeripheral() {
        return this.masterPeripheral;
    }

    public boolean addConfigSet(String configSetID) {
        return this.configSetRefs.add(configSetID);
    }

    public void setMasterPeripheral(@Nullable MasterPeripheral masterPeripheral) {
        this.masterPeripheral = masterPeripheral;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "id" + "=" + this.getId() + ", " + super.toString() + ", " + "description" + "=" + this.getDescription() + ", configSets(fst " + 3 + ")=" + CollectionsUtils.firstN(this.configSetRefs, (int)3) + ", " + "master_peripheral" + "=" + (this.masterPeripheral != null ? this.masterPeripheral : "") + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.configSetRefs.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.masterPeripheral);
        result = 31 * result + Objects.hashCode(this.condition);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        Mode other = (Mode)obj;
        if (!this.configSetRefs.equals(other.configSetRefs)) {
            return false;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.masterPeripheral, other.masterPeripheral)) {
            return false;
        }
        return Objects.equals(this.condition, other.condition);
    }

    @Override
    public @Nullable Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return this.condition != null ? this.condition.resolve(context).getBoolean() : true;
    }
}

