/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(name="data", strict=false)
public class Data
implements IFeatureData {
    @Attribute(name="type", required=false)
    @Nullable
    private String type;
    @Attribute(name="unit", required=false)
    @Nullable
    private String unit;
    @Attribute(name="min_value", required=false)
    @Nullable
    private String minValue;
    @Attribute(name="max_value", required=false)
    @Nullable
    private String maxValue;
    @Text(required=false)
    @Nullable
    private String value;
    @Nullable
    private Expression valueExpr;

    @Attribute(name="expr", required=false)
    private @Nullable String getValueExprString() {
        return Expression.formatOutput((Expression)this.valueExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="expr", required=false)
    private void setValueExprString(@Nullable String newExpr) {
        this.valueExpr = newExpr != null && !newExpr.isEmpty() ? Expression.tryCreate((String)newExpr) : null;
    }

    public Data(@Nullable String valueExpr, @Nullable String value) {
        assert (value != null || valueExpr != null);
        this.setValueExprString(valueExpr);
        this.value = value;
    }

    @Deprecated
    protected Data() {
        this(null, "");
    }

    public String getValue() {
        return UtilsText.safeString((String)this.value);
    }

    public @Nullable String getType() {
        return this.type;
    }

    public @Nullable String getUnit() {
        return this.unit;
    }

    public @Nullable String getMinValue() {
        return this.minValue;
    }

    public @Nullable String getMaxValue() {
        return this.maxValue;
    }

    public IValue resolveValue(IContext expressionContext) {
        return this.valueExpr != null ? this.valueExpr.resolve(expressionContext) : Value.valueOf((String)this.getValue());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "value" + "=" + this.getValue() + ", " + "expr" + "=" + this.getValueExprString() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.valueExpr);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (this.value != null ? !this.value.equals(other.value) : other.value != null) {
            return false;
        }
        return !(this.valueExpr != null ? !this.valueExpr.equals((Object)other.valueExpr) : other.valueExpr != null);
    }
}

