/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="constraint", strict=false)
public class Constraint {
    private static final Logger LOGGER = LogManager.getLogger(Constraint.class);
    @Nullable
    Expression whenExpr;
    @Nullable
    Expression descriptionExpr;
    @Nullable
    Expression condExpr;
    @Attribute(name="level", required=true)
    String level;
    @Attribute(name="description", required=false)
    String description;

    @Attribute(name="when_expr", required=false)
    public @Nullable String getWhenExprString() {
        return Expression.formatOutput((Expression)this.whenExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="description_expr", required=false)
    public @Nullable String getDescriptionExprString() {
        return Expression.formatOutput((Expression)this.descriptionExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="when_expr", required=false)
    private void setWhenExprString(@Nullable String newWhen) {
        this.whenExpr = newWhen != null && !newWhen.isEmpty() ? Expression.tryCreate((String)newWhen) : null;
    }

    @Attribute(name="description_expr", required=false)
    private void setDescriptionExprString(@Nullable String newDescriptionExpression) {
        this.descriptionExpr = !UtilsText.isEmpty((String)newDescriptionExpression) ? Expression.tryCreate((String)UtilsText.safeString((String)newDescriptionExpression)) : null;
    }

    @Attribute(name="cond_expr", required=true)
    public @Nullable String getConditionExprString() {
        return Expression.formatOutput((Expression)this.condExpr, (FormatOptions)FormatOptions.DEFAULT);
    }

    @Attribute(name="cond_expr", required=true)
    private void setConditionExprString(String newCondition) {
        if (!newCondition.isEmpty()) {
            this.condExpr = Expression.tryCreate((String)newCondition);
        }
    }

    public Constraint(@Nullable String when, String condExpr, String level, @Nullable String description, @Nullable String descriptionExpr) {
        if (!UtilsText.isEmpty((String)condExpr)) {
            this.condExpr = Expression.tryCreate((String)condExpr);
        }
        if (when != null && !when.isEmpty()) {
            this.whenExpr = Expression.tryCreate((String)when);
        }
        this.level = level;
        this.description = UtilsText.safeString((String)description);
        if (!UtilsText.isEmpty((String)descriptionExpr)) {
            this.setDescriptionExprString(descriptionExpr);
        }
    }

    @Deprecated
    protected Constraint() {
        this("", "", "", "", "");
    }

    public @Nullable Expression getCondExpr() {
        return this.condExpr;
    }

    public String getLevel() {
        return this.level;
    }

    public String getDescription(IContext expressionContext) {
        if (this.descriptionExpr != null) {
            return this.descriptionExpr.resolve(expressionContext).getString();
        }
        return this.description;
    }

    public boolean isDescriptionEmpty() {
        return this.descriptionExpr == null && UtilsText.isEmpty((String)this.description);
    }

    public @Nullable Expression getWhen() {
        return this.whenExpr;
    }

    public void setExpr(Expression condExpr) {
        this.condExpr = condExpr;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setWhen(Expression when) {
        this.whenExpr = when;
    }

    public boolean isViolated(IContext expressionContext) {
        block3: {
            try {
                if (this.whenExpr == null || this.whenExpr.resolve(expressionContext).getBoolean()) break block3;
                return false;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Problem evaluating constraint", ex);
                return false;
            }
        }
        return this.condExpr == null || !this.condExpr.resolve(expressionContext).getBoolean();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "when_expr" + "=" + this.getWhenExprString() + ", " + "cond_expr" + "=" + this.getConditionExprString() + ", " + "level" + "=" + this.getLevel() + ", " + "description" + "=" + this.description + ", " + "description_expr" + "=" + this.getDescriptionExprString() + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.whenExpr);
        result = 31 * result + Objects.hashCode(this.condExpr);
        result = 31 * result + this.level.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + Objects.hashCode(this.descriptionExpr);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constraint other = (Constraint)obj;
        if (this.whenExpr != null ? !this.whenExpr.equals((Object)other.whenExpr) : other.whenExpr != null) {
            return false;
        }
        if (!Objects.equals(this.condExpr, other.condExpr)) {
            return false;
        }
        if (!this.level.equals(other.level)) {
            return false;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        return Objects.equals(this.descriptionExpr, other.descriptionExpr);
    }
}

