/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.SWComponent;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class ConfigurationComponentTypeId {
    private static final String DOCUMENTATION_SUBFOLDER_NAME = "doc";
    private static final String DOCUMENTATION_INDEX_FILE_NAME = "index.md";
    private final ComponentInfo info;
    private ConfigurationComponent configurationComponent;
    private final boolean docExists;

    public ConfigurationComponentTypeId(ComponentInfo componentInfo, ConfigurationComponent component) {
        this.configurationComponent = component;
        this.info = componentInfo;
        this.docExists = ConfigurationComponentTypeId.getDocIndexFile((IConfigComponentInfo)componentInfo).exists();
    }

    public ConfigurationComponent getConfigurationComponent() {
        return this.configurationComponent;
    }

    public List<SWComponent> getComponentReferences() {
        return this.getConfigurationComponent().getComponents();
    }

    public String getType() {
        return this.getConfigurationComponent().getId();
    }

    public String getTypeId() {
        return this.info.getName();
    }

    public String getSdkVersion() {
        return this.info.getSdkVersion();
    }

    public boolean isDocumentationPresent() {
        return this.docExists;
    }

    public @Nullable String loadDocumentation() {
        if (this.docExists) {
            File indexFile = ConfigurationComponentTypeId.getDocIndexFile((IConfigComponentInfo)this.info);
            return UtilsFile.readFileToString((String)indexFile.getAbsolutePath(), (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    public Path getFileLocation() {
        Path path = this.info.getComponentDir().toPath();
        assert (path != null);
        return path;
    }

    public Path resolvePath(Path other) {
        return Paths.get(this.getFileLocation().toString(), DOCUMENTATION_SUBFOLDER_NAME).resolve(other);
    }

    public void setConfigurationComponent(ConfigurationComponent configurationComponent) {
        this.configurationComponent = configurationComponent;
    }

    private static File getDocIndexFile(IConfigComponentInfo componentInfo) {
        return new File(new File(componentInfo.getComponentDir(), DOCUMENTATION_SUBFOLDER_NAME), DOCUMENTATION_INDEX_FILE_NAME);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getTypeId().hashCode();
        result = 31 * result + this.getSdkVersion().hashCode();
        result = 31 * result + this.getFileLocation().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationComponentTypeId other = (ConfigurationComponentTypeId)obj;
        if (!this.getTypeId().equals(other.getTypeId())) {
            return false;
        }
        if (!this.getSdkVersion().equals(other.getSdkVersion())) {
            return false;
        }
        return this.getFileLocation().equals(other.getFileLocation());
    }

    public String toString() {
        return "[ConfigurationComponentTypeId Type='" + this.getType() + "' TypeId='" + this.getTypeId() + "']";
    }
}

