/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXML;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.FunctionDef;
import com.nxp.swtools.periphs.model.data.Mode;
import com.nxp.swtools.periphs.model.data.OptionsExpr;
import com.nxp.swtools.periphs.model.data.SWComponent;
import com.nxp.swtools.periphs.model.data.Script;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.UserFunctions;
import com.nxp.swtools.periphs.model.data.XMLConstants;
import com.nxp.swtools.periphs.model.data.setting.IDescription;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.IOptions;
import com.nxp.swtools.periphs.model.data.setting.UiName;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.core.Validate;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.xml.sax.SAXException;

@Root(name="config_component", strict=false)
@Namespace(prefix="component", reference="http://swtools.freescale.net/XSD/component/1.0")
@Order(attributes={"id"})
public class ConfigurationComponent
extends UiName
implements IID,
IDescription,
IOptions {
    public static final String SYSTEM_COMPONENT_ID = "system";
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationComponent.class);
    private static final String LOCAL_SCHEMA = XMLConstants.COMPONENT_SCHEMA_FILENAME;
    @Attribute(name="id")
    private String id;
    @Attribute(name="category", required=false)
    @Nullable
    private String category;
    @Attribute(name="options", required=false)
    @Nullable
    private String options;
    @Element(type=OptionsExpr.class, name="options_expr", required=false)
    @Nullable
    private OptionsExpr optionsExpr;
    private HashMap<String, @Nullable Expression> optionsMap;
    @ElementList(inline=true, required=false)
    private List<SWComponent> components;
    @Element(name="description", required=false)
    @Nullable
    private Description description;
    @ElementList(inline=true, required=false)
    private List<Mode> modes;
    @Element(name="script", required=false)
    @Nullable
    private Script script;
    @Element(name="user_functions", required=false)
    @Nullable
    private UserFunctions userFunctions;
    @ElementList(inline=true)
    private List<ConfigSet> configSets;
    @Element(name="global_config_set_ref", required=false)
    @Nullable
    private String globalConfigSetRef;
    @Attribute(name="global_only", required=false)
    private boolean globalOnly;
    @Attribute(name="hidden", required=false)
    private boolean hidden;
    @Attribute(name="schemaLocation", required=false)
    @Namespace(prefix="xsi", reference="http://www.w3.org/2001/XMLSchema-instance")
    private String schemaLocation;
    @Nullable
    ConfigSet globalConfigSet;

    public ConfigurationComponent(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable String category, @Nullable String options, @Nullable OptionsExpr optionsExpr, List<SWComponent> components, @Nullable String globalConfigSetRef, @Nullable Description description, boolean globalOnly, @Nullable Script script, @Nullable UserFunctions userFunctions, boolean hidden) {
        super(uiName, uiNameExpr);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.schemaLocation = XMLConstants.COMPONENT_SCHEMA_LOC;
        this.id = id;
        this.category = category;
        this.options = options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap(options, optionsExpr, this);
        this.components = components;
        this.globalConfigSetRef = globalConfigSetRef;
        this.configSets = new ArrayList<ConfigSet>();
        this.modes = new ArrayList<Mode>();
        this.script = script;
        this.userFunctions = userFunctions;
        this.globalConfigSet = null;
        this.description = description;
        this.globalOnly = globalOnly;
        this.hidden = hidden;
    }

    @Deprecated
    protected ConfigurationComponent() {
        this("", null, null, null, null, null, new ArrayList<SWComponent>(), null, null, false, null, null, false);
    }

    public String getSchemaLocation() {
        String[] locPair = this.schemaLocation.split(" ");
        if (2 != locPair.length) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("Component with ID {0} specifies an invalid schema location {1}", this.id, this.schemaLocation));
            }
            return "";
        }
        String loc = locPair[1];
        return loc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<String> getPresentOptions() {
        return CollectionsUtils.unmodifiableCollection((Collection)CollectionsUtils.safeKeySet(this.optionsMap));
    }

    @Override
    public @Nullable Object getOptionValue(String key, IContext context) {
        Expression expression = this.optionsMap.get(key);
        if (expression == null) {
            return null;
        }
        Object resolvedObject = expression.resolve(context).getValue();
        return resolvedObject;
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.optionsMap.containsKey(option);
    }

    @Commit
    public void commit() {
        if (this.options != null || this.optionsExpr != null) {
            this.optionsMap = SettingUtils.createOptionsMap(this.options, this.optionsExpr, this);
        }
    }

    public @Nullable String getOptions() {
        return this.options;
    }

    public @Nullable OptionsExpr getOptionsExpression() {
        return this.optionsExpr;
    }

    public void setOptions(@Nullable String options, @Nullable OptionsExpr optionsExpr) {
        this.options = options;
        this.optionsExpr = optionsExpr;
        this.optionsMap = SettingUtils.createOptionsMap(this.options, this.optionsExpr, this);
    }

    public boolean isGlobalOnly() {
        return this.globalOnly;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public @Nullable ConfigSet findConfigSet(String confSetID) {
        if (this.globalConfigSet != null && this.globalConfigSet.getId().equals(confSetID)) {
            return this.globalConfigSet;
        }
        return (ConfigSet)CollectionsUtils.nullableOptionalGet(this.configSets.stream().filter(x -> x.getId().equals(confSetID)).findFirst());
    }

    public boolean addMode(Mode mode) {
        return this.modes.add(mode);
    }

    public boolean addConfigSet(ConfigSet configSet) {
        return this.configSets.add(configSet);
    }

    public boolean addUserFunction(FunctionDef def) {
        UserFunctions userFunctionsLoc = this.userFunctions;
        if (userFunctionsLoc == null) {
            userFunctionsLoc = this.userFunctions = new UserFunctions(new ArrayList<FunctionDef>());
        }
        return userFunctionsLoc.addFunctionDef(def);
    }

    public List<ConfigSet> getConfigSets() {
        return CollectionsUtils.unmodifiableList(this.configSets);
    }

    public List<Mode> getScenarios() {
        return CollectionsUtils.unmodifiableList(this.modes);
    }

    public List<SWComponent> getComponents() {
        return this.components;
    }

    public @Nullable Mode getMode(String modeId) {
        for (Mode mode : this.modes) {
            if (!modeId.equals(mode.getId())) continue;
            return mode;
        }
        return null;
    }

    public @Nullable Script getScript() {
        return this.script;
    }

    public @Nullable UserFunctions getUserFunctions() {
        return this.userFunctions;
    }

    public @Nullable ConfigSet getConfigSet(String configSetId) {
        for (ConfigSet configSet : this.configSets) {
            if (!configSetId.equals(configSet.getId())) continue;
            return configSet;
        }
        return null;
    }

    @Override
    public @Nullable Description getDescription() {
        return this.description;
    }

    public String getLabel(IContext context) {
        return this.getUIName(context);
    }

    public @Nullable String getCategory() {
        return this.category;
    }

    @Validate
    private void validate() {
        if (!UtilsText.isEmpty((String)this.globalConfigSetRef)) {
            this.globalConfigSet = (ConfigSet)CollectionsUtils.nullableOptionalGet(this.configSets.stream().filter(x -> x.getId().equals(this.globalConfigSetRef)).findFirst());
            if (this.globalConfigSet == null) {
                LOGGER.severe(MessageFormat.format("Component with ID {0} references an unknown global config-set with ID {1}", this.id, this.globalConfigSetRef));
            }
        }
    }

    public @Nullable ConfigSet getGlobalConfigSet() {
        return this.globalConfigSet;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "id" + "=" + this.getId() + ", " + super.toString() + ", " + "category" + "=" + this.getCategory() + ", " + "options" + "=" + this.getOptions() + ", " + "options_expr" + "=" + this.getOptionsExpression() + ", components(fst " + 3 + ")=" + CollectionsUtils.firstN(this.components, (int)3) + ", " + "description" + "=" + this.getDescription() + ", " + "global_only" + "=" + this.isGlobalOnly() + ", " + "hidden" + "=" + this.isHidden() + ", modes(fst " + 3 + ")=" + CollectionsUtils.firstN(this.modes, (int)3) + ", " + "script" + "=" + this.getScript() + ", " + "user_functions" + "=" + this.getUserFunctions() + ", " + "global_config_set_ref" + "=" + this.getGlobalConfigSet() + ", configSets(fst " + 3 + ")=" + CollectionsUtils.firstN(this.configSets, (int)3) + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.components);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Boolean.hashCode(this.globalOnly);
        result = 31 * result + Boolean.hashCode(this.hidden);
        result = 31 * result + this.configSets.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.category);
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Objects.hashCode(this.optionsExpr);
        result = 31 * result + this.modes.hashCode();
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.userFunctions);
        result = 31 * result + Objects.hashCode(this.globalConfigSetRef);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ConfigurationComponent other = (ConfigurationComponent)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.category, other.category)) {
            return false;
        }
        if (!Objects.equals(this.options, other.options)) {
            return false;
        }
        if (!Objects.equals(this.optionsExpr, other.optionsExpr)) {
            return false;
        }
        if (!Objects.equals(this.components, other.components)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (this.globalOnly != other.globalOnly) {
            return false;
        }
        if (this.hidden != other.hidden) {
            return false;
        }
        if (!this.configSets.equals(other.configSets)) {
            return false;
        }
        if (!this.modes.equals(other.modes)) {
            return false;
        }
        if (!Objects.equals(this.script, other.script)) {
            return false;
        }
        if (!Objects.equals(this.userFunctions, other.userFunctions)) {
            return false;
        }
        return Objects.equals(this.globalConfigSetRef, other.globalConfigSetRef);
    }

    public boolean saveToFile(String fileName) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(fileName);){
                this.saveToStream(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error saving component file " + fileName, e);
            return false;
        }
        return true;
    }

    public String saveToString() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.saveToStream(out);
                return new String(out.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Error saving to string: " + e.getMessage());
            return "";
        }
    }

    public void saveToStream(OutputStream out) throws Exception {
        Format format = new Format(4, "<?xml version=\"1.0\" encoding= \"UTF-8\" ?>");
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy, format);
        serializer.write((Object)this, out);
    }

    public static @Nullable ConfigurationComponent loadComponentFromFile(File source, LoadMode mode, @Nullable Collection<String> configSetIds) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = UtilsDecryption.getFileInputStream((File)source);){
                Persister serializer = new Persister();
                ConfigurationComponent result = (ConfigurationComponent)serializer.read(ConfigurationComponent.class, is);
                if (SWToolsProperties.isVerificationOn()) {
                    try {
                        URL schema;
                        try {
                            schema = new URL(result.getSchemaLocation());
                            SettingUtils.verifySchemaVersion(schema, source);
                        }
                        catch (MalformedURLException e) {
                            LOGGER.log(Level.SEVERE, String.format("Invalid schema URL in component file %1s", source.getAbsolutePath()), e);
                            schema = null;
                        }
                        UtilsXML.validXml((InputStream)UtilsDecryption.getFileInputStream((File)source), (URL)schema, (Path)ConfigurationComponent.getFallbackSchemaLocation());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, String.format("Missing schema for component file %1s", source.getAbsolutePath()), e);
                    }
                    catch (SAXException e) {
                        LOGGER.log(Level.SEVERE, String.format("Invalid component file %1s", source.getAbsolutePath()), e);
                    }
                    if (result.isGlobalOnly() && !result.getScenarios().isEmpty()) {
                        LOGGER.log(Level.WARNING, String.format("Found '%1s' element(s) in a global component file %2s", "mode", source.getAbsolutePath()));
                    }
                }
                switch (mode) {
                    case DATA_UPDATE: {
                        if (configSetIds != null) {
                            for (ConfigSet set : result.getConfigSets()) {
                                if (!configSetIds.contains(set.getId())) continue;
                                set.removeGenTypes();
                            }
                            break;
                        }
                        result.getConfigSets().forEach(ConfigSet::removeGenTypes);
                        break;
                    }
                    case STANDARD: {
                        break;
                    }
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error loading component file " + source.getAbsolutePath(), e);
            return null;
        }
    }

    private static Path getFallbackSchemaLocation() {
        return Paths.get(Platform.isRunning() ? PEConfiguration.getSystemDirectory() : "", "resources", "schemas", LOCAL_SCHEMA);
    }

    @Override
    public @Nullable String getResolvedDescription(IContext context) {
        if (this.description != null) {
            return this.description.getDescription(context);
        }
        return null;
    }

    public static enum LoadMode {
        DATA_UPDATE,
        STANDARD,
        RAW;

    }
}

