/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.data.Code;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.FragmentDefs;
import com.nxp.swtools.periphs.model.data.IActiveContextRefResolver;
import com.nxp.swtools.periphs.model.data.IQuickSelectionGroup;
import com.nxp.swtools.periphs.model.data.IReferenceSettingResolver;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSelectionsGroup;
import com.nxp.swtools.periphs.model.data.Validation;
import com.nxp.swtools.periphs.model.data.setting.ABaseModel;
import com.nxp.swtools.periphs.model.data.setting.ACollectionSetting;
import com.nxp.swtools.periphs.model.data.setting.ArraySetting;
import com.nxp.swtools.periphs.model.data.setting.BoolSetting;
import com.nxp.swtools.periphs.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.periphs.model.data.setting.EnumSetting;
import com.nxp.swtools.periphs.model.data.setting.FixmeSetting;
import com.nxp.swtools.periphs.model.data.setting.FloatSetting;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.InfoSetting;
import com.nxp.swtools.periphs.model.data.setting.IntegerSetting;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import com.nxp.swtools.periphs.model.data.setting.StringSetting;
import com.nxp.swtools.periphs.model.data.setting.StructSetting;
import com.nxp.swtools.periphs.model.data.setting.VariableSetting;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Path;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="config_set", strict=false)
@Order(elements={"description", "generated_types", "user_types", "settings", "fragment_defs", "code", "validation", "quick_selections"}, attributes={"id", "label", "label_expr", "from_source", "options"})
public class ConfigSet
extends ABaseModel
implements IReferenceSettingResolver,
IQuickSelectionGroup {
    private static final Logger LOGGER = LogManager.getLogger(ConfigSet.class);
    private LinkedHashMap<String, ISetting> generatedTypes;
    private LinkedHashMap<String, ISetting> userTypes;
    private LinkedHashMap<String, ISetting> settings;
    @Attribute(name="from_source", required=false)
    private String source;
    @Element(type=FragmentDefs.class, name="fragment_defs", required=false)
    private FragmentDefs fragmentDefs;
    @Element(type=Code.class, name="code", required=false)
    private Code code;
    @Element(type=Validation.class, name="validation", required=false)
    private Validation validation;
    @Element(name="quick_selections")
    private QuickSelectionsGroup qsGroup;

    @Path(value="generated_types")
    @ElementListUnion(value={@ElementList(type=FixmeSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private List<ISetting> getGeneratedTypesList() {
        return CollectionsUtils.listFromMapValues(this.generatedTypes);
    }

    @Path(value="generated_types")
    @ElementListUnion(value={@ElementList(type=FixmeSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setGeneratedTypesList(List<ISetting> generatedTypesList) {
        this.addGeneratedTypes(generatedTypesList);
    }

    @Path(value="user_types")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private List<ISetting> getUserTypesList() {
        return CollectionsUtils.listFromMapValues(this.userTypes);
    }

    @Path(value="user_types")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setUserTypesList(List<ISetting> userTypesList) {
        this.addUserTypes(userTypesList);
    }

    @Path(value="settings")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    public List<ISetting> getSettingsList() {
        return CollectionsUtils.listFromMapValues(this.settings);
    }

    @Path(value="settings")
    @ElementListUnion(value={@ElementList(type=ArraySetting.class, required=false, inline=true), @ElementList(type=SetSetting.class, required=false, inline=true), @ElementList(type=DynamicEnumSetting.class, required=false, inline=true), @ElementList(type=InfoSetting.class, required=false, inline=true), @ElementList(type=VariableSetting.class, required=false, inline=true), @ElementList(type=EnumSetting.class, required=false, inline=true), @ElementList(type=ReferenceSetting.class, required=false, inline=true), @ElementList(type=StructSetting.class, required=false, inline=true), @ElementList(type=BoolSetting.class, required=false, inline=true), @ElementList(type=FloatSetting.class, required=false, inline=true), @ElementList(type=StringSetting.class, required=false, inline=true), @ElementList(type=IntegerSetting.class, required=false, inline=true)})
    private void setSettingsList(List<ISetting> settingsList) {
        this.addSettings(settingsList);
    }

    @Deprecated
    protected ConfigSet() {
        this("", null, null, "", null);
    }

    public ConfigSet(String id, @Nullable String uiName, @Nullable String uiNameExpr, String source, @Nullable Description description) {
        super(id, uiName, uiNameExpr, description, null, null, null, null);
        if (uiName == null && uiNameExpr == null) {
            this.setUINameString(id);
        }
        this.source = source;
        this.userTypes = new LinkedHashMap();
        this.settings = new LinkedHashMap();
        this.generatedTypes = new LinkedHashMap();
        this.qsGroup = new QuickSelectionsGroup();
        this.code = new Code();
        this.fragmentDefs = new FragmentDefs();
        this.validation = new Validation();
    }

    public void addGeneratedType(ISetting newType) {
        if (this.generatedTypes.put(newType.getId(), newType) != null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("Duplicate element ID {0} detected inside {1} - only last element is used.", newType.getId(), this));
        }
    }

    public void addGeneratedTypes(LinkedHashMap<String, ISetting> newGeneratedTypes) {
        newGeneratedTypes.values().stream().forEachOrdered(generatedType -> this.addGeneratedType((ISetting)generatedType));
    }

    public void addGeneratedTypes(List<ISetting> newGeneratedTypes) {
        newGeneratedTypes.stream().forEachOrdered(generatedType -> this.addGeneratedType((ISetting)generatedType));
    }

    public void addUserType(ISetting newType) {
        if (this.userTypes.put(newType.getId(), newType) != null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("Duplicate element ID {0} detected inside {1} - only last element is used.", newType.getId(), this));
        }
    }

    public void addUserTypes(LinkedHashMap<String, ISetting> newUserTypes) {
        newUserTypes.values().stream().forEachOrdered(userType -> this.addUserType((ISetting)userType));
    }

    public void addUserTypes(List<ISetting> newUserTypes) {
        newUserTypes.stream().forEachOrdered(userType -> this.addUserType((ISetting)userType));
    }

    public void addSetting(ISetting setting) {
        if (this.settings.put(setting.getId(), setting) != null && SWToolsProperties.isVerificationOn()) {
            LOGGER.severe(MessageFormat.format("Duplicate element ID {0} detected inside {1} - only last element is used.", setting.getId(), this));
        }
    }

    public void addSettings(LinkedHashMap<String, ISetting> newSettings) {
        newSettings.values().stream().forEachOrdered(setting -> this.addSetting((ISetting)setting));
    }

    public void addSettings(List<ISetting> newSettings) {
        newSettings.stream().forEachOrdered(setting -> this.addSetting((ISetting)setting));
    }

    public boolean addQuickSelection(QuickSelection quickSelection) {
        return this.qsGroup.addQuickSelection(quickSelection);
    }

    public void setCode(Code newCode) {
        this.code = newCode;
    }

    public void setFragmentDefs(FragmentDefs newFragmentDefs) {
        this.fragmentDefs = newFragmentDefs;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    @Override
    public List<QuickSelection> getQuickSelections() {
        return this.qsGroup.getQuickSelections();
    }

    @Override
    public boolean hasQuickSelections() {
        return true;
    }

    public @Nullable QuickSelection getQuickSelection(String qsId) {
        return (QuickSelection)CollectionsUtils.nullableOptionalGet(this.qsGroup.getQuickSelections().stream().filter(x -> x.getId().equals(qsId)).findFirst());
    }

    @Override
    public @Nullable QuickSelection getDefaultQS() {
        return this.qsGroup.getDefaultQS();
    }

    public void setDefaultQS(QuickSelection qs) {
        this.qsGroup.setDefaultQS(qs);
    }

    public LinkedHashMap<String, ISetting> getSettings() {
        return this.settings;
    }

    public String getSource() {
        return this.source;
    }

    public Code getCode() {
        return this.code;
    }

    public FragmentDefs getFragmentDefs() {
        return this.fragmentDefs;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public @Nullable ISetting find(String ... settingId) {
        ISetting refSetting = null;
        String[] stringArray = settingId;
        int n = settingId.length;
        int n2 = 0;
        while (n2 < n) {
            String splitIdPart = stringArray[n2];
            if (refSetting instanceof ArraySetting) {
                refSetting = ((ArraySetting)refSetting).getReferenceType();
            } else if (refSetting instanceof ACollectionSetting) {
                refSetting = ((ACollectionSetting)refSetting).getSetting(splitIdPart);
            } else {
                ISetting iSetting = refSetting = refSetting == null ? this.find(splitIdPart) : null;
            }
            if (refSetting == null) break;
            ++n2;
        }
        return refSetting;
    }

    private @Nullable ISetting find(String settingId) {
        ISetting setting = null;
        setting = this.settings.get(settingId);
        if (setting == null) {
            setting = this.userTypes.get(settingId);
        }
        if (setting == null) {
            setting = this.generatedTypes.get(settingId);
        }
        return setting;
    }

    void removeGenTypes() {
        this.generatedTypes.clear();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + super.toString() + ", " + "from_source" + "=" + this.getSource() + ", " + "settings" + "(fst " + 3 + ")=" + CollectionsUtils.firstN(this.getSettingsList(), (int)3) + ", " + "quick_selections" + "=" + this.qsGroup + ", " + "code" + "=" + this.getCode() + ", " + "fragment_defs" + "=" + this.getFragmentDefs() + ", " + "validation" + "=" + this.getValidation() + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.generatedTypes.hashCode();
        result = 31 * result + this.qsGroup.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.userTypes.hashCode();
        result = 31 * result + this.code.hashCode();
        result = 31 * result + this.fragmentDefs.hashCode();
        result = 31 * result + this.validation.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ConfigSet other = (ConfigSet)obj;
        if (!this.source.equals(other.source)) {
            return false;
        }
        if (!this.generatedTypes.equals(other.generatedTypes)) {
            return false;
        }
        if (!this.qsGroup.equals(other.qsGroup)) {
            return false;
        }
        if (!this.settings.equals(other.settings)) {
            return false;
        }
        if (!this.userTypes.equals(other.userTypes)) {
            return false;
        }
        if (!this.code.equals(other.code)) {
            return false;
        }
        if (!this.fragmentDefs.equals(other.fragmentDefs)) {
            return false;
        }
        return this.validation.equals(other.validation);
    }

    @Override
    public void resolve(IActiveContextRefResolver sdkRefResolver, ConfigurationComponent comp, String setID) {
        sdkRefResolver.resolve(this, this.settings, comp, setID);
    }

    @Override
    @Commit
    public void commit() {
        super.commit();
        this.verify();
    }

    public void verify() {
        if (SWToolsProperties.isVerificationOn() && this.isOptionSet("UI_BORDER_HIDDEN") && this.isOptionSet("UI_LABEL_HIDDEN") && !this.getValidation().getConstraints().isEmpty()) {
            LOGGER.severe("Setting with id: " + this.getId() + " has defined options: " + "UI_BORDER_HIDDEN" + " and " + "UI_LABEL_HIDDEN" + ", therefore it cannot contain any validations");
        }
    }
}

