/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class ComponentsProvider {
    public static final String COMPONENT_EXTENSION = "component";
    private static final Logger LOGGER = LogManager.getLogger(ComponentsProvider.class);

    private ComponentsProvider() {
    }

    public static Collection<ComponentInfo> getComponentsInfo(String componentsDir, String sdkVersion) {
        ArrayList<ComponentInfo> configurationComponentTypeIds = new ArrayList<ComponentInfo>();
        List components = UtilsFile.findFilesByExtension((String)componentsDir, (String)COMPONENT_EXTENSION);
        for (String file : components) {
            File componentFile = new File(file);
            File fullNameFolder = new File(file).getParentFile();
            if (fullNameFolder == null) {
                LOGGER.severe(MessageFormat.format("Can't find full folder name for component: ", componentFile.getAbsolutePath()));
                continue;
            }
            ComponentInfo info = new ComponentInfo(UtilsText.safeString((String)fullNameFolder.getName()), sdkVersion, fullNameFolder);
            Path path = componentFile.toPath();
            assert (path != null);
            configurationComponentTypeIds.add(info);
        }
        return new ArrayList<ComponentInfo>(configurationComponentTypeIds);
    }

    public static Collection<ConfigurationComponentTypeId> getComponents(Collection<ComponentInfo> componentsInfo) {
        ArrayList<ConfigurationComponentTypeId> result = new ArrayList<ConfigurationComponentTypeId>();
        for (ComponentInfo info : componentsInfo) {
            ConfigurationComponentTypeId component = ComponentsProvider.loadComponent(info);
            if (component == null) continue;
            result.add(component);
        }
        return result;
    }

    private static @Nullable ConfigurationComponentTypeId loadComponent(ComponentInfo info) {
        ConfigurationComponentTypeId result = null;
        Collection componentFiles = UtilsFile.getAllFilesInDir((File)info.getComponentDir(), (boolean)false, (String)COMPONENT_EXTENSION);
        if (componentFiles.isEmpty()) {
            LOGGER.severe("No component file found in: " + info.getComponentDir());
        } else {
            File componentFile;
            ConfigurationComponent component;
            if (componentFiles.size() > 1) {
                LOGGER.warning("More component files found in: " + info.getComponentDir() + ", loading only first of them");
            }
            if ((component = ConfigurationComponent.loadComponentFromFile(componentFile = (File)componentFiles.iterator().next(), ConfigurationComponent.LoadMode.STANDARD, null)) == null) {
                LOGGER.severe("Component could not be loaded: " + componentFile);
            } else {
                result = new ConfigurationComponentTypeId(info, component);
            }
        }
        return result;
    }
}

