/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.version.VersionUtils;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.SWComponent;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.osgi.framework.Version;

public class Components {
    private static final BigInteger MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED = BigInteger.valueOf(100000L);
    protected Collection<ConfigurationComponentTypeId> confCompTypeIds;

    public Components(Collection<ConfigurationComponentTypeId> confCompTypeIds) {
        this.confCompTypeIds = confCompTypeIds;
    }

    public boolean addConfigurationComponent(ComponentConfig componentConfig) {
        return this.confCompTypeIds.add(componentConfig.getConfigCompTypeId());
    }

    public static @Nullable BigInteger computeMatchScore(SWComponent swComp, SupportedSdkComponent sdkComp) {
        return Components.computeMatchScore(swComp.getVersion(), sdkComp.getVersion());
    }

    public static @Nullable BigInteger computeMatchScore(@Nullable Version versionRequired, Version versionActual) {
        if (versionRequired != null) {
            BigInteger deltaMicro = BigInteger.valueOf(Math.abs(versionRequired.getMicro() - versionActual.getMicro()));
            if (VersionUtils.equivalent((Version)versionActual, (Version)versionRequired)) {
                return deltaMicro.negate();
            }
            if (VersionUtils.equivalent((Version)versionRequired, (Version)versionActual)) {
                return deltaMicro.multiply(MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED).negate();
            }
        }
        return null;
    }

    public static @Nullable BigInteger computeMatchScore(ConfigurationComponentTypeId comp, SdkComponentsTable supportedComps) {
        BigInteger result = BigInteger.ZERO;
        for (SWComponent swComp : comp.getConfigurationComponent().getComponents()) {
            SupportedSdkComponent bestMatchingSdkComp = Components.findBestMatchingSdkComponent(swComp, supportedComps);
            if (bestMatchingSdkComp == null) {
                return null;
            }
            BigInteger bestMatchScore = Components.computeMatchScore(swComp, bestMatchingSdkComp);
            if (bestMatchScore == null) {
                return null;
            }
            result = result.add(bestMatchScore);
        }
        return result;
    }

    public static @Nullable SupportedSdkComponent findBestMatchingSdkComponent(SWComponent swComponent, SdkComponentsTable supportedComps) {
        SupportedSdkComponent result = (SupportedSdkComponent)CollectionsUtils.nullableOptionalGet(supportedComps.findById(swComponent.getName()).filter(sdkComp -> Components.computeMatchScore(swComponent, sdkComp) != null).max(Comparator.comparing(sdkComp -> Components.computeMatchScore(swComponent, sdkComp))));
        return result;
    }

    public @Nullable Triplet<ISetting, ConfigSet, ConfigurationComponent> findSetting(ConfigurationComponent confComp, String confSetID, String settingID, boolean autoResolve) {
        return Components.findSetting(this.getConfigComps(), confComp, confSetID, settingID, autoResolve);
    }

    public static @Nullable Triplet<ISetting, ConfigSet, ConfigurationComponent> findSetting(Collection<ConfigurationComponent> components, ConfigurationComponent confComp, String confSetID, String settingID, boolean autoResolve) {
        HashSet<ReferenceSetting> references = new HashSet<ReferenceSetting>();
        ISetting result = null;
        ReferenceSetting prevReference = null;
        ConfigurationComponent comp = confComp;
        ConfigSet confSet = null;
        do {
            String refConfSetID;
            if (comp != null) {
                confSet = comp.findConfigSet(confSetID);
            }
            if (confSet != null) {
                result = confSet.find(settingID.split("\\."));
            }
            if (prevReference != null && result != null) {
                result = result.fromReference(prevReference);
            }
            if (!(result instanceof ReferenceSetting)) continue;
            assert (comp != null);
            ReferenceSetting reference = (ReferenceSetting)result;
            if (!references.add(reference)) {
                String id = SettingUtils.buildId(comp.getId(), confSetID, settingID);
                throw new IllegalStateException("Cycle detected while finding " + id + ", composed of " + references);
            }
            String refCompID = reference.getComponentRefID();
            if (refCompID != null && !refCompID.equals(comp.getId())) {
                comp = (ConfigurationComponent)CollectionsUtils.nullableOptionalGet(components.stream().filter(x -> x.getId().equals(refCompID)).findFirst());
            }
            confSetID = (refConfSetID = reference.getConfigSetRefID()) == null ? confSetID : refConfSetID;
            settingID = reference.getReferenceID();
            prevReference = reference;
        } while (autoResolve && result instanceof ReferenceSetting);
        if (result == null || confSet == null || comp == null) {
            return null;
        }
        return new Triplet((Object)result, (Object)confSet, (Object)comp);
    }

    public Collection<ConfigurationComponent> getConfigComps() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.confCompTypeIds.stream().map(x -> x.getConfigurationComponent()).collect(CollectorsUtils.toList())));
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeId(String typeId) {
        return (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().filter(x -> x.getTypeId().equals(typeId)).findAny());
    }

    public Collection<ConfigurationComponentTypeId> getConfigCompTypeIds() {
        return CollectionsUtils.unmodifiableCollection(this.confCompTypeIds);
    }
}

