/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableComponentsRefResolver;
import com.nxp.swtools.periphs.model.data.AvailableResourceTables;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.IActiveContextRefResolver;
import com.nxp.swtools.periphs.model.data.IReferenceSettingResolver;
import com.nxp.swtools.periphs.model.data.ResourceTable;
import com.nxp.swtools.periphs.model.data.setting.ACollectionSetting;
import com.nxp.swtools.periphs.model.data.setting.ArraySetting;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableResourceTablesRefResolver
implements IActiveContextRefResolver {
    private static final Logger LOGGER = LogManager.getLogger(AvailableResourceTablesRefResolver.class);
    protected AvailableResourceTables activeResourceTables;
    protected AvailableComponents activeComponents;
    @Nullable
    protected ResourceTable currentResourceTable;

    public AvailableResourceTablesRefResolver(AvailableResourceTables activeResourceTables, AvailableComponents activeComponents) {
        this.activeResourceTables = activeResourceTables;
        this.activeComponents = activeComponents;
    }

    public void resolve() {
        for (ResourceTable t : this.activeResourceTables.getResourceTables()) {
            t.resolve(this);
        }
    }

    @Override
    public void resolve(IID caller, Map<String, ISetting> where, @Nullable ConfigurationComponent comp, String setID) {
        ResourceTable owner = this.currentResourceTable;
        if (owner == null) {
            throw new IllegalStateException("Incorrect method usage - use {@link #resolve(ResourceTable, LinkedHashMap)}");
        }
        for (ISetting sett : where.values()) {
            if (sett instanceof ACollectionSetting) {
                ACollectionSetting coll = (ACollectionSetting)sett;
                this.resolve(caller, coll.getSettings(), comp, setID);
                continue;
            }
            if (!(sett instanceof ArraySetting)) continue;
            ArraySetting arr = (ArraySetting)sett;
            arr.resolve(this, comp, setID);
        }
        for (ISetting sett : where.values()) {
            if (!(sett instanceof ReferenceSetting)) continue;
            ReferenceSetting rs = (ReferenceSetting)sett;
            this.resolveReferenceSetting(caller, where, comp, setID, rs);
        }
    }

    private void resolveReferenceSetting(IID caller, Map<String, ISetting> where, @Nullable ConfigurationComponent comp, String setID, ReferenceSetting rs) {
        ResourceTable owner = this.currentResourceTable;
        if (owner == null) {
            throw new IllegalStateException("Incorrect method usage - use {@link #resolve(ResourceTable, Map)}");
        }
        if (comp != null) {
            Triplet<ISetting, ConfigSet, ConfigurationComponent> target = this.activeComponents.findSetting(comp, setID, rs.getReferenceID(), false);
            if (target == null) {
                LOGGER.severe(MessageFormat.format("An instance of {0} with ID {1} contains an unresolvable reference with ID {2}", caller.getClass().getSimpleName(), caller.getId(), rs.getId()));
            } else {
                ISetting targetSett = (ISetting)target.getFirst();
                ConfigSet targetSet = (ConfigSet)target.getSecond();
                ConfigurationComponent targetComp = (ConfigurationComponent)target.getThird();
                if (!comp.getId().equals(targetComp.getId()) && !targetComp.getComponents().isEmpty()) {
                    LOGGER.severe(MessageFormat.format("Cannot resolve {0} since component with ID {1} contains {2}", rs.toString(), targetComp.getId(), targetComp.getComponents()));
                    return;
                }
                if (!AvailableComponentsRefResolver.canImport(targetSett, targetComp, comp)) {
                    LOGGER.severe(MessageFormat.format("Cannot resolve {0} since {1} is not public", rs.toString(), rs.getReferenceID()));
                    return;
                }
                if (targetSett instanceof IReferenceSettingResolver) {
                    ((IReferenceSettingResolver)((Object)targetSett)).resolve(this, targetComp, targetSet.getId());
                }
                ISetting fromReference = targetSett.fromReference(rs);
                where.put(fromReference.getId(), fromReference);
            }
            return;
        }
        if (!setID.isEmpty()) {
            LOGGER.severe(MessageFormat.format("An instance of {0} with ID {1} contains an unresolvable reference with ID {2} to a setting in an identified component and config-set with ID {3}", caller.getClass().getSimpleName(), caller.getId(), rs.getId(), setID));
            return;
        }
        ISetting targetSett = owner.find(new String[]{rs.getReferenceID()});
        if (targetSett == null) {
            LOGGER.severe(MessageFormat.format("An instance of {0} with ID {1} contains an unresolvable reference with ID {2}", caller.getClass().getSimpleName(), caller.getId(), rs.getId()));
            return;
        }
        ISetting fromReference = targetSett.fromReference(rs);
        where.put(fromReference.getId(), fromReference);
        this.resolveCurrentResourceTable(caller, where);
    }

    public void resolve(ResourceTable caller, Map<String, ISetting> where) {
        this.currentResourceTable = caller;
        this.resolveCurrentResourceTable(caller, where);
        this.currentResourceTable = null;
    }

    private void resolveCurrentResourceTable(IID caller, Map<String, ISetting> where) {
        for (ISetting sett : where.values()) {
            if (sett instanceof ACollectionSetting) {
                ACollectionSetting coll = (ACollectionSetting)sett;
                this.resolveCurrentResourceTable(caller, coll.getSettings());
                continue;
            }
            if (!(sett instanceof ArraySetting)) continue;
            ArraySetting arr = (ArraySetting)sett;
            arr.resolve(this, null, "");
        }
        for (ISetting sett : where.values()) {
            if (!(sett instanceof ReferenceSetting)) continue;
            ReferenceSetting rs = (ReferenceSetting)sett;
            ConfigurationComponent compID = AvailableComponentsRefResolver.getRefComponent(this.activeComponents, rs, null);
            String setID = AvailableComponentsRefResolver.getRefConfigSet(rs, "");
            this.resolveReferenceSetting(caller, where, compID, setID, rs);
        }
    }
}

