/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.config.SettingConfigFactory;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.AvailableResourceTablesRefResolver;
import com.nxp.swtools.periphs.model.data.ResourceTable;
import com.nxp.swtools.periphs.model.data.ResourceTableInfo;
import com.nxp.swtools.periphs.model.data.ResourceTablesProvider;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.resources.DataDirectory;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableResourceTables {
    private static final Logger LOGGER = LogManager.getLogger(AvailableResourceTables.class);
    protected Collection<ResourceTableInfo> resourceTableInfos;
    protected Map<ResourceTable, Collection<ISettingConfig>> configs;
    protected IMcuIdentification mcuId;

    protected AvailableResourceTables(IMcuIdentification mcuId, Collection<ResourceTableInfo> resourceTableInfos) {
        this.mcuId = mcuId;
        this.resourceTableInfos = resourceTableInfos;
        this.configs = new HashMap<ResourceTable, Collection<ISettingConfig>>();
    }

    public AvailableResourceTables(IMcuIdentification mcuId, AvailableComponents activeComponents) {
        this.mcuId = mcuId;
        this.resourceTableInfos = this.loadResourceTables(activeComponents);
        new AvailableResourceTablesRefResolver(this, activeComponents).resolve();
        this.configs = new HashMap<ResourceTable, Collection<ISettingConfig>>();
    }

    public void associateResources(IMcu mcu) {
        this.configs.clear();
        for (ResourceTableInfo info : this.resourceTableInfos) {
            ArrayList<ISettingConfig> resources = new ArrayList<ISettingConfig>();
            AvailableResourceTables.associateResources(resources, info, mcu);
            this.configs.put(info.getResourceTable(), resources);
        }
    }

    private static void associateResources(Collection<ISettingConfig> resources, ResourceTableInfo info, IMcu mcu) {
        ChildContext emptyContext = new ChildContext(new PeriphsProfile(mcu, SharedConfigurationFactory.createSharedConfiguration()));
        ResourceTable table = info.getResourceTable();
        for (ISetting setting : table.getDefinition().values()) {
            AStoragePeriphsSetting data = table.getData().find(setting.getId());
            if (data == null) {
                LOGGER.severe(String.format("Missing resource setting data for ID %1s in %2s", setting.getId(), info.getFileName()));
                continue;
            }
            ISettingConfig config = SettingConfigFactory.createSettingConfig(setting.getId(), setting, emptyContext, data, mcu);
            resources.add(config);
        }
    }

    public IMcuIdentification getMcu() {
        return this.mcuId;
    }

    public @Nullable ISettingConfig getResource(String tableId, String definitionId) {
        ResourceTable table = this.getResourceTable(tableId);
        if (table != null) {
            return this.getSettingInResourceTable(definitionId, table);
        }
        return null;
    }

    private @Nullable ISettingConfig getSettingInResourceTable(String definitionId, ResourceTable table) {
        Collection<ISettingConfig> resources = this.configs.get(table);
        if (resources != null) {
            for (ISettingConfig setting : resources) {
                if (!setting.getId().equals(definitionId)) continue;
                return setting;
            }
        }
        return null;
    }

    public @Nullable ISettingConfig getResource(String tableId, String definitionId, String component) {
        ResourceTable table = this.getResourceTable(tableId, component);
        if (table != null) {
            return this.getSettingInResourceTable(definitionId, table);
        }
        return null;
    }

    public Collection<ResourceTableInfo> getResourceTableInfos() {
        return CollectionsUtils.unmodifiableCollection(this.resourceTableInfos);
    }

    public Collection<ResourceTable> getResourceTables() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.resourceTableInfos.stream().map(x -> x.getResourceTable()).collect(CollectorsUtils.toList())));
    }

    public @Nullable ResourceTable getResourceTable(String id) {
        return (ResourceTable)CollectionsUtils.nullableOptionalGet(this.resourceTableInfos.stream().map(y -> y.getResourceTable()).filter(x -> x.getId().equals(id)).findFirst());
    }

    public @Nullable ResourceTable getResourceTable(String id, String component) {
        String fileLocationSuffix = String.valueOf(component) + File.separator + id + "." + "resource";
        return (ResourceTable)CollectionsUtils.nullableOptionalGet(this.resourceTableInfos.stream().filter(x -> x.getFileName().endsWith(fileLocationSuffix)).map(y -> y.getResourceTable()).filter(x -> x.getId().equals(id)).findFirst());
    }

    protected Collection<ResourceTableInfo> loadResourceTables(AvailableComponents activeComponents) {
        ArrayList<ResourceTableInfo> result = new ArrayList<ResourceTableInfo>();
        if (!DataDirectory.isPeripheralsResourceTablesDirDefined(this.mcuId)) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("resource_tables not specified for selected part " + this.mcuId.getPackage() + " and SDK " + this.mcuId.getSdkVersion());
            }
            return result;
        }
        String componentsDir = DataDirectory.getPeripheralsComponentsDir(this.mcuId);
        Collection<ResourceTableInfo> mcuResourceTables = ResourceTablesProvider.getResourceTables(DataDirectory.getPeripheralsResourceTablesDir(this.mcuId));
        result.addAll(mcuResourceTables);
        activeComponents.getConfigCompTypeIds().stream().map(comp -> comp.getTypeId()).forEach(typeId -> {
            Collection<ResourceTableInfo> componentResourceTable = ResourceTablesProvider.getResourceTablesOfComponent(String.valueOf(componentsDir) + File.separator + typeId);
            result.addAll(componentResourceTable);
        });
        return result;
    }
}

