/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.AvailableComponents;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.IActiveContextRefResolver;
import com.nxp.swtools.periphs.model.data.IReferenceSettingResolver;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.periphs.model.data.setting.ACollectionSetting;
import com.nxp.swtools.periphs.model.data.setting.ArraySetting;
import com.nxp.swtools.periphs.model.data.setting.IID;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableComponentsRefResolver
implements IActiveContextRefResolver {
    private static final Logger LOGGER = LogManager.getLogger(AvailableComponentsRefResolver.class);
    private AvailableComponents activeComponents;
    private static ExpressionContext emptyContext = new ExpressionContext(new PeriphsProfile(new EmptyMcu("empty"), SharedConfigurationFactory.createSharedConfiguration()).getChildContext(), new EmptyMcu("empty"));

    public AvailableComponentsRefResolver(AvailableComponents activeComponents) {
        this.activeComponents = activeComponents;
    }

    public void resolve() {
        for (ConfigurationComponent c : this.activeComponents.getConfigComps()) {
            for (ConfigSet s : c.getConfigSets()) {
                String setID = s.getId();
                s.resolve(this, c, setID);
            }
        }
    }

    public @Nullable Triplet<ISetting, ConfigSet, ConfigurationComponent> find(@Nullable ConfigurationComponent confComp, String confSetID, ReferenceSetting r) {
        ConfigurationComponent refComponent = AvailableComponentsRefResolver.getRefComponent(this.activeComponents, r, confComp);
        if (refComponent == null) {
            return null;
        }
        return this.activeComponents.findSetting(refComponent, AvailableComponentsRefResolver.getRefConfigSet(r, confSetID), r.getReferenceID(), true);
    }

    @Override
    public void resolve(IID caller, Map<String, ISetting> where, @Nullable ConfigurationComponent comp, String setID) {
        for (ISetting sett : where.values()) {
            if (sett instanceof ACollectionSetting) {
                ACollectionSetting coll = (ACollectionSetting)sett;
                this.resolve(caller, coll.getSettings(), comp, setID);
            }
            if (!(sett instanceof ArraySetting)) continue;
            ArraySetting arr = (ArraySetting)sett;
            arr.resolve(this, comp, setID);
        }
        for (ISetting sett : where.values()) {
            if (!(sett instanceof ReferenceSetting)) continue;
            ReferenceSetting rs = (ReferenceSetting)sett;
            Triplet<ISetting, ConfigSet, ConfigurationComponent> target = this.find(comp, setID, rs);
            if (target == null) {
                LOGGER.severe(MessageFormat.format("An instance of {0} with ID {1} contains an unresolvable reference with ID {2} to a setting in component with ID {3} and config-set with ID {4}", caller.getClass().getSimpleName(), caller.getId(), rs.getId(), comp == null ? null : comp.getId(), setID));
                continue;
            }
            ISetting targetSett = (ISetting)target.getFirst();
            ConfigSet targetSet = (ConfigSet)target.getSecond();
            ConfigurationComponent targetComp = (ConfigurationComponent)target.getThird();
            if (comp != null && !comp.getId().equals(targetComp.getId()) && !targetComp.getComponents().isEmpty()) {
                LOGGER.severe(MessageFormat.format("Cannot resolve {0} since component with ID {1} contains {2}", rs.toString(), targetComp.getId(), targetComp.getComponents()));
                continue;
            }
            if (!AvailableComponentsRefResolver.canImport(targetSett, targetComp, comp)) {
                LOGGER.severe(MessageFormat.format("Cannot resolve {0} since {1} is not public", rs.toString(), rs.getReferenceID()));
                continue;
            }
            if (targetSett instanceof IReferenceSettingResolver) {
                ((IReferenceSettingResolver)((Object)targetSett)).resolve(this, targetComp, targetSet.getId());
            }
            ISetting fromReference = targetSett.fromReference(rs);
            where.put(fromReference.getId(), fromReference);
        }
    }

    public static boolean canImport(ISetting targetSett, @Nullable ConfigurationComponent targetComp, @Nullable ConfigurationComponent parentComp) {
        boolean externComp;
        if (targetComp == null) {
            return false;
        }
        boolean bl = externComp = parentComp == null || !parentComp.getId().equals(targetComp.getId());
        return !externComp || targetSett.isPublic(emptyContext);
    }

    public static @Nullable ConfigurationComponent getRefComponent(AvailableComponents availableComponents, ReferenceSetting r, @Nullable ConfigurationComponent parentComp) {
        String refCompID = r.getComponentRefID();
        if (refCompID != null) {
            List<ConfigurationComponent> configComps = availableComponents.getConfigComps(refCompID);
            if (configComps != null && !configComps.isEmpty()) {
                boolean allComponentsAreGlobal = configComps.stream().allMatch(c -> c.isGlobalOnly());
                if (!allComponentsAreGlobal) {
                    String compId = parentComp != null ? parentComp.getId() : "";
                    LOGGER.severe(MessageFormat.format("You should not reference non-global component: {0}! See attribute {1} of reference setting: {2} in component: {3}", r.getComponentRefID(), "component_id", r.getId(), compId));
                }
                if (parentComp != null && parentComp.getId().equals(refCompID)) {
                    LOGGER.info("You are referencing to the same component id that current component has. Current component will be used");
                    return parentComp;
                }
                return configComps.get(0);
            }
            LOGGER.severe("Component not found: " + refCompID);
        }
        return parentComp;
    }

    public static String getRefConfigSet(ReferenceSetting r, String parentConfSetID) {
        String refConfSetID = r.getConfigSetRefID();
        return refConfSetID == null ? parentConfSetID : refConfSetID;
    }
}

