/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponentsRefResolver;
import com.nxp.swtools.periphs.model.data.Category;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.periphs.model.data.ComponentsProvider;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.IActiveContextRefResolver;
import com.nxp.swtools.periphs.model.data.ProcessorRestrictions;
import com.nxp.swtools.periphs.model.data.SWComponent;
import com.nxp.swtools.periphs.model.resources.DataDirectory;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import java.io.File;
import java.io.FilenameFilter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.Version;

public class AvailableComponents
extends Components {
    private static final Logger LOGGER = LogManager.getLogger(AvailableComponents.class);
    private IMcuIdentification mcu;

    public AvailableComponents(IMcuIdentification mcu, IRegistersDatabaseAPI registersDb) {
        this(mcu, registersDb, null, null);
    }

    public AvailableComponents(IMcuIdentification mcu, IRegistersDatabaseAPI registersDb, @Nullable IActiveContextRefResolver refResolver, @Nullable String componentDirectory) {
        super(new ArrayList<ConfigurationComponentTypeId>());
        this.mcu = mcu;
        Collection<ConfigurationComponentTypeId> collection = this.confCompTypeIds = UtilsText.isEmpty((String)componentDirectory) ? this.loadCofigComps(registersDb) : AvailableComponents.loadCofigComps(mcu, UtilsText.safeString((String)componentDirectory), registersDb);
        if (refResolver == null) {
            new AvailableComponentsRefResolver(this).resolve();
        } else {
            if (!this.confCompTypeIds.isEmpty()) {
                Object[] componentTypeIdsArray = this.confCompTypeIds.toArray();
                if (componentTypeIdsArray.length <= 0) {
                    LOGGER.severe("Could not retrieve available components for the current mcu " + mcu.getBoard());
                    return;
                }
            } else {
                LOGGER.severe("Could not retrieve available components for the current mcu " + mcu.getBoard());
                return;
            }
            ConfigurationComponentTypeId componentTypeId = (ConfigurationComponentTypeId)this.confCompTypeIds.toArray()[0];
            ConfigurationComponent componentToBeProcessed = componentTypeId.getConfigurationComponent();
            componentToBeProcessed.getConfigSets().forEach(configSet -> refResolver.resolve(componentToBeProcessed, configSet.getSettings(), componentToBeProcessed, configSet.getId()));
        }
    }

    public static Collection<ConfigurationComponentTypeId> loadCofigComps(IMcuIdentification mcu, String componentsDir, IRegistersDatabaseAPI registersDb) {
        Collection<ComponentInfo> componentsInfo = ComponentsProvider.getComponentsInfo(componentsDir, mcu.getSdkVersion());
        AvailableComponents.filterComponentsInfo(componentsInfo, mcu);
        Collection<ConfigurationComponentTypeId> result = ComponentsProvider.getComponents(componentsInfo);
        if (SWToolsProperties.isVerificationOn()) {
            AvailableComponents.checkAndLogUnusablePeripherals(result, registersDb);
            AvailableComponents.logPeripheralsWithoutAlias(registersDb);
        }
        AvailableComponents.filterComponents(result, registersDb, mcu);
        return result;
    }

    protected Collection<ConfigurationComponentTypeId> loadCofigComps(IRegistersDatabaseAPI registersDb) {
        if (!DataDirectory.isPeripheralsComponentsDirDefined(this.mcu)) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("cfg_components not specified for selected part " + this.mcu.getPackage() + " and SDK " + this.mcu.getSdkVersion());
            }
            return CollectionsUtils.emptyList();
        }
        String componentsDir = DataDirectory.getPeripheralsComponentsDir(this.mcu);
        return AvailableComponents.loadCofigComps(this.mcu, componentsDir, registersDb);
    }

    private static boolean isPeripheralSupported(String peripheralType, IRegistersDatabaseAPI registersDb) {
        IRegParentPeripheralAPI[] peripherals;
        IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = peripherals = registersDb.getPeripherals();
        int n = peripherals.length;
        int n2 = 0;
        while (n2 < n) {
            IRegParentPeripheralAPI peripheral = iRegParentPeripheralAPIArray[n2];
            if (peripheralType.equals(peripheral.getAlias("type"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public @Nullable ConfigurationComponentTypeId getBestMatchingConfigCompTypeId(StoragePeriphsComponent storage) {
        List<ConfigurationComponentTypeId> configComps = this.getConfigCompTypeIds(storage);
        if (configComps == null || configComps.isEmpty()) {
            return null;
        }
        if (configComps.size() == 1) {
            return configComps.get(0);
        }
        return this.getBestMatchingConfigCompType(configComps);
    }

    public @Nullable ConfigurationComponentTypeId getBestMatchingConfigCompType(List<ConfigurationComponentTypeId> configComps) {
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(this.mcu);
        if (supportedComps == null) {
            return null;
        }
        if (!configComps.isEmpty()) {
            BigInteger bestMatchScore = null;
            ConfigurationComponentTypeId bestMatch = null;
            for (ConfigurationComponentTypeId comp : configComps) {
                BigInteger matchScore = AvailableComponents.computeMatchScore(comp, supportedComps);
                if (matchScore == null || bestMatchScore != null && matchScore.compareTo(bestMatchScore) <= 0) continue;
                bestMatch = comp;
                bestMatchScore = matchScore;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        }
        return null;
    }

    public static void filterComponentsInfo(Collection<ComponentInfo> componentsInfo, IMcuIdentification mcu) {
        componentsInfo.removeIf(c -> {
            ProcessorRestrictions processorRestrictions = AvailableComponents.loadProcessorRestrictions(c);
            if (processorRestrictions != null) {
                return !processorRestrictions.isAllowed(mcu.getPackage());
            }
            return false;
        });
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(mcu);
        if (supportedComps == null) {
            return;
        }
        componentsInfo.retainAll(componentsInfo.stream().filter(x -> x.getReferences().stream().allMatch(r -> supportedComps.getSupportedSdkComponents().stream().anyMatch(c -> c.getId().equals(r.getDriverName()) && AvailableComponents.computeMatchScore(new Version(r.getDriverVersion()), c.getVersion()) != null))).collect(Collectors.toList()));
    }

    private static @Nullable SdkComponentsTable getSdkComponentsTable(IMcuIdentification mcu) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu.getMcu(), mcu.getSdkVersion());
        return info == null ? null : derivatives.getSdkComponentsTable(info);
    }

    private static void filterComponents(Collection<ConfigurationComponentTypeId> configComps, IRegistersDatabaseAPI registersDb, IMcuIdentification mcu) {
        configComps.retainAll(configComps.stream().filter(x -> x.getConfigurationComponent().isGlobalOnly() || x.getConfigurationComponent().getScenarios().stream().map(y -> y.getMasterPeripheral()).filter(mp -> mp == null || mp.getPeripherals().stream().filter(z -> AvailableComponents.isPeripheralSupported(z, registersDb)).count() > 0L).count() > 0L).collect(Collectors.toSet()));
        HashSet<ConfigurationComponentTypeId> componentsToRetain = new HashSet<ConfigurationComponentTypeId>();
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(mcu);
        if (supportedComps == null) {
            return;
        }
        Map<String, List<ConfigurationComponentTypeId>> componentsByType = configComps.stream().collect(Collectors.groupingBy(c -> c.getConfigurationComponent().getId()));
        for (Map.Entry<String, List<ConfigurationComponentTypeId>> entry : componentsByType.entrySet()) {
            List<ConfigurationComponentTypeId> comps = entry.getValue();
            if (comps.isEmpty()) continue;
            HashSet<ConfigurationComponentTypeId> componentsToDiscard = new HashSet<ConfigurationComponentTypeId>();
            for (ConfigurationComponentTypeId comp : comps) {
                BigInteger matchScore = AvailableComponents.computeMatchScore(comp, supportedComps);
                if (matchScore != null) {
                    componentsToRetain.add(comp);
                    continue;
                }
                componentsToDiscard.add(comp);
            }
            if (componentsToDiscard.isEmpty() || !SWToolsProperties.isVerificationOn()) continue;
            AvailableComponents.checkAndLogUnsupportedDriverVersions(componentsToDiscard, supportedComps);
        }
        configComps.retainAll(componentsToRetain);
    }

    private static void checkAndLogUnusablePeripherals(Collection<ConfigurationComponentTypeId> comps, IRegistersDatabaseAPI registersDb) {
        Set usablePeripherals = comps.stream().flatMap(x -> x.getConfigurationComponent().getScenarios().stream()).map(x -> x.getMasterPeripheral()).filter(Objects::nonNull).flatMap(x -> {
            assert (x != null);
            return x.getPeripherals().stream();
        }).collect(Collectors.toSet());
        HashSet<@Nullable String> unusablePeripherals = new HashSet<String>();
        IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = registersDb.getPeripherals();
        int n = iRegParentPeripheralAPIArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRegParentPeripheralAPI peripheral = iRegParentPeripheralAPIArray[n2];
            String peripheralType = peripheral.getAlias("type");
            if (!usablePeripherals.contains(peripheralType)) {
                unusablePeripherals.add(peripheralType);
            }
            ++n2;
        }
        for (String unusablePeripheral : unusablePeripherals) {
            LOGGER.info("Configuration component for peripheral: " + unusablePeripheral + " does not exist or cannot be used");
        }
    }

    private static void checkAndLogUnsupportedDriverVersions(Collection<ConfigurationComponentTypeId> comps, SdkComponentsTable sdkComponents) {
        for (ConfigurationComponentTypeId comp : comps) {
            boolean allDriversFound = true;
            for (SWComponent swComponent : comp.getConfigurationComponent().getComponents()) {
                boolean bl = allDriversFound = allDriversFound && sdkComponents.findById(swComponent.getName()).count() > 0L;
            }
            if (!allDriversFound) continue;
            LOGGER.warning("Configuration component: " + comp.getConfigurationComponent().getId() + " cannot be used due to driver version(s) mismatch");
            break;
        }
    }

    private static void logPeripheralsWithoutAlias(IRegistersDatabaseAPI registersDb) {
        Arrays.stream(registersDb.getPeripherals()).filter(p -> p.getAlias("type") == null).forEach(p -> LOGGER.log(Level.SEVERE, "Peripheral \"" + p.getName() + "\" has no alias of type \"" + "type" + "\" in register db"));
    }

    public @Nullable List<ConfigurationComponent> getConfigComps(String ID) {
        List<ConfigurationComponent> matchingComponents = this.confCompTypeIds.stream().map(y -> y.getConfigurationComponent()).filter(x -> x.getId().equals(ID)).collect(Collectors.toList());
        if (matchingComponents.isEmpty()) {
            return null;
        }
        return matchingComponents;
    }

    public List<ConfigurationComponentTypeId> getConfigCompsTypeIdsForCategory(String categoryId) {
        return (List)this.getConfigCompTypeIds().stream().filter(cc -> categoryId.equals(cc.getConfigurationComponent().getCategory())).collect(CollectorsUtils.toList());
    }

    public List<ConfigurationComponentTypeId> getConfigCompsTypeIdsWithoutMatchingCategory(Collection<Category> categories) {
        return (List)this.getConfigCompTypeIds().stream().filter(configCompTypeId -> categories.stream().noneMatch(cat -> cat.getId().equals(configCompTypeId.getConfigurationComponent().getCategory()))).collect(CollectorsUtils.toList());
    }

    public @Nullable List<ConfigurationComponentTypeId> getConfigCompTypeIds(StoragePeriphsComponent storage) {
        ArrayList<ConfigurationComponentTypeId> result = new ArrayList<ConfigurationComponentTypeId>();
        ConfigurationComponentTypeId configCompTypeId = this.getConfigCompTypeId(storage.getTypeId());
        if (configCompTypeId == null) {
            List<ConfigurationComponentTypeId> matchingComponents = this.getComponentTypeIdsByType(storage.getName());
            if (matchingComponents != null) {
                result.addAll(matchingComponents);
                LOGGER.log(Level.INFO, "Component with type_id: " + storage.getTypeId() + " is not available. Using components with type: " + storage.getName());
            } else {
                LOGGER.log(Level.SEVERE, "[DATA] Component \"" + storage.getName() + "\" not found.");
            }
        } else {
            result.add(configCompTypeId);
        }
        return result;
    }

    public @Nullable List<ConfigurationComponentTypeId> getComponentTypeIdsByType(String type) {
        List<ConfigurationComponentTypeId> matchingComponents = this.confCompTypeIds.stream().filter(x -> x.getType().equals(type)).collect(Collectors.toList());
        if (matchingComponents.isEmpty()) {
            return null;
        }
        return matchingComponents;
    }

    public String getSdkComponentName(String sdkId) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(this.mcu.getMcu(), this.mcu.getSdkVersion());
        if (info == null) {
            return sdkId;
        }
        SdkComponentsTable supportedComps = derivatives.getSdkComponentsTable(info);
        if (supportedComps == null) {
            return sdkId;
        }
        for (SupportedSdkComponent comp : supportedComps.getSupportedSdkComponents()) {
            if (!comp.getId().equals(sdkId)) continue;
            return comp.getName();
        }
        return sdkId;
    }

    public String getSdkVersion() {
        return this.mcu.getSdkVersion();
    }

    public IMcuIdentification getMcu() {
        return this.mcu;
    }

    private static @Nullable ProcessorRestrictions loadProcessorRestrictions(ComponentInfo componentInfo) {
        File @Nullable [] files = componentInfo.getComponentDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(@Nullable File dir, @Nullable String name) {
                return name != null && name.endsWith(".restrictions");
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        File source = files[0];
        if (files.length > 1) {
            LOGGER.warning("There are more restriction files in the " + componentInfo.getName() + " component folder, using the " + source.getAbsolutePath());
        }
        return ProcessorRestrictions.loadFromFile(source);
    }
}

