/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.config.AStructuredSettingConfig;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IPresettable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.QuickSelectionHelper;
import com.nxp.swtools.periphs.model.config.SettingConfigFactory;
import com.nxp.swtools.periphs.model.config.SettingConfigHelper;
import com.nxp.swtools.periphs.model.data.IQuickSelectionGroup;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.StructSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StructConfig
extends AStructuredSettingConfig
implements IPresettable {
    protected final Map<String, ISettingConfig> settings = new HashMap<String, ISettingConfig>();
    @Nullable
    protected QuickSelection quickSelection = null;

    protected StructConfig(String id, String name, ISetting setting, ChildContext parentContext, Map<String, ISettingConfig> settings, IMcu mcu) {
        super(id, name, setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsStructSetting(), parentContext, mcu);
        this.settings.putAll(settings);
        ArrayList storageSettings = ((StoragePeriphsStructSetting)this.storageSetting).getSettings();
        settings.values().stream().filter(x -> x.isStorable()).forEach(x -> {
            boolean bl = storageSettings.add(x.getStorageSetting());
        });
    }

    protected StructConfig(String id, String name, ISetting setting, ChildContext parentContext, IMcu mcu) {
        super(id, name, setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsStructSetting(), parentContext, mcu);
        for (ISetting child : ((StructSetting)setting).getSettings().values()) {
            String childId = this.createChildId(child.getId());
            ISettingConfig settingConfig = SettingConfigFactory.createSettingConfig(childId, child.getId(), child, this.childContext, mcu);
            this.settings.put(child.getId(), settingConfig);
            if (!settingConfig.isStorable()) continue;
            this.getStorageSetting().getSettings().add(settingConfig.getStorageSetting());
        }
        QuickSelection defaultQS = this.getModelData().getDefaultQS();
        if (defaultQS != null) {
            this.setQuickSelection(defaultQS);
            this.applySelectedQuickSelection();
        }
    }

    private void updateStorageSettings() {
        ArrayList storages = new ArrayList();
        this.getChildren().forEach(sc -> {
            boolean bl = storages.add(sc.getStorageSetting());
        });
        this.getStorageSetting().setSettings(storages);
    }

    @Override
    public void applyOther(ISettingConfig config) {
        if (!(config instanceof StructConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), StructConfig.class.getName()));
        }
        StructConfig struct = (StructConfig)config;
        Iterator<Map.Entry<String, ISettingConfig>> theirIt = struct.settings.entrySet().iterator();
        if (this.settings.size() != struct.settings.size()) {
            throw new IllegalArgumentException(String.format("Bad setting size with id %1s", config.getId()));
        }
        Iterator<Map.Entry<String, ISettingConfig>> ourIt = this.settings.entrySet().iterator();
        while (ourIt.hasNext() && theirIt.hasNext()) {
            ISettingConfig value = theirIt.next().getValue();
            assert (value != null);
            ourIt.next().getValue().applyOther(value);
        }
        QuickSelection structQuickSelection = struct.getQuickSelection();
        QuickSelection quickSelectionToSet = structQuickSelection == null ? null : this.getModelData().getQuickSelection(structQuickSelection.getId());
        this.setQuickSelection(quickSelectionToSet);
    }

    @Override
    public void applyQuickSelection(@Nullable QuickSelection quickSelectionLoc, IChild relativeTo) {
        if (!this.applyQuickSelectionFromResource(quickSelectionLoc, relativeTo)) {
            StructSetting structSetting = this.getModelData();
            if (structSetting.hasQuickSelections()) {
                QuickSetting quickSetting = QuickSelectionHelper.getQuickSelection(quickSelectionLoc, this, relativeTo);
                if (quickSetting != null) {
                    this.setQuickSelection(structSetting.getQuickSelection(UtilsText.safeString((String)quickSetting.getValue())));
                } else {
                    this.setQuickSelection(QuickSelectionHelper.getDefaultQuickSelection(this));
                }
                if (SWToolsProperties.isVerificationOn() && quickSelectionLoc != null) {
                    String message = "The quick setting %s cannot be applied as the struct setting %s contains nested quick selections";
                    String quickSelectionId = String.valueOf(QuickSelectionHelper.getQuickSelectionId(this, relativeTo)) + ".";
                    quickSelectionLoc.getSettings().stream().filter(qs -> qs.getId().startsWith(quickSelectionId)).forEach(qs -> LOGGER.warning(String.format(message, qs.getId(), this.getId())));
                }
            }
            QuickSelection quickSelectionToApply = structSetting.hasQuickSelections() ? this.quickSelection : quickSelectionLoc;
            IChild relativeToToApply = structSetting.hasQuickSelections() ? this : relativeTo;
            this.getChildren().forEach(x -> x.applyQuickSelection(quickSelectionToApply, relativeToToApply));
        }
    }

    @Override
    public void applySelectedQuickSelection() {
        if (this.quickSelection != null) {
            this.getChildren().forEach(x -> x.deInitialize());
            this.getChildren().forEach(x -> x.applyQuickSelection(this.quickSelection, this));
        }
        this.getChildren().forEach(x -> x.initValue());
    }

    protected StructConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsStructSetting storageSetting, IMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsStructuredSetting)storageSetting, parentContext, mcu);
        HashMap<K, @Nullable V> storageSettings = new HashMap();
        storageSetting.getSettings().forEach(x -> {
            AStoragePeriphsSetting aStoragePeriphsSetting = storageSettings.put(x.getName(), x);
        });
        for (ISetting child : ((StructSetting)setting).getSettings().values()) {
            String settingName = child.getId();
            AStoragePeriphsSetting storageChildSetting = (AStoragePeriphsSetting)storageSettings.get(settingName);
            storageSettings.remove(settingName);
            String childId = this.createChildId(settingName);
            ISettingConfig settingConfig = storageChildSetting != null ? SettingConfigFactory.createSettingConfig(childId, child, this.childContext, storageChildSetting, mcu) : SettingConfigFactory.createSettingConfig(childId, settingName, child, this.childContext, mcu);
            this.settings.put(settingName, settingConfig);
        }
        if (!storageSettings.isEmpty()) {
            LOGGER.warning(String.format("The following settings: '%s' of the struct setting with id: '%s' could not be restored", storageSettings.keySet(), setting.getId()));
        }
        this.updateStorageSettings();
        String storageQuickSelection = storageSetting.getQuickSelection();
        if (storageQuickSelection != null) {
            this.setQuickSelection(this.getModelData().getQuickSelection(storageQuickSelection));
        }
    }

    public StoragePeriphsStructSetting getStorageSetting() {
        return (StoragePeriphsStructSetting)this.storageSetting;
    }

    @Override
    public void setQuickSelection(@Nullable QuickSelection quickSelection) {
        this.quickSelection = quickSelection;
        this.getStorageSetting().setQuickSelection(quickSelection != null ? quickSelection.getId() : null);
    }

    @Override
    public @Nullable QuickSelection getQuickSelection() {
        return this.quickSelection;
    }

    @Override
    public StructConfig getValue() {
        return this;
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        return this.settings.get(childName);
    }

    public Map<String, ISettingConfig> getSettings() {
        return CollectionsUtils.unmodifiableMap(this.settings);
    }

    @Override
    public @NonNull StructSetting getModelData() {
        return (StructSetting)super.getModelData();
    }

    public List<ISettingConfig> getChildren() {
        return SettingConfigHelper.getConfigsOf(this.getModelData().getSettings(), this.settings);
    }

    @Override
    public @NonNull String getTypeName() {
        return "struct";
    }

    @Override
    public IQuickSelectionGroup getQuickSelectionGroup() {
        return this.getModelData();
    }

    @Override
    public void setDefaultValue() {
        for (ISettingConfig child : this.getChildren()) {
            child.setDefaultValue();
        }
    }
}

