/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.ArrayConfig;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.ScalarConfig;
import com.nxp.swtools.periphs.model.config.SetConfig;
import com.nxp.swtools.periphs.model.config.StructConfig;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.ArraySetting;
import com.nxp.swtools.periphs.model.data.setting.EnumSetting;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.ReferenceSetting;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import com.nxp.swtools.periphs.model.data.setting.StructSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsStructSetting;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingConfigFactory {
    private static final Logger LOGGER = LogManager.getLogger(SettingConfigFactory.class);

    public static ISettingConfig createSettingConfig(String id, String name, ISetting setting, ChildContext parentContext, IMcu mcu) {
        if (setting instanceof ReferenceSetting) {
            throw new IllegalArgumentException("Tried to create config (component item) from unresolved reference with id: '" + setting.getId() + "' setting.");
        }
        ASettingConfig settingConfig = null;
        settingConfig = setting instanceof StructSetting ? new StructConfig(id, name, setting, parentContext, mcu) : (setting instanceof ArraySetting ? new ArrayConfig(id, name, setting, parentContext, mcu) : (setting instanceof SetSetting && !(setting instanceof EnumSetting) ? new SetConfig(id, name, setting, parentContext, mcu) : new ScalarConfig(id, name, setting, parentContext, mcu)));
        return settingConfig;
    }

    public static ISettingConfig createSettingConfig(String id, ISetting setting, ChildContext parentContext, AStoragePeriphsSetting storageSetting, IMcu mcu) {
        if (setting instanceof ReferenceSetting) {
            throw new IllegalArgumentException("Invalid " + ISetting.class.getName() + " class: " + setting.getClass().getName());
        }
        ASettingConfig settingConfig = null;
        boolean isDifferentType = false;
        if (setting instanceof StructSetting) {
            if (storageSetting instanceof StoragePeriphsStructSetting) {
                settingConfig = new StructConfig(id, setting, parentContext, (StoragePeriphsStructSetting)storageSetting, mcu);
            } else {
                isDifferentType = true;
                settingConfig = new StructConfig(id, storageSetting.getName(), setting, parentContext, mcu);
            }
        } else if (setting instanceof ArraySetting) {
            if (storageSetting instanceof StoragePeriphsArraySetting) {
                settingConfig = new ArrayConfig(id, setting, parentContext, (StoragePeriphsArraySetting)storageSetting, mcu);
            } else {
                isDifferentType = true;
                settingConfig = new ArrayConfig(id, storageSetting.getName(), setting, parentContext, mcu);
            }
        } else if (setting instanceof SetSetting && !(setting instanceof EnumSetting)) {
            if (storageSetting instanceof StoragePeriphsSetSetting) {
                settingConfig = new SetConfig(id, setting, parentContext, (StoragePeriphsSetSetting)storageSetting, mcu);
            } else {
                isDifferentType = true;
                settingConfig = new SetConfig(id, storageSetting.getName(), setting, parentContext, mcu);
            }
        } else if (storageSetting instanceof StoragePeriphsScalarSetting) {
            settingConfig = new ScalarConfig(id, setting, parentContext, (StoragePeriphsScalarSetting)storageSetting, mcu);
        } else {
            isDifferentType = true;
            settingConfig = new ScalarConfig(id, storageSetting.getName(), setting, parentContext, mcu);
        }
        if (isDifferentType) {
            String message = new String("Trying to load setting \"{0}\" of type \"{1}\", but current type of the setting is \"{2}\".");
            LOGGER.log(Level.SEVERE, MessageFormat.format(message, storageSetting.getName(), storageSetting.getClass().getSimpleName(), setting.getClass().getSimpleName()));
        }
        return settingConfig;
    }
}

