/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.QuickSelectionHelper;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import com.nxp.swtools.periphs.model.data.SettingUtils;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.IBaseModel;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetConfig
extends ASettingConfig
implements IChildProvidable {
    private final Map<String, SetPresence> values = new HashMap<String, SetPresence>();

    protected SetConfig(String id, String name, ISetting setting, ChildContext parentContext, IMcu mcu) {
        super(id, name, setting, (AStoragePeriphsSetting)new StoragePeriphsSetSetting(), parentContext, mcu);
        for (SetSetting.Item item : this.getModelData().getItems()) {
            this.values.put(item.getId(), new SetPresence(item, false));
        }
        this.updateStorage();
    }

    protected SetConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsSetSetting storageSetting, IMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsSetting)storageSetting, parentContext, mcu);
        this.childContext.setCurrent(this);
        for (SetSetting.Item item : this.getModelData().getItems()) {
            boolean itemValue = storageSetting.getSelected().contains(item.getId());
            this.values.put(item.getId(), new SetPresence(item, itemValue));
        }
    }

    void updateStorage() {
        this.storageSetting.setName(this.setting.getId());
        this.getStorageSetting().getSelected().clear();
        for (SetPresence itemPresence : this.getChildren()) {
            if (!itemPresence.getBoolValue()) continue;
            this.getStorageSetting().getSelected().add(itemPresence.getItem().getId());
        }
    }

    @Override
    public void applyOther(ISettingConfig config) {
        if (!(config instanceof SetConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), SetConfig.class.getName()));
        }
        SetConfig set = (SetConfig)config;
        for (SetSetting.Item item : this.getModelData().getItems()) {
            SetPresence itemConfig = (SetPresence)set.getChildById(item.getId());
            boolean itemValue = itemConfig == null ? false : itemConfig.getBoolValue();
            SetPresence setPresence = this.values.get(item.getId());
            if (setPresence == null) {
                LOGGER.severe(String.format("SetPresence of item: %1s of setting: %2s does not exist", item.getId(), this.setting.getId()));
                continue;
            }
            setPresence.setValue(itemValue);
        }
        this.updateStorage();
    }

    @Override
    public void applyQuickSelection(@Nullable QuickSelection quickSelection, IChild relativeTo) {
        if (!this.applyQuickSelectionFromResource(quickSelection, relativeTo)) {
            String quickSelId = QuickSelectionHelper.getQuickSelectionId(this, relativeTo);
            for (SetSetting.Item item : this.getModelData().getItems()) {
                String itemQuickSelId = SettingUtils.buildId(quickSelId, item.getId());
                QuickSetting setToUse = quickSelection == null ? null : quickSelection.getSetting(itemQuickSelId);
                String itemQuickSel = setToUse == null ? null : setToUse.getValue();
                boolean itemValue = itemQuickSel == null ? false : Boolean.parseBoolean(itemQuickSel);
                SetPresence setPresence = this.values.get(item.getId());
                if (setPresence == null) {
                    LOGGER.severe(String.format("SetPresence of item: %1s of setting: %2s does not exist", item.getId(), this.setting.getId()));
                    continue;
                }
                setPresence.setValue(itemValue);
            }
            this.updateStorage();
        }
    }

    public StoragePeriphsSetSetting getStorageSetting() {
        return (StoragePeriphsSetSetting)this.storageSetting;
    }

    @Override
    public @NonNull SetSetting getModelData() {
        return (SetSetting)super.getModelData();
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public @Nullable IChild getChildById(String childId) {
        return ChildProviderHelper.getChildRelative(this, childId);
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        return this.values.get(childName);
    }

    public List<SetPresence> getChildren() {
        ArrayList<SetPresence> result = new ArrayList<SetPresence>();
        for (SetSetting.Item item : this.getModelData().getItems()) {
            SetPresence settingConfig = this.values.get(item.getId());
            if (settingConfig == null) {
                ComponentConfig cc = this.childContext.getComponentConfig();
                String componentId = cc != null ? cc.getId() : "";
                LOGGER.severe(MessageFormat.format("Configuration not found for an item with ID {0} referenced in set setting with ID {1} of component with ID {0}", item.getId(), this.id, componentId));
                continue;
            }
            result.add(settingConfig);
        }
        return result;
    }

    @Override
    public @NonNull String getTypeName() {
        return "set";
    }

    @Override
    public void initValue() {
    }

    @Override
    public void updateStorageAvailability() {
        this.getStorageSetting().getSelected().clear();
        for (SetPresence itemPresence : this.getChildren()) {
            if (!itemPresence.value || !itemPresence.isAvailable()) continue;
            this.getStorageSetting().getSelected().add(itemPresence.item.getId());
        }
    }

    @Override
    public void setDefaultValue() {
        for (SetPresence child : this.getChildren()) {
            child.setValue(false);
        }
    }

    @Override
    public void deInitialize() {
    }

    public class SetPresence
    implements IChild {
        final SetSetting.Item item;
        boolean value;
        private final ExpressionContext exprContext;
        private final ChildContext itemContext;

        protected SetPresence(SetSetting.Item item, boolean value) {
            this.item = item;
            this.value = value;
            this.itemContext = SetConfig.this.childContext.createForChild(this);
            this.exprContext = new ExpressionContext(this.itemContext, SetConfig.this.mcu);
        }

        public SetSetting.Item getItem() {
            return this.item;
        }

        public void setValue(boolean value) {
            this.value = value;
            SetConfig.this.updateStorage();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public boolean getBoolValue() {
            return this.value;
        }

        @Override
        public boolean isAvailable() {
            return SetConfig.this.isAvailable() && this.item.isAvailable(this.exprContext);
        }

        @Override
        public boolean isEnabled() {
            return SetConfig.this.isEnabled() && this.item.isEnabled(this.exprContext);
        }

        @Override
        public String getId() {
            return SettingUtils.buildId(SetConfig.this.id, this.item.getId());
        }

        @Override
        public String getName() {
            return this.item.getId();
        }

        @Override
        public String getUiName() {
            return this.item.getUIName(SetConfig.this.expressionContext);
        }

        public @Nullable String getDescription() {
            Description description = this.item.getDescription();
            if (description != null) {
                return description.getDescription(SetConfig.this.expressionContext);
            }
            return null;
        }

        public @NonNull String getValueName() {
            return Boolean.toString(this.value);
        }

        @Override
        public ChildContext getChildContext() {
            return this.itemContext;
        }

        @Override
        public IContext getExpressionContext() {
            return this.exprContext;
        }

        @Override
        public @Nullable String getProblems(Level level) {
            return null;
        }

        @Override
        public void updateStorageAvailability() {
        }

        @Override
        public @NonNull IBaseModel getModelData() {
            return this.item;
        }

        @Override
        public boolean isOptionSet(String option) {
            return this.item.isOptionSet(option);
        }

        @Override
        public @Nullable Object getOptionValue(String option) {
            return this.item.getOptionValue(option, this.getExpressionContext());
        }
    }
}

