/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.BigRationalRange;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.ScalarConfig;
import com.nxp.swtools.periphs.model.data.setting.AMinMaxSetting;
import com.nxp.swtools.periphs.model.data.setting.IntegerSetting;
import java.math.BigInteger;
import java.text.MessageFormat;

public class ScalarUtils {
    private static BigInteger UNSIGNED_MIN = BigInteger.ZERO;
    private static BigInteger INT8_T_MIN = BigInteger.valueOf(-128L);
    private static BigInteger INT8_T_MAX = BigInteger.valueOf(127L);
    private static BigInteger UINT8_T_MAX = BigInteger.valueOf(255L);
    private static BigInteger INT16_T_MIN = BigInteger.valueOf(-32768L);
    private static BigInteger INT16_T_MAX = BigInteger.valueOf(32767L);
    private static BigInteger UINT16_T_MAX = BigInteger.valueOf(65535L);
    private static BigInteger INT32_T_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static BigInteger INT32_T_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static BigInteger UINT32_T_MAX = BigInteger.valueOf(0xFFFFFFFFL);
    private static BigInteger INT64_T_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigInteger INT64_T_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static BigInteger UINT64_T_MAX = INT64_T_MAX.add(INT64_T_MIN.abs());
    public static final String BINARY_PREFIX = "0b";
    public static final String HEXADECIMAL_PREFIX = "0x";
    public static final String OCTAL_PREFIX = "0";

    public static boolean isInRange(ASettingConfig config, String number) {
        BigRational parsedNumber;
        try {
            parsedNumber = ScalarUtils.parseNumber(number);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return ScalarUtils.isInRange(config, parsedNumber);
    }

    public static boolean isInRange(ASettingConfig config, int number) {
        BigRational parsedNumber = new BigRational(number);
        return ScalarUtils.isInRange(config, parsedNumber);
    }

    public static boolean isInRange(ASettingConfig config, BigRational number) {
        BigRationalRange range = ScalarUtils.getRange(config);
        if (range != null) {
            return range.contains((Comparable)number);
        }
        return true;
    }

    public static boolean isBeforeRange(ASettingConfig config, String number) {
        BigRational parsedNumber;
        try {
            parsedNumber = ScalarUtils.parseNumber(number);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return ScalarUtils.isBeforeRange(config, parsedNumber);
    }

    public static boolean isBeforeRange(ASettingConfig config, int number) {
        BigRational parsedNumber = new BigRational(number);
        return ScalarUtils.isBeforeRange(config, parsedNumber);
    }

    public static boolean isBeforeRange(ASettingConfig config, BigRational number) {
        BigRationalRange range = ScalarUtils.getRange(config);
        if (range != null) {
            return range.isBeforeRange((Comparable)number);
        }
        return false;
    }

    public static boolean isAfterRange(ASettingConfig config, String number) {
        BigRational parsedNumber;
        try {
            parsedNumber = ScalarUtils.parseNumber(number);
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
        return ScalarUtils.isAfterRange(config, parsedNumber);
    }

    public static boolean isAfterRange(ASettingConfig config, int number) {
        BigRational parsedNumber = new BigRational(number);
        return ScalarUtils.isAfterRange(config, parsedNumber);
    }

    public static boolean isAfterRange(ASettingConfig config, BigRational number) {
        BigRationalRange range = ScalarUtils.getRange(config);
        if (range != null) {
            return range.isAfterRange((Comparable)number);
        }
        return false;
    }

    public static @Nullable BigRationalRange getRange(ASettingConfig scalarConfig) {
        BigRationalRange minMaxRange = ScalarUtils.getConstraintsRange(scalarConfig);
        BigRationalRange typeRange = ScalarUtils.getTypeRange(scalarConfig);
        return BigRationalRange.intersection((BigRationalRange)minMaxRange, (BigRationalRange)typeRange);
    }

    public static @Nullable BigRationalRange getConstraintsRange(ASettingConfig config) {
        if (config.getModelData() instanceof AMinMaxSetting) {
            AMinMaxSetting minMaxSetting = (AMinMaxSetting)config.getModelData();
            BigRational minValue = minMaxSetting.getMinValue(config.getExpressionContext());
            BigRational maxValue = minMaxSetting.getMaxValue(config.getExpressionContext());
            return new BigRationalRange(minValue, maxValue);
        }
        return null;
    }

    public static boolean hasRangeConstraintDefined(ASettingConfig config) {
        String minValueString = null;
        String maxValueString = null;
        if (config.getModelData() instanceof AMinMaxSetting) {
            AMinMaxSetting minMaxSetting = (AMinMaxSetting)config.getModelData();
            minValueString = minMaxSetting.getMinValueString();
            maxValueString = minMaxSetting.getMaxValueString();
        }
        return minValueString != null || maxValueString != null;
    }

    private static @Nullable BigRationalRange getTypeRange(ASettingConfig config) {
        if (config instanceof ScalarConfig && ((ScalarConfig)config).getType() == ScalarConfig.Type.INTEGER) {
            IntegerSetting.IntegerType intType = ((IntegerSetting)config.getModelData()).getType();
            return ScalarUtils.getIntegerRange(intType);
        }
        return null;
    }

    private static BigRational parseNumber(String number) {
        try {
            return new BigRational(ScalarUtils.parseInteger(number));
        }
        catch (NumberFormatException numberFormatException) {
            return BigRational.parse((String)number);
        }
    }

    public static BigRationalRange getIntegerRange(IntegerSetting.IntegerType intType) {
        BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
        BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
        switch (intType) {
            case uint8_t: {
                min = UNSIGNED_MIN;
                max = UINT8_T_MAX;
                break;
            }
            case int8_t: {
                min = INT8_T_MIN;
                max = INT8_T_MAX;
                break;
            }
            case uint16_t: {
                min = UNSIGNED_MIN;
                max = UINT16_T_MAX;
                break;
            }
            case int16_t: {
                min = INT16_T_MIN;
                max = INT16_T_MAX;
                break;
            }
            case uint32_t: {
                min = UNSIGNED_MIN;
                max = UINT32_T_MAX;
                break;
            }
            case int32_t: {
                min = INT32_T_MIN;
                max = INT32_T_MAX;
                break;
            }
            case uint64_t: {
                min = UNSIGNED_MIN;
                max = UINT64_T_MAX;
                break;
            }
            case int64_t: {
                min = INT64_T_MIN;
                max = INT64_T_MAX;
                break;
            }
        }
        return new BigRationalRange(min, max);
    }

    public static int detectIntegerBase(String number) {
        if (number.regionMatches(true, 0, HEXADECIMAL_PREFIX, 0, HEXADECIMAL_PREFIX.length())) {
            return 16;
        }
        if (number.regionMatches(true, 0, BINARY_PREFIX, 0, BINARY_PREFIX.length())) {
            return 2;
        }
        if (number.length() > OCTAL_PREFIX.length() && number.regionMatches(true, 0, OCTAL_PREFIX, 0, OCTAL_PREFIX.length())) {
            return 8;
        }
        return 10;
    }

    public static BigInteger parseInteger(String number) {
        switch (ScalarUtils.detectIntegerBase(number)) {
            case 2: {
                return new BigInteger(number.substring(BINARY_PREFIX.length()), 2);
            }
            case 8: {
                return new BigInteger(number.substring(OCTAL_PREFIX.length()), 8);
            }
            case 16: {
                return new BigInteger(number.substring(HEXADECIMAL_PREFIX.length()), 16);
            }
        }
        return new BigInteger(number);
    }

    public static String getRangeError(ScalarConfig scalarConfig) {
        BigRationalRange range = ScalarUtils.getRange(scalarConfig);
        if (range != null) {
            BigRational min = (BigRational)range.getMin();
            BigRational max = (BigRational)range.getMax();
            if (min == null) {
                if (max == null) {
                    return "";
                }
                return MessageFormat.format(UtilsText.safeString((String)Messages.get().ScalarUtils_OutOfRange_MustBeLower), max.toBigInteger());
            }
            if (max == null) {
                return MessageFormat.format(UtilsText.safeString((String)Messages.get().ScalarUtils_OutOfRange_MustBeHigher), min.toBigInteger());
            }
            return MessageFormat.format(UtilsText.safeString((String)Messages.get().ScalarUtils_OutOfRange), min.toBigInteger(), max.toBigInteger());
        }
        return "";
    }
}

