/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.number.BigRationalRange;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.model.Messages;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.ArrayConfig;
import com.nxp.swtools.periphs.model.config.CacheHelper;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.config.QuickSelectionHelper;
import com.nxp.swtools.periphs.model.config.ScalarUtils;
import com.nxp.swtools.periphs.model.data.ConfigSet;
import com.nxp.swtools.periphs.model.data.Description;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.data.setting.BoolSetting;
import com.nxp.swtools.periphs.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.periphs.model.data.setting.EnumSetting;
import com.nxp.swtools.periphs.model.data.setting.FloatSetting;
import com.nxp.swtools.periphs.model.data.setting.ISetting;
import com.nxp.swtools.periphs.model.data.setting.InfoSetting;
import com.nxp.swtools.periphs.model.data.setting.IntegerSetting;
import com.nxp.swtools.periphs.model.data.setting.ItemDefaults;
import com.nxp.swtools.periphs.model.data.setting.SetSetting;
import com.nxp.swtools.periphs.model.data.setting.StringSetting;
import com.nxp.swtools.periphs.model.data.setting.VariableSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class ScalarConfig
extends ASettingConfig {
    private static final String VALUE_NOT_INITIALIZED = "Not initialized";
    private static final String TEXT_CUTOFF_MARK = String.valueOf(UtilsText.platformEOL) + "...";
    private static final int TEXT_CUTOFF_LINES = 10;
    private String value;
    private final Type type = this.detectType();
    @Nullable
    private SetSetting.CustomItem customItem = null;

    protected ScalarConfig(String id, String name, ISetting setting, ChildContext parentContext, IMcu mcu) {
        super(id, name, setting, (AStoragePeriphsSetting)new StoragePeriphsScalarSetting(), parentContext, mcu);
        DynamicEnumSetting.CustomValueSupport customValueSupport;
        if (setting instanceof DynamicEnumSetting && (customValueSupport = ((DynamicEnumSetting)setting).getCustomValueSupport()) != null) {
            this.customItem = new SetSetting.CustomItem("custom", "Custom...", null, customValueSupport.getDefaultValue(), new Description("Custom value", null), null, null);
        }
        if (SWToolsProperties.isVerificationOn()) {
            this.verify();
        }
        this.value = this.type == Type.VARIABLE || this.type == Type.INFO ? this.getDefaultValue() : VALUE_NOT_INITIALIZED;
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(this.value);
    }

    protected void verify() {
        boolean hasRangeConstraintDefined = ScalarUtils.hasRangeConstraintDefined(this);
        if (hasRangeConstraintDefined) {
            ComponentConfig componentConfig;
            ConfigSetConfig configSetConfig;
            boolean logWarning;
            boolean bl = logWarning = !QuickSelectionHelper.isConfigPresentInAllQuickSelections(this);
            if (logWarning) {
                String pathId = this.getName();
                IChildProvidable parent = this.getChildContext().getParent();
                while (parent != null) {
                    ArrayConfig array;
                    ItemDefaults itemDefaults;
                    if (parent instanceof ArrayConfig && (itemDefaults = (array = (ArrayConfig)parent).getModelData().getItemDefaults()) != null) {
                        ItemDefaults.SetDefault defaultsForId;
                        if (pathId.matches("\\d\\..*")) {
                            pathId = pathId.substring(pathId.indexOf(".") + 1);
                        }
                        if ((defaultsForId = itemDefaults.getDefault(pathId)) != null) {
                            logWarning = false;
                            break;
                        }
                    }
                    pathId = String.valueOf(parent.getName()) + "." + pathId;
                    parent = parent.getChildContext().getParent();
                }
            }
            if (logWarning) {
                LOGGER.warning(String.valueOf(this.getLogHeader()) + " has minimal or maximal value defined by expression and its value is not specified in all quick selections or item_defaults");
            }
            if ((configSetConfig = this.getChildContext().getConfigSetConfig()) != null && (componentConfig = this.getChildContext().getComponentConfig()) != null) {
                List<ConfigSet> configSets = componentConfig.getConfigCompTypeId().getConfigurationComponent().getConfigSets();
                for (ConfigSet configSet : configSets) {
                    ISetting foundSetting;
                    if (configSetConfig.getConfigSet().equals(configSet) || (foundSetting = configSet.find(new String[]{this.getName()})) == null) continue;
                    LOGGER.warning(String.valueOf(this.getLogHeader()) + " has conflicting ID. This id is already used in config set with id: " + configSet.getId());
                }
            }
        }
    }

    @Override
    public void applyOther(ISettingConfig config) {
        if (!(config instanceof ScalarConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), ScalarConfig.class.getName()));
        }
        ScalarConfig scalar = (ScalarConfig)config;
        this.setValue(scalar.value, false);
    }

    @Override
    public void applyQuickSelection(@Nullable QuickSelection quickSelection, IChild relativeTo) {
        QuickSetting setToUse;
        String valToUse;
        if (!this.applyQuickSelectionFromResource(quickSelection, relativeTo) && (valToUse = (setToUse = QuickSelectionHelper.getQuickSelection(quickSelection, this, relativeTo)) != null ? setToUse.getValue() : null) != null) {
            if (this.setting instanceof VariableSetting || this.setting instanceof InfoSetting) {
                LOGGER.severe("Trying to apply item defaults or quick selection on setting with id \"" + this.getId() + "\" that is of type \"" + this.setting.getClass().getSimpleName() + "\"");
            } else {
                this.setValue(valToUse, false);
            }
        }
    }

    private String getDefaultValue() {
        switch (this.type) {
            case INTEGER: 
            case FLOAT: {
                return this.getDefaultValueFromRange();
            }
            case ENUM: {
                SetSetting.Item item = null;
                try {
                    List<SetSetting.Item> items = this.getEnumItems();
                    item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(items.stream().filter(x -> x.isAvailable(this.expressionContext) && x.isEnabled(this.expressionContext)).findFirst());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Could not obtain default value of a: " + this.setting, ex);
                }
                if (item == null) {
                    return "";
                }
                if (item instanceof SetSetting.CustomItem) {
                    return SetSetting.CustomItem.getStorableFormat(item.getValue());
                }
                return item.getId();
            }
            case BOOL: {
                return UtilsText.safeString((String)Boolean.FALSE.toString());
            }
            case INFO: {
                return ((InfoSetting)this.setting).getValueExpression();
            }
            case VARIABLE: {
                return ((VariableSetting)this.setting).getValueExpression();
            }
        }
        return "";
    }

    private String getDefaultValueFromRange() {
        String result = "0";
        BigRationalRange range = null;
        try {
            if (!ScalarUtils.isInRange((ASettingConfig)this, result)) {
                range = ScalarUtils.getConstraintsRange(this);
                if (range != null) {
                    BigRational min = (BigRational)range.getMin();
                    BigRational max = (BigRational)range.getMax();
                    if (min != null) {
                        result = min.toExactDecimalString();
                    } else if (max != null) {
                        result = max.toExactDecimalString();
                    } else {
                        LOGGER.severe("0 is out of range even if there is no explicit restriction of min or max value");
                    }
                } else {
                    LOGGER.severe("0 is out of range even if there is no explicit restriction of min or max value");
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error obtaining default value from range for the setting: " + this.getId(), ex);
        }
        return result;
    }

    private Object parseValue(String valueToConvert) {
        switch (this.type) {
            case INTEGER: {
                return ScalarUtils.parseInteger(valueToConvert);
            }
            case BOOL: {
                return Boolean.valueOf(valueToConvert);
            }
            case INFO: 
            case VARIABLE: {
                try {
                    return Expression.create((String)valueToConvert).resolve(this.getExpressionContext()).getValue();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Error resolving current value of info/variable setting: " + this.getId(), ex);
                    return 0L;
                }
            }
            case FLOAT: {
                return BigRational.parse((String)valueToConvert);
            }
            case ENUM: {
                DynamicEnumSetting dynamicEnumSetting;
                DynamicEnumSetting.CustomValueSupport customValueSupport;
                if (this.setting instanceof DynamicEnumSetting && (customValueSupport = (dynamicEnumSetting = (DynamicEnumSetting)this.setting).getCustomValueSupport()) != null && valueToConvert.startsWith("custom:")) {
                    this.validateCustomValue(valueToConvert, customValueSupport);
                }
                return valueToConvert;
            }
        }
        return valueToConvert;
    }

    public void validateCustomValue(String valueToValidate, DynamicEnumSetting.CustomValueSupport customValueSupport) throws IllegalArgumentException {
        String substring = UtilsText.safeString((String)valueToValidate.substring("custom:".length()));
        Expression validationExpression = customValueSupport.getValidationExpression();
        if (validationExpression != null) {
            IFunction functionReference;
            IValue resolvedExpression = validationExpression.resolve(this.getExpressionContext());
            try {
                functionReference = resolvedExpression.getFunctionReference();
            }
            catch (ExpressionException e) {
                String description = "Lambda function is required in validation expression of custom value";
                LOGGER.severe(description);
                throw e;
            }
            boolean result = functionReference.invokeOn(this.getExpressionContext(), new Object[]{substring}).getBoolean();
            if (!result) {
                throw new IllegalArgumentException("Value: " + substring + " did not pass validation");
            }
        }
    }

    public boolean isParseable(String valueToParse) {
        try {
            if (this.type != Type.INFO && this.type != Type.VARIABLE) {
                this.parseValue(valueToParse);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected ScalarConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsScalarSetting storageSetting, IMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsSetting)storageSetting, parentContext, mcu);
        DynamicEnumSetting dynamicEnumSetting;
        DynamicEnumSetting.CustomValueSupport customValueSupport;
        String temporaryValue = storageSetting.getValue();
        if (setting instanceof DynamicEnumSetting && (customValueSupport = (dynamicEnumSetting = (DynamicEnumSetting)setting).getCustomValueSupport()) != null) {
            SetSetting.CustomItem customItemLoc = new SetSetting.CustomItem("custom", "Custom...", null, customValueSupport.getDefaultValue(), new Description("Custom value", null), null, null);
            if (temporaryValue.startsWith("custom:")) {
                customItemLoc.setValue(SetSetting.CustomItem.parseValueFromStorableString(temporaryValue));
            }
            this.customItem = customItemLoc;
        }
        this.value = temporaryValue;
    }

    @Override
    public void initValue() {
        if (this.value == VALUE_NOT_INITIALIZED) {
            this.setDefaultValue();
        }
    }

    @Override
    public void setDefaultValue() {
        this.setValue(this.getDefaultValue());
    }

    public  @Nullable SetSetting.CustomItem getCustomItem() {
        return this.customItem;
    }

    private Type detectType() {
        if (this.setting instanceof IntegerSetting) {
            return Type.INTEGER;
        }
        if (this.setting instanceof EnumSetting || this.setting instanceof DynamicEnumSetting) {
            return Type.ENUM;
        }
        if (this.setting instanceof BoolSetting) {
            return Type.BOOL;
        }
        if (this.setting instanceof FloatSetting) {
            return Type.FLOAT;
        }
        if (this.setting instanceof StringSetting) {
            return Type.STRING;
        }
        if (this.setting instanceof InfoSetting) {
            return Type.INFO;
        }
        if (this.setting instanceof VariableSetting) {
            return Type.VARIABLE;
        }
        return Type.UNKNOWN;
    }

    public boolean setValue(String value) {
        return this.setValue(value, true);
    }

    public boolean setValue(String value, boolean check) {
        if (this.value != VALUE_NOT_INITIALIZED && this.getType() == Type.VARIABLE) {
            LOGGER.severe("Value of a variable setting should not be changed");
        }
        String prevValue = this.value;
        String prevCustomVal = null;
        this.value = value;
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(value);
        SetSetting.CustomItem customItemLoc = this.customItem;
        if (customItemLoc != null && value.startsWith("custom:")) {
            prevCustomVal = customItemLoc.getValue();
            customItemLoc.setValue(SetSetting.CustomItem.parseValueFromStorableString(value));
        }
        if (check) {
            try {
                this.getValue();
                return true;
            }
            catch (Exception ex) {
                LOGGER.warning("Error in validity check of new value: '" + value + "' for setting: '" + this.getId() + "'. Error message: " + ex.getMessage());
                this.value = prevValue;
                ((StoragePeriphsScalarSetting)this.storageSetting).setValue(prevValue);
                if (customItemLoc != null && prevCustomVal != null) {
                    customItemLoc.setValue(prevCustomVal);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getValue() {
        if (this.value == VALUE_NOT_INITIALIZED) {
            this.initValue();
        }
        Object parsedValue = this.parseValue(this.value);
        if (this.type == Type.INTEGER) {
            IntegerSetting integerSetting = (IntegerSetting)this.getModelData();
            if (integerSetting.getType() == IntegerSetting.IntegerType.uint64_t) {
                return parsedValue;
            }
            return ((BigInteger)parsedValue).longValue();
        }
        return parsedValue;
    }

    public String getStringValue() {
        if (this.value == VALUE_NOT_INITIALIZED) {
            this.initValue();
        }
        return this.value;
    }

    public @NonNull String getValueName() {
        String text = UtilsText.safeToString((Object)this.getValue());
        return this.getType() == Type.INFO && this.isOptionSet("UI_INFO_COPY_BUTTON") ? UtilsText.safeString((String)ScalarConfig.cutOff(text)) : text;
    }

    private  @Nullable SetSetting.Item getSelectedEnumItem() {
        if (this.getType() == Type.ENUM) {
            return (SetSetting.Item)CollectionsUtils.nullableOptionalGet(this.getEnumItems().stream().filter(x -> x.getId().equals(this.value)).findFirst());
        }
        return null;
    }

    public @Nullable String getEnumItemUiName() {
        SetSetting.Item item;
        if (this.getType() == Type.ENUM && (item = this.getSelectedEnumItem()) != null) {
            return item.getUIName(this.expressionContext);
        }
        return null;
    }

    @Override
    public @NonNull String getTypeName() {
        return UtilsText.safeString((String)this.type.name().toLowerCase());
    }

    public @Nullable String getValueDescription() {
        SetSetting.Item item;
        if (this.getType() == Type.ENUM && (item = this.getSelectedEnumItem()) != null) {
            String itemDescription;
            Description description = item.getDescription();
            if (description != null && !UtilsText.isEmpty((String)(itemDescription = description.getDescription(this.expressionContext)))) {
                return String.valueOf(item.getUIName(this.expressionContext)) + "\r\n" + itemDescription;
            }
            return item.getUIName(this.expressionContext);
        }
        String text = this.getValue().toString();
        return this.getType() == Type.INFO && this.isOptionSet("UI_INFO_COPY_BUTTON") ? ScalarConfig.cutOff(text) : text;
    }

    private static @Nullable String cutOff(@Nullable String text) {
        if (text == null) {
            return text;
        }
        int pos = UtilsText.ordinalIndexOf((String)text, (String)UtilsText.platformEOL, (int)10);
        return pos > 0 ? String.valueOf(text.substring(0, pos)) + TEXT_CUTOFF_MARK : text;
    }

    @Override
    public AStoragePeriphsSetting getStorageSetting() {
        return this.storageSetting;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isStorable() {
        return this.type != Type.INFO && this.type != Type.VARIABLE;
    }

    @Override
    public @Nullable String getValueError() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value*error", () -> {
            StringSetting stringSetting;
            Expression validationExpression;
            if (!this.isParseable(this.value)) {
                return Messages.get().ScalarConfig_ValueCannotBeParsed;
            }
            if (this.type == Type.ENUM) {
                DynamicEnumSetting dynamicEnumSetting;
                String temporaryId = this.value;
                if (this.setting instanceof DynamicEnumSetting && (dynamicEnumSetting = (DynamicEnumSetting)this.setting).getCustomValueSupport() != null && this.value.startsWith("custom:")) {
                    temporaryId = "custom";
                }
                String itemId = temporaryId;
                SetSetting.Item item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(this.getEnumItems().stream().filter(x -> x.getId().equals(itemId)).findFirst());
                if (item == null || !item.isAvailable(this.expressionContext)) {
                    return Messages.get().ScalarConfig_ValueIsNotAvailable;
                }
            } else if (this.type == Type.INTEGER) {
                if (!ScalarUtils.isInRange((ASettingConfig)this, this.value)) {
                    return ScalarUtils.getRangeError(this);
                }
            } else if (this.type == Type.STRING && (validationExpression = (stringSetting = (StringSetting)this.setting).getValidationExpression()) != null) {
                try {
                    IFunction functionReference;
                    try {
                        functionReference = validationExpression.resolve(this.getExpressionContext()).getFunctionReference();
                    }
                    catch (ExpressionException e) {
                        LOGGER.severe("Lambda function is required in validation expression");
                        throw e;
                    }
                    Object result = functionReference.invokeOn(this.getExpressionContext(), new Object[]{this.value}).getValue();
                    if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                        return Messages.get().ScalarConfig_ValueCannotBeParsed;
                    }
                }
                catch (Exception exception) {
                    return Messages.get().ScalarConfig_ValueCannotBeParsed;
                }
            }
            return null;
        });
    }

    public boolean isCustomValueValid(String customValue) {
        Expression validationExpression;
        DynamicEnumSetting.CustomValueSupport customValueSupport = this.getCustomValueSupport();
        if (customValueSupport != null && (validationExpression = customValueSupport.getValidationExpression()) != null) {
            try {
                IFunction functionReference;
                try {
                    functionReference = validationExpression.resolve(this.getExpressionContext()).getFunctionReference();
                }
                catch (ExpressionException e) {
                    String description = "Lambda function is required in validation expression of custom value";
                    LOGGER.severe(description);
                    throw e;
                }
                return functionReference.invokeOn(this.getExpressionContext(), new Object[]{customValue}).getBoolean();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public @Nullable DynamicEnumSetting.CustomValueSupport getCustomValueSupport() {
        if (this.setting instanceof DynamicEnumSetting) {
            return ((DynamicEnumSetting)this.setting).getCustomValueSupport();
        }
        return null;
    }

    public boolean isFeatureComponentAddDefined() {
        if (this.setting instanceof DynamicEnumSetting) {
            return this.setting.isOptionSet("FEATURE_COMPONENT_ADD");
        }
        return false;
    }

    public @Nullable List<String> getFeatureComponentAddValues() {
        Object optionValue;
        if (this.isFeatureComponentAddDefined() && (optionValue = this.setting.getOptionValue("FEATURE_COMPONENT_ADD", this.expressionContext)) instanceof String) {
            String components = (String)optionValue;
            String[] rawValues = components.split(",");
            return (List)Arrays.stream(rawValues).map(v -> v.trim()).collect(CollectorsUtils.toList());
        }
        return null;
    }

    public @Nullable Expression getStringValidationExpr() {
        if (this.setting instanceof StringSetting) {
            return ((StringSetting)this.setting).getValidationExpression();
        }
        return null;
    }

    public List<SetSetting.Item> getEnumItems() {
        if (this.setting instanceof EnumSetting) {
            return ((EnumSetting)this.setting).getItems();
        }
        if (this.setting instanceof DynamicEnumSetting) {
            return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*items", () -> {
                DynamicEnumSetting dynamicEnumSetting = (DynamicEnumSetting)this.setting;
                List<SetSetting.Item> enumItems = dynamicEnumSetting.createItems(this.getExpressionContext());
                if (SWToolsProperties.isVerificationOn() && this.isOptionSet("FEATURE_PERIPHERAL_SELECT")) {
                    ConfigSetConfig configSet = this.getChildContext().getConfigSetConfig();
                    if (configSet != null && "#global".equals(configSet.getName())) {
                        LOGGER.severe(String.format("Dynamic enum: %s - The feature %s cannot be used in global config set", this.getId(), "FEATURE_PERIPHERAL_SELECT"));
                    }
                    List<String> mcuPeripherals = this.mcu.getPeripherals();
                    enumItems.forEach(ei -> {
                        if (!mcuPeripherals.contains(ei.getId()) && ei.isAvailable(this.getExpressionContext())) {
                            LOGGER.severe(String.format("Dynamic enum: %s - The peripheral with id %s is not available on the %s MCU", this.getId(), ei.getId(), this.mcu.getPackage()));
                        }
                    });
                }
                if (this.customItem != null) {
                    enumItems.add(this.customItem);
                }
                return enumItems;
            });
        }
        throw new IllegalStateException("Cannot get enum items from setting of type " + (Object)((Object)this.getType()));
    }

    @Override
    public void updateStorageAvailability() {
    }

    @Override
    public void deInitialize() {
        this.value = VALUE_NOT_INITIALIZED;
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(this.value);
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        BOOL,
        ENUM,
        STRING,
        INFO,
        VARIABLE,
        UNKNOWN;

    }
}

