/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.model.config.ASettingConfig;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.config.IPresettable;
import com.nxp.swtools.periphs.model.config.ISettingConfig;
import com.nxp.swtools.periphs.model.data.IQuickSelectionGroup;
import com.nxp.swtools.periphs.model.data.QuickSelection;
import com.nxp.swtools.periphs.model.data.QuickSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class QuickSelectionHelper {
    private static final Logger LOGGER = LogManager.getLogger(QuickSelectionHelper.class);

    public static @Nullable QuickSetting getQuickSelection(@Nullable QuickSelection quickSelection, ISettingConfig setting, IChild relativeTo) {
        return quickSelection == null ? null : quickSelection.getSetting(QuickSelectionHelper.getQuickSelectionId(setting, relativeTo));
    }

    public static String getQuickSelectionId(ISettingConfig setting, IChild relativeTo) {
        String relativePrefix;
        String relativeId = relativeTo.getId();
        String settingId = setting.getId();
        if (settingId.startsWith(relativePrefix = String.valueOf(relativeId) + ".")) {
            return settingId.substring(relativePrefix.length());
        }
        if (settingId.equals(relativeId)) {
            return "";
        }
        String message = "Cannot create relative setting ID for quick selection, as the setting %s is not an ancestor of the setting %s";
        LOGGER.warning(String.format(message, settingId, relativeTo.getId()));
        return settingId;
    }

    public static @Nullable QuickSelection getDefaultQuickSelection(IPresettable presettable) {
        IQuickSelectionGroup quickSelectionGroup = presettable.getQuickSelectionGroup();
        QuickSelection defaultQS = quickSelectionGroup.getDefaultQS();
        if (defaultQS != null && defaultQS.isAvailable(presettable.getExpressionContext())) {
            return defaultQS;
        }
        LOGGER.warning("Default quick selection is not available in current state");
        QuickSelection firstQS = (QuickSelection)CollectionsUtils.nullableOptionalGet(QuickSelectionHelper.getAvailableQuickSelections(presettable).stream().findFirst());
        return firstQS;
    }

    public static List<QuickSelection> getAvailableQuickSelections(IPresettable presettable) {
        return CollectionsUtils.safeList((List)((List)presettable.getQuickSelectionGroup().getQuickSelections().stream().filter(qs -> qs.isAvailable(presettable.getExpressionContext())).collect(CollectorsUtils.toList())));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CollectionsUtils.Pair<IChildProvidable, List<QuickSelection>> getParentAndQuickSelectionsOfConfig(ASettingConfig config) {
        IChildProvidable parent = config.getChildContext().getParent();
        while (parent != null) {
            List<QuickSelection> quickSelections;
            if (parent instanceof IPresettable && !(quickSelections = QuickSelectionHelper.getAvailableQuickSelections((IPresettable)((Object)parent))).isEmpty()) {
                return new CollectionsUtils.Pair((Object)parent, quickSelections);
            }
            parent = parent.getChildContext().getParent();
        }
        return null;
    }

    public static List<QuickSelection> getQuickSelectionsForConfig(ASettingConfig config) {
        CollectionsUtils.Pair<IChildProvidable, List<QuickSelection>> pair = QuickSelectionHelper.getParentAndQuickSelectionsOfConfig(config);
        if (pair != null) {
            IChildProvidable parent = (IChildProvidable)pair.getFirst();
            List quickSelections = (List)pair.getSecond();
            return (List)quickSelections.stream().filter(selection -> QuickSelectionHelper.getQuickSelection(selection, config, parent) != null).collect(CollectorsUtils.toList());
        }
        return new ArrayList<QuickSelection>();
    }

    public static boolean isConfigPresentInAllQuickSelections(ASettingConfig config) {
        CollectionsUtils.Pair<IChildProvidable, List<QuickSelection>> pair = QuickSelectionHelper.getParentAndQuickSelectionsOfConfig(config);
        if (pair != null) {
            List quickSelections = (List)pair.getSecond();
            List<QuickSelection> quickSelectionsForConfig = QuickSelectionHelper.getQuickSelectionsForConfig(config);
            return quickSelectionsForConfig.equals(quickSelections);
        }
        return false;
    }
}

