/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildProviderHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.periphs.model.config.ExpressionContext;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.IChild;
import com.nxp.swtools.periphs.model.config.IChildProvidable;
import com.nxp.swtools.periphs.model.data.ActiveComponents;
import com.nxp.swtools.periphs.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeriphsProfile
implements IChildProvidable {
    private static final Logger LOGGER = LogManager.getLogger(PeriphsProfile.class);
    private final IMcu mcu;
    private final List<FunctionalGroup> functionalGroups = new ArrayList<FunctionalGroup>();
    private final StoragePeriphsTool storageProfile;
    private Map<String, ComponentConfig> configuredComponents = new LinkedHashMap<String, ComponentConfig>();
    private ChildContext childContext;
    private final ExpressionContext expressionContext;
    private boolean yamlEnabled;
    private ActiveComponents activeComponents;
    private String activeCoreId = "";

    public PeriphsProfile(IMcu mcu, ISharedConfiguration sharedConfig) {
        this.storageProfile = new StoragePeriphsTool();
        this.yamlEnabled = sharedConfig.getPreferences().isYamlOutputEnabled();
        this.activeComponents = new ActiveComponents();
        this.mcu = mcu;
        this.childContext = new ChildContext(this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        this.storageProfile.getPeriphsProfile().setProcessorVersion(mcu.getDataVersion());
        ProcessorCore selectedCore = sharedConfig.getCommonConfig().getSelectedCore();
        if (selectedCore != null) {
            this.setActiveCoreId(selectedCore.getID());
        }
    }

    public PeriphsProfile(IMcu mcu, StoragePeriphsTool storagePeriphsTool, ISharedConfiguration sharedConfig) {
        this.yamlEnabled = sharedConfig.getPreferences().isYamlOutputEnabled();
        this.storageProfile = storagePeriphsTool;
        this.activeComponents = new ActiveComponents();
        this.mcu = mcu;
        this.childContext = new ChildContext(this);
        this.expressionContext = new ExpressionContext(this.childContext, this.mcu);
        ProcessorCore selectedCore = sharedConfig.getCommonConfig().getSelectedCore();
        if (selectedCore != null) {
            this.setActiveCoreId(selectedCore.getID());
        }
        PeriphsProfile.addRequiredComponents(storagePeriphsTool.getComponents(), storagePeriphsTool.getFuncGroups());
        ArrayList storageComponentsCopy = new ArrayList(storagePeriphsTool.getComponents());
        storageComponentsCopy.forEach(x -> {
            ConfigurationComponentTypeId configCompTypeId;
            String configuredCompTypeId = this.getConfiguredComponentTypeId(x.getName());
            if (configuredCompTypeId != null && !configuredCompTypeId.equals(x.getTypeId())) {
                LOGGER.severe("Component type id mismatch. It is not possible to create component with type: " + x.getName() + " and type id: " + x.getTypeId() + " because component of given type is already configured to use type id: " + configuredCompTypeId);
            }
            if ((configCompTypeId = this.activeComponents.getConfigCompTypeId((StoragePeriphsComponent)x)) == null) {
                configCompTypeId = mcu.getAvailableComponents().getBestMatchingConfigCompTypeId((StoragePeriphsComponent)x);
            }
            if (configCompTypeId != null) {
                ComponentConfig componentConfig = new ComponentConfig(configCompTypeId, (StoragePeriphsComponent)x, this.childContext, mcu);
                this.configuredComponents.put(configCompTypeId.getConfigurationComponent().getId(), componentConfig);
                this.activeComponents.addConfigurationComponent(componentConfig);
            } else {
                LOGGER.log(Level.SEVERE, "[DATA] Component \"" + x.getName() + "\" not found.");
            }
        });
        ArrayList funcGroupsCopy = new ArrayList(storagePeriphsTool.getFuncGroups());
        funcGroupsCopy.forEach(x -> {
            boolean bl = this.functionalGroups.add(new FunctionalGroup(this.childContext, (StoragePeriphsFuncGroup)x, mcu));
        });
        this.storageProfile.getPeriphsProfile().setProcessorVersion(mcu.getDataVersion());
        this.updateStorage();
    }

    private static void addRequiredComponents(List<StoragePeriphsComponent> availableComponents, List<StoragePeriphsFuncGroup> functionalGroups) {
        functionalGroups.stream().flatMap(fg -> fg.getInstances().stream()).forEach(i -> {
            if (availableComponents.stream().noneMatch(c -> c.getName().equals(i.getType()))) {
                StoragePeriphsComponent comp = new StoragePeriphsComponent();
                comp.setName(i.getType());
                comp.setTypeId(i.getType_id());
                availableComponents.add(comp);
            }
        });
    }

    public ActiveComponents getActiveComponents() {
        return this.activeComponents;
    }

    public StoragePeriphsTool getStoragePeripheralsTool() {
        return this.storageProfile;
    }

    public IMcu getMcu() {
        return this.mcu;
    }

    public List<FunctionalGroup> getFunctionalGroups() {
        return this.functionalGroups;
    }

    public void addFunctionalGroup(FunctionalGroup functionalGroup) {
        if (!this.functionalGroups.contains(functionalGroup)) {
            this.functionalGroups.add(functionalGroup);
            this.storageProfile.getFuncGroups().add(functionalGroup.getStorageFuncGroup());
        }
    }

    public @Nullable ComponentConfig getComponent(String type) {
        return this.configuredComponents.get(type);
    }

    public Map<String, ComponentConfig> getConfiguredComponents() {
        return CollectionsUtils.unmodifiableMap(this.configuredComponents);
    }

    public Map<String, @Nullable ConfigSetConfig> getGlobalConfigSets() {
        HashMap<String, @Nullable ConfigSetConfig> result = new HashMap<String, ConfigSetConfig>();
        this.getConfiguredComponents().values().stream().filter(component -> component.getGlobalConfigSet() != null).forEach(x -> {
            ConfigSetConfig configSetConfig = result.put(x.getName(), x.getGlobalConfigSet());
        });
        return result;
    }

    public void addComponent(ComponentConfig componentConfig) {
        this.configuredComponents.put(componentConfig.getId(), componentConfig);
        this.activeComponents.addConfigurationComponent(componentConfig);
        this.updateStorage();
    }

    public boolean removeComponent(String component) {
        @Nullable ComponentConfig componentConfig = this.configuredComponents.remove(component);
        if (Objects.nonNull(componentConfig)) {
            this.activeComponents.removeConfigurationComponent(componentConfig.getComponent());
            this.updateStorage();
            return true;
        }
        return false;
    }

    private void updateStorage() {
        this.storageProfile.setVersion(StoragePeriphsTool.VERSION);
        ArrayList newGroups = new ArrayList();
        ArrayList newComponents = new ArrayList();
        this.functionalGroups.forEach(x -> {
            boolean bl = newGroups.add(x.getStorageFuncGroup());
        });
        this.configuredComponents.values().forEach(x -> {
            boolean bl = newComponents.add(x.getStorageComponent());
        });
        this.storageProfile.setFuncGroups(newGroups);
        this.storageProfile.setComponents(newComponents);
    }

    @Override
    public String getId() {
        return "$root";
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public String getUiName() {
        return this.getId();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    @Override
    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public @Nullable IChild getChildById(String id) {
        return ChildProviderHelper.getChildRelative(this, id);
    }

    @Override
    public @Nullable IChild getChild(String name) {
        return (IChild)CollectionsUtils.nullableOptionalGet(this.functionalGroups.stream().filter(x -> x.getName().equals(name)).findFirst());
    }

    @Override
    public List<? extends IChild> getChildren() {
        return this.functionalGroups;
    }

    public boolean removeFunctionalGroup(FunctionalGroup group) {
        boolean result = this.functionalGroups.remove(group);
        this.getStoragePeripheralsTool().getFuncGroups().remove(group.getStorageFuncGroup());
        return result;
    }

    public boolean isComponentConfigured(String componentType) {
        return this.configuredComponents.containsKey(componentType);
    }

    public @Nullable String getConfiguredComponentTypeId(String componentType) {
        @Nullable ComponentConfig componentConfig = this.configuredComponents.get(componentType);
        return componentConfig == null ? null : componentConfig.getComponentTypeId();
    }

    public ArrayList<FunctionalGroup> getFunctionalGroupsWithPrefix(String prefix) {
        ArrayList<FunctionalGroup> groups = new ArrayList<FunctionalGroup>();
        for (FunctionalGroup group : this.functionalGroups) {
            if (!group.getIdPrefix().equals(prefix)) continue;
            groups.add(group);
        }
        return groups;
    }

    public int countSameIdentifierOccurences(String prefix, String identifier) {
        ArrayList<FunctionalGroup> functionalGroupsWithPrefix = this.getFunctionalGroupsWithPrefix(prefix);
        if (functionalGroupsWithPrefix.size() > 0) {
            ArrayList<String> finalNames = new ArrayList<String>();
            for (FunctionalGroup group : functionalGroupsWithPrefix) {
                finalNames.addAll(group.getListOfFinalInstanceNames());
            }
            List sameFinalNames = (List)finalNames.stream().filter(x -> x.equals(identifier)).collect(CollectorsUtils.toList());
            return sameFinalNames.size();
        }
        return 0;
    }

    public List<FunctionalGroup> getGroupsContainingIdentifier(String prefix, String identifier) {
        ArrayList<FunctionalGroup> functionalGroupsWithPrefix = this.getFunctionalGroupsWithPrefix(prefix);
        HashMap<FunctionalGroup, List<String>> groupsFinalNames = new HashMap<FunctionalGroup, List<String>>();
        for (FunctionalGroup group : functionalGroupsWithPrefix) {
            groupsFinalNames.put(group, group.getListOfFinalInstanceNames());
        }
        List groupsContainingIdentifier = (List)groupsFinalNames.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(identifier)).map(entry -> (FunctionalGroup)entry.getKey()).collect(CollectorsUtils.toList());
        return groupsContainingIdentifier;
    }

    public void clearFunctionalGroups() {
        this.functionalGroups.clear();
        this.getStoragePeripheralsTool().getFuncGroups().clear();
    }

    @Override
    public void updateStorageAvailability() {
        this.functionalGroups.stream().forEach(fg -> fg.updateStorageAvailability());
        ArrayList componentStoragesWithConfigSet = (ArrayList)this.configuredComponents.values().stream().map(c -> c.getStorageComponent()).filter(storage -> storage.getConfig_set_global() != null).collect(CollectorsUtils.toList());
        this.configuredComponents.values().forEach(c -> c.updateStorageAvailability());
        this.storageProfile.setComponents(componentStoragesWithConfigSet);
    }

    public @Nullable FunctionalGroup getFunctionalGroup(String name) {
        return (FunctionalGroup)CollectionsUtils.nullableOptionalGet(this.functionalGroups.stream().filter(x -> x.getName().equals(name)).findAny());
    }

    public @Nullable FunctionalGroup getFunctionalGroupWithUUID(String uuid) {
        return (FunctionalGroup)CollectionsUtils.nullableOptionalGet(this.functionalGroups.stream().filter(x -> x.getStorageFuncGroup().getUUID().equals(uuid)).findAny());
    }

    public boolean isYamlEnabled() {
        return this.yamlEnabled;
    }

    public void setYamlEnabled(boolean generateYaml) {
        this.yamlEnabled = generateYaml;
    }

    public List<ComponentInstanceConfig> getAllInstances() {
        ArrayList<ComponentInstanceConfig> result = new ArrayList<ComponentInstanceConfig>();
        this.functionalGroups.stream().forEach(group -> {
            Map<String, ComponentInstanceConfig> instances = group.getInstances();
            instances.values().stream().forEach(value -> {
                if (value != null) {
                    result.add((ComponentInstanceConfig)value);
                }
            });
        });
        return result;
    }

    public void clearCache() {
        this.configuredComponents.values().forEach(x -> x.clearCache());
        this.getAllInstances().forEach(c -> c.clearCache());
    }

    public String getActiveCoreId() {
        return this.activeCoreId;
    }

    public void setActiveCoreId(String activeCoreId) {
        this.activeCoreId = activeCoreId;
    }
}

