/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class PeripheralExpressionException
extends ExpressionException {
    private static final long serialVersionUID = 1L;
    private static final String DOLLAR_THIS = "$this";
    private List<ChildContext> childContexts = new LinkedList<ChildContext>();

    public boolean addChildContext(ChildContext childContext) {
        return this.childContexts.add(childContext);
    }

    public List<ChildContext> getChildContexts() {
        return this.childContexts;
    }

    public String replaceDollarThisWithCurrentValue(String messageBefore) {
        if (this.getContexts().size() > 0) {
            return messageBefore.replaceFirst(DOLLAR_THIS, "$this: " + ((IContext)this.getContexts().get(0)).getSettingValue(DOLLAR_THIS));
        }
        return messageBefore;
    }

    public PeripheralExpressionException(Class<?> originatorClass) {
        super(originatorClass);
        this.setSeverity(Level.WARNING);
    }

    public PeripheralExpressionException(String description, Class<?> originatorClass) {
        super(description, originatorClass);
        this.setSeverity(Level.WARNING);
    }

    public PeripheralExpressionException(Throwable innerException, Class<?> originatorClass) {
        super(innerException, originatorClass);
        this.setSeverity(Level.WARNING);
    }

    public PeripheralExpressionException(String description, Throwable innerException, Class<?> originatorClass) {
        super(description, innerException, originatorClass);
        this.setSeverity(Level.WARNING);
    }

    public @NonNull String getLoggableMessage() {
        ComponentInstanceConfig componentInstanceConfig;
        StringBuilder buffer = new StringBuilder();
        this.addCommonDescriptionPart(buffer);
        buffer.append("Component");
        buffer.append(": ");
        String componentName = "Unknown";
        if (this.getChildContexts().size() > 0 && (componentInstanceConfig = this.getChildContexts().get(0).getComponentInstanceConfig()) != null) {
            componentName = componentInstanceConfig.getComponentId();
        }
        buffer.append(componentName);
        buffer.append("\n");
        this.addCommonStackPart(buffer);
        buffer.append("Child contexts");
        buffer.append(": ");
        buffer.append("\n");
        buffer.append(UtilsText.join(this.getChildContexts(), (String)"\n\n"));
        this.addCommonFooter(buffer);
        String message = UtilsText.safeString((String)buffer.toString());
        return this.replaceDollarThisWithCurrentValue(message);
    }
}

