/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.model.config.ChildContext;
import com.nxp.swtools.periphs.model.config.ChildValidationHelper;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.data.Level;
import com.nxp.swtools.periphs.model.data.setting.IBaseModel;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import java.util.List;

public interface IChild
extends IToolTipable {
    public @Nullable IBaseModel getModelData();

    public String getId();

    default public String getComponentId() {
        ComponentInstanceConfig instanceConfig = this.getChildContext().getComponentInstanceConfig();
        ComponentConfig config = this.getChildContext().getComponentConfig();
        return instanceConfig != null ? instanceConfig.getId() : (config != null ? config.getId() : "");
    }

    default public String getOriginatorId() {
        return StorageDependency.makeOriginatorId((String)this.getComponentId(), (String)this.getId());
    }

    public Object getValue();

    public @NonNull String getName();

    default public @NonNull String getIdForTooltip() {
        return this.getName();
    }

    public @NonNull String getUiName();

    public boolean isAvailable();

    public boolean isEnabled();

    public ChildContext getChildContext();

    public IContext getExpressionContext();

    default public IDependency @Nullable [] getOwnDependencies(String source) {
        return null;
    }

    default public @Nullable String getProblems(Level level) {
        return ChildValidationHelper.mergeProblems(ChildValidationHelper.mergeProblems((String[])CollectionsUtils.toNullableTypeArrayUnchecked((Object[])this.getOwnProblems(level))), null);
    }

    default public String @Nullable [] getOwnProblems(Level level) {
        return null;
    }

    default public @Nullable String getError() {
        return this.getProblems(Level.ERROR);
    }

    default public @Nullable String getWarning() {
        return this.getProblems(Level.WARNING);
    }

    default public @Nullable String getInfo() {
        return this.getProblems(Level.INFO);
    }

    public void updateStorageAvailability();

    public boolean isOptionSet(String var1);

    public @Nullable Object getOptionValue(String var1);

    default public List<String> getProblemsPaths(Level level) {
        if (this.isOptionSet("UI_LABEL_HIDDEN") || this.getOwnProblems(level) == null) {
            return CollectionsUtils.asList((Object)"");
        }
        return CollectionsUtils.asList((Object)UtilsText.safeString((String)this.getUiName()));
    }

    default public int getHighestSeverityProblemLevel() {
        int highestSeverityProblemLevel = -1;
        String status = this.getError();
        if (status != null) {
            highestSeverityProblemLevel = 2;
        } else if (this.getWarning() != null) {
            highestSeverityProblemLevel = 1;
        } else if (this.getInfo() != null) {
            highestSeverityProblemLevel = 0;
        }
        return highestSeverityProblemLevel;
    }

    default public String makeOriginatorId(ChildContext context) {
        ComponentInstanceConfig instanceConfig = context.getComponentInstanceConfig();
        ComponentConfig componentConfig = context.getComponentConfig();
        String componentId = instanceConfig != null ? instanceConfig.getId() : (componentConfig != null ? componentConfig.getId() : "");
        return StorageDependency.makeOriginatorId((String)componentId, (String)this.getId());
    }
}

